/*
 * Decompiled with CFR 0.152.
 */
package net.natte.tankstorage.storage;

import net.natte.tankstorage.storage.SlotFluidHandler;
import net.natte.tankstorage.util.FluidSlotData;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public class TankSingleFluidStorage {
    private final int capacity;
    private int amount;
    private FluidStack fluidVariant;
    private boolean isLocked;
    private Runnable onMarkDirty;

    public TankSingleFluidStorage(int capacity, int amount, FluidStack fluidVariant, boolean isLocked) {
        this.capacity = capacity;
        this.amount = amount;
        this.fluidVariant = fluidVariant;
        this.isLocked = isLocked;
    }

    public TankSingleFluidStorage(int capacity) {
        this(capacity, 0, FluidStack.EMPTY, false);
    }

    public void setMarkDirtyListener(Runnable listener) {
        this.onMarkDirty = listener;
    }

    public TankSingleFluidStorage update(int amount, FluidStack fluidVariant, boolean isLocked) {
        this.amount = amount;
        this.fluidVariant = fluidVariant;
        this.isLocked = isLocked;
        return this;
    }

    public int insert(FluidStack insertedVariant, int maxAmount, boolean simulate) {
        if (!this.canInsert(insertedVariant)) {
            return 0;
        }
        int space = this.capacity - this.amount;
        int insertedAmount = Math.min(maxAmount, space);
        if (insertedAmount > 0 && !simulate) {
            this.amount += insertedAmount;
            if (this.fluidVariant.isEmpty()) {
                this.fluidVariant = insertedVariant.copyWithAmount(1);
            }
            this.markDirty();
        }
        return insertedAmount;
    }

    public int extract(FluidStack extractedVariant, int maxAmount, boolean simulate) {
        if (!this.canExtract(extractedVariant)) {
            return 0;
        }
        int extractedAmount = Math.min(maxAmount, this.amount);
        if (extractedAmount > 0 && !simulate) {
            this.amount -= extractedAmount;
            if (this.amount == 0 && !this.isLocked) {
                this.fluidVariant = FluidStack.EMPTY;
            }
            this.markDirty();
        }
        return extractedAmount;
    }

    public boolean canInsert(FluidStack insertedVariant) {
        if (insertedVariant.isEmpty()) {
            return false;
        }
        if (this.fluidVariant.isEmpty()) {
            return !this.isLocked;
        }
        return FluidStack.isSameFluidSameComponents((FluidStack)this.fluidVariant, (FluidStack)insertedVariant);
    }

    private boolean canExtract(FluidStack extractedVariant) {
        if (extractedVariant.isEmpty()) {
            return false;
        }
        return FluidStack.isSameFluidSameComponents((FluidStack)this.fluidVariant, (FluidStack)extractedVariant);
    }

    public FluidStack getFluid() {
        return this.fluidVariant;
    }

    public int getAmount() {
        return this.amount;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public boolean isLocked() {
        return this.isLocked;
    }

    private void markDirty() {
        if (this.onMarkDirty != null) {
            this.onMarkDirty.run();
        }
    }

    public void lock(FluidStack newFluidVariant, boolean shouldLock) {
        if (shouldLock) {
            if (this.amount == 0) {
                this.fluidVariant = newFluidVariant.copyWithAmount(1);
                this.isLocked = true;
            } else if (FluidStack.isSameFluid((FluidStack)this.fluidVariant, (FluidStack)newFluidVariant)) {
                this.isLocked = true;
            }
        } else {
            this.isLocked = false;
            if (this.amount == 0) {
                this.fluidVariant = FluidStack.EMPTY;
            }
        }
        this.markDirty();
    }

    public static TankSingleFluidStorage from(FluidSlotData fluidSlotData) {
        return new TankSingleFluidStorage(fluidSlotData.capacity(), fluidSlotData.amount(), fluidSlotData.fluidVariant(), fluidSlotData.isLocked());
    }

    public IFluidHandler getFluidHandler() {
        return new SlotFluidHandler(this);
    }
}

