/*
 * Decompiled with CFR 0.152.
 */
package net.natte.tankstorage.storage;

import java.util.List;
import net.minecraft.world.item.ItemStack;
import net.natte.tankstorage.storage.InsertMode;
import net.natte.tankstorage.storage.TankSingleFluidStorage;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;

public class TankFluidHandler
implements IFluidHandlerItem {
    private boolean canExtract = true;
    private FluidStack extractFilter = null;
    private final List<TankSingleFluidStorage> parts;
    private final InsertMode insertMode;
    private ItemStack item = ItemStack.EMPTY;

    public TankFluidHandler(List<TankSingleFluidStorage> parts, InsertMode insertMode) {
        this.parts = parts;
        this.insertMode = insertMode;
    }

    public TankFluidHandler withItem(ItemStack item) {
        this.item = item;
        return this;
    }

    public TankFluidHandler insertOnly() {
        this.canExtract = false;
        return this;
    }

    public TankFluidHandler extractOnly(FluidStack extractFilter) {
        this.extractFilter = extractFilter;
        return this;
    }

    public int getTanks() {
        return this.parts.size();
    }

    public FluidStack getFluidInTank(int tank) {
        TankSingleFluidStorage singleTank = this.parts.get(tank);
        if (singleTank.getAmount() == 0) {
            return FluidStack.EMPTY;
        }
        return singleTank.getFluid().copyWithAmount(singleTank.getAmount());
    }

    public int getTankCapacity(int tank) {
        return this.parts.get(tank).getCapacity();
    }

    public boolean isFluidValid(int tank, FluidStack stack) {
        return true;
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        if (resource.isEmpty()) {
            return 0;
        }
        if (this.extractFilter != null && !FluidStack.isSameFluidSameComponents((FluidStack)this.extractFilter, (FluidStack)resource)) {
            return 0;
        }
        int maxAmount = resource.getAmount();
        int inserted = 0;
        switch (this.insertMode) {
            case ALL: {
                inserted += this.fillLockedSlots(resource, maxAmount - inserted, action.simulate());
                inserted += this.fillNonEmptySlots(resource, maxAmount - inserted, action.simulate());
                inserted += this.fillAnySlots(resource, maxAmount - inserted, action.simulate());
                break;
            }
            case FILTERED: {
                inserted += this.fillLockedSlots(resource, maxAmount - inserted, action.simulate());
                inserted += this.fillNonEmptySlots(resource, maxAmount - inserted, action.simulate());
                break;
            }
            case VOID_OVERFLOW: {
                inserted += this.fillLockedSlots(resource, maxAmount - inserted, action.simulate());
                inserted += this.fillNonEmptySlots(resource, maxAmount - inserted, action.simulate());
                if (!this.hasSlotWithFluid(resource)) break;
                inserted = maxAmount;
            }
        }
        return inserted;
    }

    private int fillLockedSlots(FluidStack resource, int maxAmount, boolean simulate) {
        if (maxAmount == 0) {
            return 0;
        }
        int inserted = 0;
        for (TankSingleFluidStorage tank : this.parts) {
            if (!tank.isLocked()) continue;
            inserted += tank.insert(resource, maxAmount - inserted, simulate);
        }
        return inserted;
    }

    private int fillNonEmptySlots(FluidStack resource, int maxAmount, boolean simulate) {
        if (maxAmount == 0) {
            return 0;
        }
        int inserted = 0;
        for (TankSingleFluidStorage tank : this.parts) {
            if (tank.getAmount() <= 0) continue;
            inserted += tank.insert(resource, maxAmount - inserted, simulate);
        }
        return inserted;
    }

    private int fillAnySlots(FluidStack resource, int maxAmount, boolean simulate) {
        if (maxAmount == 0) {
            return 0;
        }
        int inserted = 0;
        for (TankSingleFluidStorage tank : this.parts) {
            inserted += tank.insert(resource, maxAmount - inserted, simulate);
        }
        return inserted;
    }

    private boolean hasSlotWithFluid(FluidStack resource) {
        for (TankSingleFluidStorage tank : this.parts) {
            if (!FluidStack.isSameFluidSameComponents((FluidStack)tank.getFluid(), (FluidStack)resource)) continue;
            return true;
        }
        return false;
    }

    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        if (!this.canExtract(resource)) {
            return FluidStack.EMPTY;
        }
        int maxAmount = resource.getAmount();
        int extracted = 0;
        for (TankSingleFluidStorage tank : this.parts) {
            extracted += tank.extract(resource, maxAmount - extracted, action.simulate());
        }
        return resource.copyWithAmount(extracted);
    }

    public FluidStack drain(int maxAmount, IFluidHandler.FluidAction action) {
        if (!this.canExtract) {
            return FluidStack.EMPTY;
        }
        FluidStack resource = this.extractFilter;
        int extracted = 0;
        for (TankSingleFluidStorage tank : this.parts) {
            if (resource == null && !tank.getFluid().isEmpty() && tank.getAmount() > 0) {
                resource = tank.getFluid();
            }
            if (resource == null) continue;
            extracted += tank.extract(resource, maxAmount - extracted, action.simulate());
        }
        return extracted == 0 ? FluidStack.EMPTY : resource.copyWithAmount(extracted);
    }

    private boolean canExtract(FluidStack resource) {
        if (!this.canExtract) {
            return false;
        }
        if (this.extractFilter == null) {
            return true;
        }
        return FluidStack.isSameFluidSameComponents((FluidStack)this.extractFilter, (FluidStack)resource);
    }

    public ItemStack getContainer() {
        return this.item;
    }
}

