/*
 * Decompiled with CFR 0.152.
 */
package net.natte.tankstorage.storage;

import net.natte.tankstorage.storage.TankSingleFluidStorage;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public class SlotFluidHandler
implements IFluidHandler {
    private final TankSingleFluidStorage fluidStorage;

    public SlotFluidHandler(TankSingleFluidStorage fluidStorage) {
        this.fluidStorage = fluidStorage;
    }

    public int getTanks() {
        return 1;
    }

    public FluidStack getFluidInTank(int tank) {
        return this.fluidStorage.getFluid().copyWithAmount(this.fluidStorage.getAmount());
    }

    public int getTankCapacity(int tank) {
        return this.fluidStorage.getCapacity();
    }

    public boolean isFluidValid(int tank, FluidStack stack) {
        return true;
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        return this.fluidStorage.insert(resource, resource.getAmount(), action.simulate());
    }

    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        int extracted = this.fluidStorage.extract(resource, resource.getAmount(), action.simulate());
        return resource.copyWithAmount(extracted);
    }

    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        FluidStack resource = this.fluidStorage.getFluid();
        int extracted = this.fluidStorage.extract(resource, maxDrain, action.simulate());
        return resource.copyWithAmount(extracted);
    }
}

