/*
 * Decompiled with CFR 0.152.
 */
package net.natte.tankstorage.packet.server;

import io.netty.buffer.ByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.natte.tankstorage.TankStorage;
import net.natte.tankstorage.block.TankDockBlockEntity;
import net.natte.tankstorage.menu.TankMenu;
import net.natte.tankstorage.storage.TankOptions;
import net.natte.tankstorage.util.Texts;
import net.natte.tankstorage.util.Util;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record ToggleInsertModePacketC2S() implements CustomPacketPayload
{
    public static final ToggleInsertModePacketC2S INSTANCE = new ToggleInsertModePacketC2S();
    public static final CustomPacketPayload.Type<ToggleInsertModePacketC2S> TYPE = new CustomPacketPayload.Type(Util.ID("toggleinsertmode_c2s"));
    public static final StreamCodec<ByteBuf, ToggleInsertModePacketC2S> STREAM_CODEC = StreamCodec.unit((Object)INSTANCE);

    public CustomPacketPayload.Type<ToggleInsertModePacketC2S> type() {
        return TYPE;
    }

    public static void receive(ToggleInsertModePacketC2S packet, IPayloadContext context) {
        ServerPlayer player = (ServerPlayer)context.player();
        AbstractContainerMenu abstractContainerMenu = player.containerMenu;
        if (abstractContainerMenu instanceof TankMenu) {
            TankMenu tankMenu = (TankMenu)abstractContainerMenu;
            ToggleInsertModePacketC2S.toggleInsertModeOfScreenHandler(player, tankMenu);
        } else {
            ToggleInsertModePacketC2S.toggleInsertModeOfHeldTank(player);
        }
    }

    private static void toggleInsertModeOfScreenHandler(ServerPlayer player, TankMenu tankMenu) {
        ItemStack tank = tankMenu.getTankItem();
        tank.update(TankStorage.OptionsComponentType, (Object)TankOptions.create(), TankOptions::nextInsertMode);
        tankMenu.getAccess().execute((world, blockPos) -> world.getBlockEntity(blockPos, (BlockEntityType)TankStorage.TANK_DOCK_BLOCK_ENTITY.get()).ifPresent(TankDockBlockEntity::setChanged));
    }

    private static void toggleInsertModeOfHeldTank(ServerPlayer player) {
        ItemStack stack;
        if (Util.isTankLike(player.getMainHandItem())) {
            stack = player.getMainHandItem();
        } else if (Util.isTankLike(player.getOffhandItem())) {
            stack = player.getOffhandItem();
        } else {
            return;
        }
        stack.update(TankStorage.OptionsComponentType, (Object)TankOptions.create(), TankOptions::nextInsertMode);
        player.displayClientMessage(Texts.insertModePopup(Util.getInsertMode(stack)), true);
    }
}

