/*
 * Decompiled with CFR 0.152.
 */
package net.natte.tankstorage.packet.server;

import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.natte.tankstorage.gui.FluidSlot;
import net.natte.tankstorage.menu.TankMenu;
import net.natte.tankstorage.packet.screenHandler.SyncFluidPacketS2C;
import net.natte.tankstorage.util.FluidSlotData;
import net.natte.tankstorage.util.Util;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record LockSlotPacketC2S(int syncId, int slot, FluidStack fluid, boolean shouldLock) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<LockSlotPacketC2S> TYPE = new CustomPacketPayload.Type(Util.ID("lock_slot_c2s"));
    public static final StreamCodec<RegistryFriendlyByteBuf, LockSlotPacketC2S> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, LockSlotPacketC2S::syncId, (StreamCodec)ByteBufCodecs.INT, LockSlotPacketC2S::slot, (StreamCodec)FluidStack.OPTIONAL_STREAM_CODEC, LockSlotPacketC2S::fluid, (StreamCodec)ByteBufCodecs.BOOL, LockSlotPacketC2S::shouldLock, LockSlotPacketC2S::new);

    public CustomPacketPayload.Type<LockSlotPacketC2S> type() {
        return TYPE;
    }

    public static void receive(LockSlotPacketC2S packet, IPayloadContext context) {
        AbstractContainerMenu abstractContainerMenu = context.player().containerMenu;
        if (abstractContainerMenu instanceof TankMenu) {
            Slot slot;
            TankMenu tankMenu = (TankMenu)abstractContainerMenu;
            if (packet.syncId == tankMenu.containerId && !tankMenu.lockSlot(packet.slot, packet.fluid, packet.shouldLock) && packet.slot >= 0 && packet.slot < tankMenu.slots.size() && (slot = tankMenu.getSlot(packet.slot)) instanceof FluidSlot) {
                FluidSlot fluidSlot = (FluidSlot)slot;
                FluidSlotData fluidSlotData = new FluidSlotData(fluidSlot.getFluid(), fluidSlot.getCapacity(), fluidSlot.getAmount(), fluidSlot.isLocked());
                context.reply((CustomPacketPayload)new SyncFluidPacketS2C(packet.syncId, packet.slot, fluidSlotData));
            }
        }
    }
}

