/*
 * Decompiled with CFR 0.152.
 */
package net.natte.tankstorage.compat.emi;

import dev.emi.emi.api.EmiDragDropHandler;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.Holder;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.natte.tankstorage.client.screen.TankScreen;
import net.natte.tankstorage.gui.FluidSlot;
import net.natte.tankstorage.menu.TankMenu;
import net.natte.tankstorage.packet.server.LockSlotPacketC2S;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;

public class TankDragDropHandler
implements EmiDragDropHandler<TankScreen> {
    public boolean dropStack(TankScreen screen, EmiIngredient ingredient, int x, int y) {
        Slot slot = screen.getSlotUnderMouse();
        if (!(slot instanceof FluidSlot)) {
            return false;
        }
        FluidSlot fluidSlot = (FluidSlot)slot;
        FluidStack fluidStack = this.getFluid(ingredient);
        if (fluidStack == null) {
            return false;
        }
        ((TankMenu)screen.getMenu()).lockSlot(fluidSlot.index, fluidStack);
        PacketDistributor.sendToServer((CustomPacketPayload)new LockSlotPacketC2S(((TankMenu)screen.getMenu()).containerId, fluidSlot.index, fluidStack, true), (CustomPacketPayload[])new CustomPacketPayload[0]);
        return true;
    }

    public void render(TankScreen screen, EmiIngredient dragged, GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        FluidStack fluidStack = this.getFluid(dragged);
        if (fluidStack == null) {
            return;
        }
        for (Slot slot : ((TankMenu)screen.getMenu()).slots) {
            FluidSlot fluidSlot;
            if (!(slot instanceof FluidSlot) || (fluidSlot = (FluidSlot)slot).getAmount() != 0 && (fluidSlot.isLocked() || !FluidStack.isSameFluidSameComponents((FluidStack)fluidSlot.getFluid(), (FluidStack)fluidStack))) continue;
            int x = screen.getGuiLeft() + slot.x;
            int y = screen.getGuiTop() + slot.y;
            guiGraphics.fill(x, y, x + 16, y + 16, -2010989773);
        }
    }

    @Nullable
    private FluidStack getFluid(EmiIngredient ingredient) {
        EmiStack emiStack = (EmiStack)ingredient.getEmiStacks().getFirst();
        Object object = emiStack.getKey();
        if (object instanceof Fluid) {
            Fluid fluid = (Fluid)object;
            return new FluidStack(Holder.direct((Object)fluid), 1, emiStack.getComponentChanges());
        }
        return FluidUtil.getFluidContained((ItemStack)emiStack.getItemStack()).orElse(null);
    }
}

