/*
 * Decompiled with CFR 0.152.
 */
package net.natte.tankstorage.client.rendering;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.math.BigDecimal;
import java.math.MathContext;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.inventory.InventoryMenu;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.client.textures.FluidSpriteCache;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidType;
import org.joml.Matrix4f;

public class FluidRenderer {
    public static void drawFluidInGui(GuiGraphics guiGraphics, FluidStack fluid, float x, float y, boolean transparent) {
        assert (!fluid.isEmpty()) : "cannot draw empty fluid";
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)InventoryMenu.BLOCK_ATLAS);
        TextureAtlasSprite sprite = FluidRenderer.getSprite(fluid);
        RenderSystem.disableDepthTest();
        RenderSystem.enableBlend();
        RenderSystem.setShader(GameRenderer::getPositionTexColorShader);
        BufferBuilder bufferBuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR);
        float x0 = x;
        float y0 = y;
        float x1 = x0 + 16.0f;
        float y1 = y0 + 16.0f;
        float z = 0.5f;
        float u0 = sprite.getU0();
        float v0 = sprite.getV0();
        float u1 = sprite.getU1();
        float v1 = sprite.getV1();
        int color = FastColor.ARGB32.color((int)(transparent ? 127 : 255), (int)FluidRenderer.getColor(fluid));
        Matrix4f model = guiGraphics.pose().last().pose();
        bufferBuilder.addVertex(model, x0, y1, z).setUv(u0, v1).setColor(color);
        bufferBuilder.addVertex(model, x1, y1, z).setUv(u1, v1).setColor(color);
        bufferBuilder.addVertex(model, x1, y0, z).setUv(u1, v0).setColor(color);
        bufferBuilder.addVertex(model, x0, y0, z).setUv(u0, v0).setColor(color);
        BufferUploader.drawWithShader((MeshData)bufferBuilder.buildOrThrow());
        RenderSystem.enableDepthTest();
    }

    public static void drawFluidCount(Font textRenderer, GuiGraphics context, long amount, int x, int y) {
        Component countText = FluidRenderer.getFormattedFluidCount(amount);
        int textWidth = textRenderer.width((FormattedText)countText);
        int xOffset = x + 18 - 2;
        int yOffset = y + 18 - 2;
        int guiScale = (int)Minecraft.getInstance().getWindow().getGuiScale();
        float scale = guiScale == 1 ? 1.0f : (float)((int)((float)guiScale * 0.7f)) / (float)guiScale;
        PoseStack matrices = context.pose();
        matrices.pushPose();
        matrices.translate((float)xOffset, (float)yOffset, 0.0f);
        matrices.scale(scale, scale, 1.0f);
        matrices.translate((float)(-xOffset), (float)(-yOffset), 0.0f);
        context.drawString(textRenderer, countText, x + 18 - 1 - textWidth - 1, y + 9 - 1, -1, true);
        matrices.popPose();
    }

    private static Component getFormattedFluidCount(long amount) {
        if (amount == 0L) {
            return Component.literal((String)"0");
        }
        int BUCKET = 1000;
        MathContext significantDigits = new MathContext(3);
        long roundedAmount = new BigDecimal((double)amount * 1.0 / 1000.0).round(significantDigits).multiply(new BigDecimal(1000)).longValue();
        if ((amount = roundedAmount) < 1000L) {
            double num = (double)((long)((double)(amount * 1000L) * 1000.0 / 1000.0 / 1000.0)) / 1000.0;
            return Component.literal((String)(num > 1.0 ? "" + num : ("" + num).substring(1)));
        }
        if (amount < 1000000L) {
            BigDecimal num = new BigDecimal((double)amount * 1.0 / 1000.0).round(significantDigits);
            return Component.literal((String)num.toString());
        }
        if (amount < 1000000000L) {
            BigDecimal num = new BigDecimal((double)amount / 1000.0 / 1000.0).round(significantDigits);
            return Component.literal((String)(num.longValue() + "k"));
        }
        BigDecimal num = new BigDecimal((double)amount / 1000.0 / 1000.0 / 1000.0).round(significantDigits);
        return Component.literal((String)(String.valueOf(num) + "M"));
    }

    private static IClientFluidTypeExtensions getExtensions(FluidStack variant) {
        return IClientFluidTypeExtensions.of((FluidType)variant.getFluidType());
    }

    public static TextureAtlasSprite getSprite(FluidStack fluidVariant) {
        return FluidSpriteCache.getSprite((ResourceLocation)FluidRenderer.getExtensions(fluidVariant).getStillTexture());
    }

    public static int getColor(FluidStack fluidVariant) {
        return FluidRenderer.getExtensions(fluidVariant).getTintColor();
    }
}

