/*
 * Decompiled with CFR 0.152.
 */
package net.natte.tankstorage.client.helpers;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.natte.tankstorage.client.helpers.TextHelper;
import net.neoforged.neoforge.fluids.FluidStack;

public class FluidHelper {
    static final int BUCKET = 1000;

    public static List<Component> appendTooltipForFluidStorage(List<Component> tooltip, FluidStack fluidStack, long amount, long capacity) {
        if (!fluidStack.isEmpty()) {
            tooltip.add(fluidStack.getFluidType().getDescription(fluidStack));
            if (Minecraft.getInstance().options.advancedItemTooltips) {
                tooltip.add((Component)Component.literal((String)BuiltInRegistries.FLUID.getKey((Object)fluidStack.getFluid()).toString()).withStyle(ChatFormatting.DARK_GRAY));
            }
        }
        tooltip.add(FluidHelper.getFluidAmount(amount, capacity));
        return tooltip;
    }

    private static Component getFluidAmount(long amount, long capacity) {
        if (capacity < 100000L || Screen.hasShiftDown()) {
            return Component.literal((String)(amount + " / " + capacity + " mB"));
        }
        TextHelper.MaxedAmount maxedAmount = TextHelper.getMaxedAmount((double)amount / 1000.0, (double)capacity / 1000.0);
        return Component.literal((String)(maxedAmount.digit() + " / " + maxedAmount.maxDigit() + " " + maxedAmount.unit() + "B"));
    }
}

