/*
 * Decompiled with CFR 0.152.
 */
package net.natte.tankstorage.client;

import com.mojang.blaze3d.platform.InputConstants;
import java.util.Set;
import java.util.UUID;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.DyedItemColor;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.natte.tankstorage.TankStorage;
import net.natte.tankstorage.cache.CachedFluidStorageState;
import net.natte.tankstorage.cache.ClientTankCache;
import net.natte.tankstorage.client.events.MouseEvents;
import net.natte.tankstorage.client.rendering.HudRenderer;
import net.natte.tankstorage.client.rendering.TankDockBlockEntityRenderer;
import net.natte.tankstorage.client.screen.TankScreen;
import net.natte.tankstorage.client.tooltip.TankTooltipComponent;
import net.natte.tankstorage.container.TankType;
import net.natte.tankstorage.item.tooltip.TankTooltipData;
import net.natte.tankstorage.packet.server.OpenTankFromKeyBindPacketC2S;
import net.natte.tankstorage.packet.server.RequestTankPacketC2S;
import net.natte.tankstorage.packet.server.ToggleInsertModePacketC2S;
import net.natte.tankstorage.util.Util;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.RegisterClientTooltipComponentFactoriesEvent;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.client.settings.IKeyConflictContext;
import net.neoforged.neoforge.client.settings.KeyConflictContext;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.network.PacketDistributor;

@Mod(value="tankstorage", dist={Dist.CLIENT})
public class TankStorageClient {
    public static final KeyMapping lockSlotKeyBinding = new KeyMapping("key.tankstorage.lockslot", (IKeyConflictContext)KeyConflictContext.GUI, InputConstants.Type.KEYSYM, 342, "category.tankstorage");
    public static final KeyMapping toggleInsertModeKeyBinding = new KeyMapping("key.tankstorage.toggleinsertmode", (IKeyConflictContext)KeyConflictContext.IN_GAME, InputConstants.UNKNOWN, "category.tankstorage");
    public static final KeyMapping toggleInteractionModeKeyBinding = new KeyMapping("key.tankstorage.toggleinteractionmode", (IKeyConflictContext)KeyConflictContext.IN_GAME, InputConstants.UNKNOWN, "category.tankstorage");
    public static final KeyMapping openTankFromKeyBinding = new KeyMapping("key.tankstorage.opentankfromkeybind", (IKeyConflictContext)KeyConflictContext.IN_GAME, InputConstants.UNKNOWN, "category.tankstorage");
    public static final HudRenderer tankHudRenderer = new HudRenderer();

    public TankStorageClient(IEventBus modBus) {
        modBus.addListener(this::registerMenuScreens);
        modBus.addListener(this::registerItemColors);
        modBus.addListener(this::registerModelPredicates);
        modBus.addListener(this::registerKeyBinds);
        modBus.addListener(this::registerTooltipComponents);
        modBus.addListener(this::registerRenderers);
        modBus.addListener(this::initializeClientOnRenderThread);
        NeoForge.EVENT_BUS.addListener(this::handleTickEvents);
        NeoForge.EVENT_BUS.addListener(tankHudRenderer::render);
        NeoForge.EVENT_BUS.addListener(MouseEvents::onScroll);
    }

    private void registerMenuScreens(RegisterMenuScreensEvent event) {
        event.register((MenuType)TankStorage.TANK_MENU.get(), TankScreen::new);
    }

    private void registerRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerBlockEntityRenderer((BlockEntityType)TankStorage.TANK_DOCK_BLOCK_ENTITY.get(), TankDockBlockEntityRenderer::new);
    }

    private void registerItemColors(RegisterColorHandlersEvent.Item event) {
        for (TankType type : TankStorage.TANK_TYPES) {
            event.register((stack, tintIndex) -> DyedItemColor.getOrDefault((ItemStack)stack, (int)0), new ItemLike[]{type.getItem()});
        }
        event.register((stack, tintIndex) -> DyedItemColor.getOrDefault((ItemStack)stack, (int)0), new ItemLike[]{(ItemLike)TankStorage.TANK_LINK_ITEM.get()});
    }

    private void registerModelPredicates(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            for (TankType type : TankStorage.TANK_TYPES) {
                ItemProperties.register((Item)type.getItem(), (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"has_color"), (stack, level, entity, seed) -> stack.has(DataComponents.DYED_COLOR) ? 1.0f : 0.0f);
            }
            ItemProperties.register((Item)((Item)TankStorage.TANK_LINK_ITEM.get()), (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"has_color"), (stack, level, entity, seed) -> stack.has(DataComponents.DYED_COLOR) ? 1.0f : 0.0f);
        });
    }

    private void initializeClientOnRenderThread(FMLClientSetupEvent event) {
        event.enqueueWork(() -> Util.isClient.set(true));
    }

    public void registerKeyBinds(RegisterKeyMappingsEvent event) {
        event.register(toggleInteractionModeKeyBinding);
        event.register(toggleInsertModeKeyBinding);
        event.register(lockSlotKeyBinding);
        event.register(openTankFromKeyBinding);
    }

    private void handleTickEvents(ClientTickEvent.Post event) {
        this.handleInputs();
        tankHudRenderer.tick();
        ClientTankCache.advanceThrottledQueue();
        this.sendQueuedRequests();
    }

    private void handleInputs() {
        while (toggleInsertModeKeyBinding.consumeClick()) {
            PacketDistributor.sendToServer((CustomPacketPayload)ToggleInsertModePacketC2S.INSTANCE, (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        while (toggleInteractionModeKeyBinding.consumeClick()) {
            MouseEvents.onToggleInteractionMode();
        }
        while (openTankFromKeyBinding.consumeClick()) {
            PacketDistributor.sendToServer((CustomPacketPayload)OpenTankFromKeyBindPacketC2S.INSTANCE, (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    private void registerTooltipComponents(RegisterClientTooltipComponentFactoriesEvent event) {
        event.register(TankTooltipData.class, TankTooltipComponent::new);
    }

    private void sendQueuedRequests() {
        Set<UUID> requestQueue = ClientTankCache.getQueue();
        for (UUID uuid : requestQueue) {
            CachedFluidStorageState state = ClientTankCache.get(uuid);
            int revision = state == null ? -1 : state.getRevision();
            PacketDistributor.sendToServer((CustomPacketPayload)new RequestTankPacketC2S(uuid, revision), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        requestQueue.clear();
    }

    static {
        Util.isShiftDown = Screen::hasShiftDown;
    }
}

