/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.inventory;

import com.brandon3055.draconicevolution.inventory.InventoryCache;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class ContainerRecipeBuilder
extends AbstractContainerMenu {
    private Player player;
    public InventoryCache inventoryCache = new InventoryCache(20);
    private List<Slot> craftingSlots = new LinkedList<Slot>();

    public ContainerRecipeBuilder(@Nullable MenuType<?> type, int id, Player player) {
        super(type, id);
        this.player = player;
    }

    public void addSlots() {
        int posX = 20;
        int posY = 145;
        for (int x = 0; x < 9; ++x) {
            this.addSlot(new Slot((Container)this.player.getInventory(), x, posX + 18 * x, posY + 58));
        }
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.addSlot(new Slot((Container)this.player.getInventory(), x + y * 9 + 9, posX + 18 * x, posY + y * 18));
            }
        }
        for (int i = 0; i < this.inventoryCache.getContainerSize(); ++i) {
            Slot slot = new Slot((Container)this.inventoryCache, i, 1000, 1000);
            this.addSlot(slot);
            this.craftingSlots.add(slot);
        }
    }

    public void arangeCraftingSlots(int craftingType) {
        for (Slot slot : this.craftingSlots) {
            slot.y = 1000;
            slot.x = 1000;
        }
        if (craftingType == 0) {
            int posX = 20;
            int posY = 30;
            for (int y = 0; y < 3; ++y) {
                for (int x = 0; x < 3; ++x) {
                    this.craftingSlots.get((int)(x + y * 3 + 1)).x = posX + 18 * x;
                    this.craftingSlots.get((int)(x + y * 3 + 1)).y = posY + y * 18;
                }
            }
            this.craftingSlots.get((int)0).x = 107;
            this.craftingSlots.get((int)0).y = posY + 18;
        } else if (craftingType == 1) {
            this.craftingSlots.get((int)0).x = 72;
            this.craftingSlots.get((int)0).y = 20;
            this.craftingSlots.get((int)1).x = 108;
            this.craftingSlots.get((int)1).y = 20;
            for (int i = 2; i < 11; ++i) {
                this.craftingSlots.get((int)i).x = 20 + (i - 2) * 18;
                this.craftingSlots.get((int)i).y = 50;
                this.craftingSlots.get((int)(i + 9)).x = 20 + (i - 2) * 18;
                this.craftingSlots.get((int)(i + 9)).y = 68;
            }
        }
    }

    @Nullable
    public ItemStack quickMoveStack(Player playerIn, int index) {
        Slot slot = this.getSlot(index);
        if (slot.hasItem()) {
            ItemStack stack = slot.getItem();
            ItemStack result = stack.copy();
            if (index >= 36 ? !this.moveItemStackTo(stack, 0, 36, false) : stack.getBurnTime(null) == 0 || !this.moveItemStackTo(stack, 36, 36 + this.inventoryCache.getContainerSize(), false)) {
                return ItemStack.EMPTY;
            }
            if (stack.getCount() == 0) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            slot.onTake(this.player, stack);
            return result;
        }
        return ItemStack.EMPTY;
    }

    public boolean stillValid(Player playerIn) {
        return true;
    }
}

