/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.entity;

import codechicken.lib.vec.Vector3;
import com.brandon3055.brandonscore.network.BCoreNetwork;
import com.brandon3055.brandonscore.worldentity.WorldEntity;
import com.brandon3055.brandonscore.worldentity.WorldEntityHandler;
import com.brandon3055.draconicevolution.DEConfig;
import com.brandon3055.draconicevolution.entity.guardian.GuardianFightManager;
import com.brandon3055.draconicevolution.handlers.DESounds;
import com.brandon3055.draconicevolution.init.DEContent;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.material.PushReaction;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class GuardianCrystalEntity
extends Entity {
    private static final EntityDataAccessor<Optional<BlockPos>> BEAM_TARGET = SynchedEntityData.defineId(GuardianCrystalEntity.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_BLOCK_POS);
    private static final EntityDataAccessor<Boolean> SHOW_BOTTOM = SynchedEntityData.defineId(GuardianCrystalEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Float> SHIELD_POWER = SynchedEntityData.defineId(GuardianCrystalEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> BEAM_POWER = SynchedEntityData.defineId(GuardianCrystalEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Integer> UNSTABLE_TIME = SynchedEntityData.defineId(GuardianCrystalEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private UUID managerId;
    public int time;
    private int beamChargeAnim = 0;

    public GuardianCrystalEntity(EntityType<?> type, Level world) {
        super(type, world);
        this.blocksBuilding = true;
        this.time = this.random.nextInt(100000);
    }

    public GuardianCrystalEntity(Level worldIn, double x, double y, double z, UUID managerId) {
        this((EntityType)DEContent.ENTITY_GUARDIAN_CRYSTAL.get(), worldIn);
        this.managerId = managerId;
        this.setPos(x, y, z);
    }

    public UUID getManagerId() {
        return this.managerId;
    }

    public void setUnstableTime(int unstableTime) {
        this.entityData.set(UNSTABLE_TIME, (Object)unstableTime);
    }

    public int getUnstableTime() {
        return (Integer)this.entityData.get(UNSTABLE_TIME);
    }

    public float getShieldPower() {
        return ((Float)this.entityData.get(SHIELD_POWER)).floatValue();
    }

    public void setShieldPower(float shieldPower) {
        this.entityData.set(SHIELD_POWER, (Object)Float.valueOf(shieldPower));
    }

    public void setManagerId(UUID managerId) {
        this.managerId = managerId;
    }

    public PushReaction getPistonPushReaction() {
        return PushReaction.IGNORE;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(BEAM_TARGET, Optional.empty());
        builder.define(SHOW_BOTTOM, (Object)true);
        builder.define(SHIELD_POWER, (Object)Float.valueOf(Math.max(20.0f, (float)DEConfig.guardianCrystalShield)));
        builder.define(UNSTABLE_TIME, (Object)0);
        builder.define(BEAM_POWER, (Object)Float.valueOf(1.0f));
    }

    public void tick() {
        ++this.time;
        if (this.level() instanceof ServerLevel) {
            GuardianFightManager manager;
            BlockPos blockpos = this.blockPosition();
            if (this.getManagerId() != null && this.level().getBlockState(blockpos).isAir()) {
                this.level().setBlockAndUpdate(blockpos, BaseFireBlock.getState((BlockGetter)this.level(), (BlockPos)blockpos));
            }
            if ((manager = this.getManager()) != null) {
                if (this.getUnstableTime() > 0) {
                    this.setBeamTarget(null);
                    this.setUnstableTime(this.getUnstableTime() - 1);
                    if (this.getUnstableTime() > 0) {
                        for (int i = 0; i < 3; ++i) {
                            BCoreNetwork.sendParticle((Level)this.level(), (ParticleOptions)ParticleTypes.FIREWORK, (Vector3)Vector3.fromEntity((Entity)this), (Vector3)new Vector3((double)this.random.nextFloat(), 0.5 + (double)(this.random.nextFloat() / 2.0f), (double)this.random.nextFloat()).subtract(0.5).multiply(1.5), (boolean)true);
                        }
                        if (this.random.nextInt(3) == 0) {
                            this.setBeamTarget(manager.getArenaOrigin());
                            BCoreNetwork.sendSound((Level)this.level(), (Entity)this, (SoundEvent)((SoundEvent)DESounds.CRYSTAL_UNSTABLE.get()), (SoundSource)SoundSource.HOSTILE, (float)6.0f, (float)(0.9f + this.random.nextFloat() * 0.2f), (boolean)false);
                        }
                    } else {
                        BCoreNetwork.sendSound((Level)this.level(), (Entity)this, (SoundEvent)((SoundEvent)DESounds.CRYSTAL_RESTORE.get()), (SoundSource)SoundSource.HOSTILE, (float)8.0f, (float)(0.5f + this.level().random.nextFloat() * 0.2f), (boolean)false);
                    }
                } else if (this.getShieldPower() < (float)DEConfig.guardianCrystalShield) {
                    this.setShieldPower(Math.min((float)DEConfig.guardianCrystalShield, this.getShieldPower() + (float)DEConfig.guardianCrystalShield / 1200.0f));
                    this.playChargeAnimation();
                } else if (this.beamChargeAnim <= 0 && manager.respawnState == null) {
                    this.setBeamTarget(null);
                }
                if (this.beamChargeAnim > 0) {
                    this.setBeamPower(Mth.sin((float)((float)this.beamChargeAnim / 20.0f * (float)Math.PI)));
                    --this.beamChargeAnim;
                    if (this.beamChargeAnim <= 0) {
                        this.beamChargeAnim = 0;
                        this.setBeamTarget(null);
                        this.setBeamPower(1.0f);
                    }
                }
            }
        }
    }

    protected void addAdditionalSaveData(CompoundTag compound) {
        if (this.getBeamTarget() != null) {
            compound.put("BeamTarget", NbtUtils.writeBlockPos((BlockPos)this.getBeamTarget()));
        }
        compound.putBoolean("ShowBottom", this.showsBottom());
        compound.putUUID("manager_id", this.managerId);
    }

    protected void readAdditionalSaveData(CompoundTag compound) {
        if (compound.contains("BeamTarget", 10)) {
            this.setBeamTarget(NbtUtils.readBlockPos((CompoundTag)compound, (String)"BeamTarget").orElse(null));
        }
        if (compound.contains("ShowBottom", 1)) {
            this.setShowBottom(compound.getBoolean("ShowBottom"));
        }
        if (compound.contains("manager_id")) {
            this.managerId = compound.getUUID("manager_id");
        }
    }

    public boolean isPickable() {
        return true;
    }

    public boolean hurt(DamageSource source, float amount) {
        if (this.isInvulnerableTo(source)) {
            return false;
        }
        if (!this.isRemoved() && !this.level().isClientSide) {
            float newPower;
            GuardianFightManager manager = this.getManager();
            float shield = this.getShieldPower() / (float)DEConfig.guardianCrystalShield;
            if (shield > 0.0f) {
                BCoreNetwork.sendSound((Level)this.level(), (Entity)this, (SoundEvent)((SoundEvent)DESounds.SHIELD_STRIKE.get()), (SoundSource)SoundSource.HOSTILE, (float)6.0f, (float)(0.5f + shield), (boolean)false);
            }
            if (manager != null && shield > 0.0f) {
                float modifier = manager.getCrystalDamageModifier(this, source);
                if (modifier == 0.0f) {
                    this.playChargeAnimation();
                    return false;
                }
                amount *= modifier;
            }
            if (shield > 0.0f && (newPower = (float)((int)(this.getShieldPower() - amount))) > 0.0f) {
                this.setShieldPower(newPower);
                this.onCrystalAttacked(source, amount, false);
                return true;
            }
            this.discard();
            if (!source.is(DamageTypeTags.IS_EXPLOSION)) {
                this.level().explode(null, this.getX(), this.getY(), this.getZ(), 10.0f, Level.ExplosionInteraction.BLOCK);
            }
            this.onCrystalAttacked(source, amount, true);
        }
        return true;
    }

    private void playChargeAnimation() {
        GuardianFightManager manager = this.getManager();
        if (this.beamChargeAnim == 0 && manager != null) {
            BCoreNetwork.sendSound((Level)this.level(), (Entity)this, (SoundEvent)((SoundEvent)DESounds.CRYSTAL_BEAM.get()), (SoundSource)SoundSource.HOSTILE, (float)6.0f, (float)1.0f, (boolean)false);
            this.beamChargeAnim = 20;
            this.setBeamTarget(manager.getArenaOrigin());
            this.setBeamPower(0.0f);
        }
    }

    public void kill() {
        this.onCrystalAttacked(this.level().damageSources().generic(), 0.0f, true);
        super.kill();
    }

    private void onCrystalAttacked(DamageSource source, float damage, boolean destroyed) {
        GuardianFightManager manager = this.getManager();
        if (manager != null) {
            manager.onCrystalAttacked(this, source, damage, destroyed);
        }
    }

    public void setBeamTarget(@Nullable BlockPos beamTarget) {
        this.setBeamPower(1.0f);
        this.getEntityData().set(BEAM_TARGET, Optional.ofNullable(beamTarget));
    }

    public void setBeamPower(float beamPower) {
        this.entityData.set(BEAM_POWER, (Object)Float.valueOf(beamPower));
    }

    public float getBeamPower() {
        return ((Float)this.entityData.get(BEAM_POWER)).floatValue();
    }

    @Nullable
    public BlockPos getBeamTarget() {
        return ((Optional)this.getEntityData().get(BEAM_TARGET)).orElse(null);
    }

    public void setShowBottom(boolean showBottom) {
        this.getEntityData().set(SHOW_BOTTOM, (Object)showBottom);
    }

    public boolean showsBottom() {
        return (Boolean)this.getEntityData().get(SHOW_BOTTOM);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean shouldRenderAtSqrDistance(double distance) {
        return super.shouldRenderAtSqrDistance(distance) || this.getBeamTarget() != null;
    }

    public void destabilize() {
        if (this.getUnstableTime() == 0) {
            BCoreNetwork.sendSound((Level)this.level(), (Entity)this, (SoundEvent)((SoundEvent)DESounds.CRYSTAL_DESTABILIZE.get()), (SoundSource)SoundSource.HOSTILE, (float)8.0f, (float)(0.5f + this.level().random.nextFloat() * 0.2f), (boolean)false);
        }
        this.setUnstableTime(DEConfig.guardianCrystalUnstableWindow);
    }

    public GuardianFightManager getManager() {
        WorldEntity worldEntity;
        if (this.level() instanceof ServerLevel && this.getManagerId() != null && (worldEntity = WorldEntityHandler.getWorldEntity((Level)this.level(), (UUID)this.managerId)) instanceof GuardianFightManager) {
            return (GuardianFightManager)worldEntity;
        }
        return null;
    }
}

