/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.render.tile;

import codechicken.lib.render.CCModel;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.lighting.LightModel;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.texture.TextureUtils;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Matrix4;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.Translation;
import codechicken.lib.vec.Vector3;
import codechicken.lib.vec.Vertex5;
import codechicken.lib.vec.uv.IconTransformation;
import codechicken.lib.vec.uv.UV;
import com.brandon3055.draconicevolution.blocks.Potentiometer;
import com.brandon3055.draconicevolution.blocks.tileentity.TilePotentiometer;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.properties.Property;

public class RenderTilePotentiometer
implements BlockEntityRenderer<TilePotentiometer> {
    private static CCModel model;

    public RenderTilePotentiometer(BlockEntityRendererProvider.Context context) {
        double pxl = 0.0625;
        double ls = pxl * 2.5;
        double rs = pxl * 1.5;
        double fe = pxl * 7.0;
        double be = pxl * 0.0;
        double bh = pxl * 3.0;
        double fh = pxl * 0.5;
        int i = 24;
        model = CCModel.quadModel((int)40);
        model.generateBlock(0, new Cuboid6(0.0, 0.0, 0.0, pxl * 4.0, pxl, pxl * 4.0));
        RenderTilePotentiometer.model.verts[i++] = new Vertex5(new Vector3(ls, bh, be), new UV(ls, be));
        RenderTilePotentiometer.model.verts[i++] = new Vertex5(new Vector3(ls, fh, fe), new UV(ls, fe));
        RenderTilePotentiometer.model.verts[i++] = new Vertex5(new Vector3(rs, fh, fe), new UV(rs, fe));
        RenderTilePotentiometer.model.verts[i++] = new Vertex5(new Vector3(rs, bh, be), new UV(rs, be));
        RenderTilePotentiometer.model.verts[i++] = new Vertex5(new Vector3(ls, 0.0, fe), new UV(0.0, fe));
        RenderTilePotentiometer.model.verts[i++] = new Vertex5(new Vector3(ls, 0.0, be), new UV(0.0, be));
        RenderTilePotentiometer.model.verts[i++] = new Vertex5(new Vector3(ls, bh, be), new UV(bh, be));
        RenderTilePotentiometer.model.verts[i++] = new Vertex5(new Vector3(ls, fh, fe), new UV(fh, fe));
        RenderTilePotentiometer.model.verts[i++] = new Vertex5(new Vector3(rs, 0.0, fe), new UV(0.0, fe));
        RenderTilePotentiometer.model.verts[i++] = new Vertex5(new Vector3(rs, 0.0, be), new UV(0.0, be));
        RenderTilePotentiometer.model.verts[i++] = new Vertex5(new Vector3(rs, bh, be), new UV(bh, be));
        RenderTilePotentiometer.model.verts[i++] = new Vertex5(new Vector3(rs, fh, fe), new UV(fh, fe));
        RenderTilePotentiometer.model.verts[i++] = new Vertex5(new Vector3(ls, pxl, be), new UV(ls, 0.0));
        RenderTilePotentiometer.model.verts[i++] = new Vertex5(new Vector3(rs, pxl, be), new UV(rs, 0.0));
        RenderTilePotentiometer.model.verts[i++] = new Vertex5(new Vector3(rs, bh, be), new UV(rs, bh));
        RenderTilePotentiometer.model.verts[i++] = new Vertex5(new Vector3(ls, bh, be), new UV(ls, bh));
        model.computeNormals();
        model.computeLightCoords();
        model = model.twoFacedCopy();
    }

    public void render(TilePotentiometer te, float partialTicks, PoseStack matrixStackIn, MultiBufferSource buffer, int combinedLightIn, int combinedOverlayIn) {
        TextureAtlasSprite stoneTex = TextureUtils.getBlockTexture((String)"oak_planks");
        IconTransformation iconTransform = new IconTransformation(stoneTex);
        CCRenderState state = CCRenderState.instance();
        state.reset();
        state.bind(RenderType.solid(), buffer);
        state.brightness = combinedLightIn;
        state.overlay = combinedOverlayIn;
        double pxl = 0.0625;
        Matrix4 mat = new Matrix4(matrixStackIn);
        mat.apply(Rotation.sideOrientation((int)((Direction)te.getBlockState().getValue((Property)Potentiometer.FACING)).getOpposite().get3DDataValue(), (int)0).at(Vector3.CENTER));
        mat.apply((Transformation)new Translation(6.0 * pxl, pxl, 6.0 * pxl));
        mat.apply(new Rotation((double)te.power.get() * 22.5 * -0.017453292519943, 0.0, 1.0, 0.0).at(new Vector3(pxl * 2.0, 0.0, pxl * 2.0)));
        model.render(state, new IVertexOperation[]{LightModel.standardLightModel, iconTransform, mat});
    }
}

