/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.render.item;

import codechicken.lib.model.PerspectiveModelState;
import codechicken.lib.render.CCModel;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.buffer.VBORenderType;
import codechicken.lib.render.model.OBJParser;
import codechicken.lib.util.TransformUtils;
import codechicken.lib.vec.Matrix4;
import codechicken.lib.vec.Vector3;
import com.brandon3055.brandonscore.api.TechLevel;
import com.brandon3055.draconicevolution.api.capability.DECapabilities;
import com.brandon3055.draconicevolution.api.capability.ModuleHost;
import com.brandon3055.draconicevolution.api.modules.ModuleTypes;
import com.brandon3055.draconicevolution.api.modules.entities.ShieldControlEntity;
import com.brandon3055.draconicevolution.client.DEShaders;
import com.brandon3055.draconicevolution.client.render.item.ToolRenderBase;
import com.brandon3055.draconicevolution.client.shader.ToolShader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.Locale;
import java.util.Map;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class RenderModularChestpiece
extends ToolRenderBase {
    private final ToolRenderBase.ToolPart basePart;
    private final ToolRenderBase.ToolPart materialPart;
    private final ToolRenderBase.ToolPart gemPart;
    private final CoreGemPart coreGemPart;

    public RenderModularChestpiece(TechLevel techLevel) {
        super(techLevel, "chestpeice");
        Map model = new OBJParser(ResourceLocation.fromNamespaceAndPath((String)"draconicevolution", (String)"models/item/equipment/chestpeice.obj")).ignoreMtl().parse();
        this.basePart = this.basePart(((CCModel)model.get("base_model")).backfacedCopy());
        this.materialPart = this.materialPart(((CCModel)model.get("chevrons")).backfacedCopy());
        this.gemPart = this.gemPart(((CCModel)model.get("power_crystals")).backfacedCopy());
        this.coreGemPart = this.coreGemPart(((CCModel)model.get("crystal_core")).backfacedCopy());
    }

    @Override
    public void renderTool(CCRenderState ccrs, ItemStack stack, ItemDisplayContext context, Matrix4 mat, MultiBufferSource buffers, boolean gui) {
        mat.translate(0.5, 1.05, 0.5);
        mat.rotate(3.1415926535897403, Vector3.Z_POS);
        mat.scale(1.95);
        this.basePart.render(context, buffers, mat);
        this.materialPart.render(context, buffers, mat);
        int shieldColour = -1;
        try (ModuleHost host = DECapabilities.getHost(stack);){
            ShieldControlEntity shieldControl;
            if (!stack.isEmpty() && host != null && (shieldControl = (ShieldControlEntity)host.getEntitiesByType(ModuleTypes.SHIELD_CONTROLLER).map(e -> (ShieldControlEntity)e).findAny().orElse(null)) != null) {
                shieldColour = shieldControl.getShieldColour();
            }
        }
        this.gemPart.render(context, buffers, mat);
        this.coreGemPart.render(buffers, mat, shieldColour);
    }

    @Override
    @Nullable
    public PerspectiveModelState getModelState() {
        return TransformUtils.DEFAULT_BLOCK;
    }

    protected CoreGemPart coreGemPart(CCModel model) {
        String levelName = this.techLevel.name().toLowerCase(Locale.ROOT);
        RenderType.CompositeRenderType gemType = RenderType.create((String)"draconicevolution:core_gem", (VertexFormat)DefaultVertexFormat.NEW_ENTITY, (VertexFormat.Mode)VertexFormat.Mode.TRIANGLES, (int)256, (RenderType.CompositeState)RenderType.CompositeState.builder().setShaderState(new RenderStateShard.ShaderStateShard(() -> ((ToolShader)DEShaders.CHESTPIECE_GEM_SHADER).getShaderInstance())).setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(ResourceLocation.fromNamespaceAndPath((String)"draconicevolution", (String)("textures/item/equipment/shader_fallback_" + levelName + ".png")), false, false)).setLightmapState(RenderStateShard.LIGHTMAP).setOverlayState(RenderStateShard.OVERLAY).createCompositeState(false));
        return new CoreGemPart(this, model, (RenderType)gemType, DEShaders.CHESTPIECE_GEM_SHADER);
    }

    private class CoreGemPart
    extends ToolRenderBase.SimpleToolPart {
        private final ToolShader shader;

        public CoreGemPart(RenderModularChestpiece renderModularChestpiece, CCModel model, RenderType baseType, ToolShader shader) {
            super(model, baseType, shader);
            this.shader = shader;
        }

        @Override
        public void render(ItemDisplayContext transformType, MultiBufferSource buffers, Matrix4 mat, float pulse) {
            this.render(buffers, mat, -1);
        }

        public void render(MultiBufferSource buffers, Matrix4 mat, int color) {
            ((VBORenderType)this.vboType.get()).withCallback(() -> {
                this.shader.getBaseColorUniform().glUniform4f((float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f, (float)(color >> 24 & 0xFF) / 255.0f);
                this.shader.getModelMatUniform().glUniformMatrix4f(mat);
            }).draw(buffers);
        }
    }

    public static class CHESTPIECE_CHAOTIC
    extends RenderModularChestpiece {
        public CHESTPIECE_CHAOTIC() {
            super(TechLevel.CHAOTIC);
        }
    }

    public static class CHESTPIECE_DRACONIC
    extends RenderModularChestpiece {
        public CHESTPIECE_DRACONIC() {
            super(TechLevel.DRACONIC);
        }
    }

    public static class CHESTPIECE_WYVERN
    extends RenderModularChestpiece {
        public CHESTPIECE_WYVERN() {
            super(TechLevel.WYVERN);
        }
    }
}

