/*
 * Decompiled with CFR 0.152.
 */
package net.freedinner.display.init;

import net.freedinner.display.block.ArmorTrimBlock;
import net.freedinner.display.block.GemBlock;
import net.freedinner.display.block.IngotBlock;
import net.freedinner.display.block.MusicBlock;
import net.freedinner.display.block.SherdBlock;
import net.freedinner.display.block.UpgradeBlock;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.registries.DeferredRegister;

public class DisplayBlocks {
    public static final DeferredRegister<Block> REGISTRY = DeferredRegister.create((ResourceKey)Registries.BLOCK, (String)"items_displayed");

    public static void setupBlocks() {
        REGISTRY.register("angler_pottery_sherd", () -> new SherdBlock(DisplayBlocks.createBlock("angler_pottery_sherd", SoundType.DECORATED_POT)));
        REGISTRY.register("archer_pottery_sherd", () -> new SherdBlock(DisplayBlocks.createBlock("archer_pottery_sherd", SoundType.DECORATED_POT)));
        REGISTRY.register("arms_up_pottery_sherd", () -> new SherdBlock(DisplayBlocks.createBlock("arms_up_pottery_sherd", SoundType.DECORATED_POT)));
        REGISTRY.register("blade_pottery_sherd", () -> new SherdBlock(DisplayBlocks.createBlock("blade_pottery_sherd", SoundType.DECORATED_POT)));
        REGISTRY.register("brewer_pottery_sherd", () -> new SherdBlock(DisplayBlocks.createBlock("brewer_pottery_sherd", SoundType.DECORATED_POT)));
        REGISTRY.register("burn_pottery_sherd", () -> new SherdBlock(DisplayBlocks.createBlock("burn_pottery_sherd", SoundType.DECORATED_POT)));
        REGISTRY.register("danger_pottery_sherd", () -> new SherdBlock(DisplayBlocks.createBlock("danger_pottery_sherd", SoundType.DECORATED_POT)));
        REGISTRY.register("explorer_pottery_sherd", () -> new SherdBlock(DisplayBlocks.createBlock("explorer_pottery_sherd", SoundType.DECORATED_POT)));
        REGISTRY.register("flow_pottery_sherd", () -> new SherdBlock(DisplayBlocks.createBlock("flow_pottery_sherd", SoundType.DECORATED_POT)));
        REGISTRY.register("friend_pottery_sherd", () -> new SherdBlock(DisplayBlocks.createBlock("friend_pottery_sherd", SoundType.DECORATED_POT)));
        REGISTRY.register("guster_pottery_sherd", () -> new SherdBlock(DisplayBlocks.createBlock("guster_pottery_sherd", SoundType.DECORATED_POT)));
        REGISTRY.register("heart_pottery_sherd", () -> new SherdBlock(DisplayBlocks.createBlock("heart_pottery_sherd", SoundType.DECORATED_POT)));
        REGISTRY.register("heartbreak_pottery_sherd", () -> new SherdBlock(DisplayBlocks.createBlock("heartbreak_pottery_sherd", SoundType.DECORATED_POT)));
        REGISTRY.register("howl_pottery_sherd", () -> new SherdBlock(DisplayBlocks.createBlock("howl_pottery_sherd", SoundType.DECORATED_POT)));
        REGISTRY.register("miner_pottery_sherd", () -> new SherdBlock(DisplayBlocks.createBlock("miner_pottery_sherd", SoundType.DECORATED_POT)));
        REGISTRY.register("mourner_pottery_sherd", () -> new SherdBlock(DisplayBlocks.createBlock("mourner_pottery_sherd", SoundType.DECORATED_POT)));
        REGISTRY.register("plenty_pottery_sherd", () -> new SherdBlock(DisplayBlocks.createBlock("plenty_pottery_sherd", SoundType.DECORATED_POT)));
        REGISTRY.register("prize_pottery_sherd", () -> new SherdBlock(DisplayBlocks.createBlock("prize_pottery_sherd", SoundType.DECORATED_POT)));
        REGISTRY.register("scrape_pottery_sherd", () -> new SherdBlock(DisplayBlocks.createBlock("scrape_pottery_sherd", SoundType.DECORATED_POT)));
        REGISTRY.register("sheaf_pottery_sherd", () -> new SherdBlock(DisplayBlocks.createBlock("sheaf_pottery_sherd", SoundType.DECORATED_POT)));
        REGISTRY.register("shelter_pottery_sherd", () -> new SherdBlock(DisplayBlocks.createBlock("shelter_pottery_sherd", SoundType.DECORATED_POT)));
        REGISTRY.register("skull_pottery_sherd", () -> new SherdBlock(DisplayBlocks.createBlock("skull_pottery_sherd", SoundType.DECORATED_POT)));
        REGISTRY.register("snort_pottery_sherd", () -> new SherdBlock(DisplayBlocks.createBlock("snort_pottery_sherd", SoundType.DECORATED_POT)));
        REGISTRY.register("netherite_upgrade", () -> new UpgradeBlock(DisplayBlocks.createBlock("netherite_upgrade", SoundType.NETHERRACK)));
        REGISTRY.register("bolt_armor_trim", () -> new ArmorTrimBlock(DisplayBlocks.createBlock("bolt_armor_trim", SoundType.COPPER)));
        REGISTRY.register("coast_armor_trim", () -> new ArmorTrimBlock(DisplayBlocks.createBlock("coast_armor_trim", SoundType.STONE)));
        REGISTRY.register("dune_armor_trim", () -> new ArmorTrimBlock(DisplayBlocks.createBlock("dune_armor_trim", SoundType.DRIPSTONE_BLOCK)));
        REGISTRY.register("eye_armor_trim", () -> new ArmorTrimBlock(DisplayBlocks.createBlock("eye_armor_trim", SoundType.CALCITE)));
        REGISTRY.register("flow_armor_trim", () -> new ArmorTrimBlock(DisplayBlocks.createBlock("flow_armor_trim", SoundType.STONE)));
        REGISTRY.register("host_armor_trim", () -> new ArmorTrimBlock(DisplayBlocks.createBlock("host_armor_trim", SoundType.GRAVEL)));
        REGISTRY.register("raiser_armor_trim", () -> new ArmorTrimBlock(DisplayBlocks.createBlock("raiser_armor_trim", SoundType.GRAVEL)));
        REGISTRY.register("rib_armor_trim", () -> new ArmorTrimBlock(DisplayBlocks.createBlock("rib_armor_trim", SoundType.NETHER_BRICKS)));
        REGISTRY.register("sentry_armor_trim", () -> new ArmorTrimBlock(DisplayBlocks.createBlock("sentry_armor_trim", SoundType.STONE)));
        REGISTRY.register("shaper_armor_trim", () -> new ArmorTrimBlock(DisplayBlocks.createBlock("shaper_armor_trim", SoundType.GRAVEL)));
        REGISTRY.register("silence_armor_trim", () -> new ArmorTrimBlock(DisplayBlocks.createBlock("silence_armor_trim", SoundType.DEEPSLATE)));
        REGISTRY.register("snout_armor_trim", () -> new ArmorTrimBlock(DisplayBlocks.createBlock("snout_armor_trim", SoundType.POLISHED_DEEPSLATE)));
        REGISTRY.register("spire_armor_trim", () -> new ArmorTrimBlock(DisplayBlocks.createBlock("spire_armor_trim", SoundType.DEEPSLATE_BRICKS)));
        REGISTRY.register("tide_armor_trim", () -> new ArmorTrimBlock(DisplayBlocks.createBlock("tide_armor_trim", SoundType.DEEPSLATE_BRICKS)));
        REGISTRY.register("vex_armor_trim", () -> new ArmorTrimBlock(DisplayBlocks.createBlock("vex_armor_trim", SoundType.STONE)));
        REGISTRY.register("ward_armor_trim", () -> new ArmorTrimBlock(DisplayBlocks.createBlock("ward_armor_trim", SoundType.DEEPSLATE)));
        REGISTRY.register("wayfinder_armor_trim", () -> new ArmorTrimBlock(DisplayBlocks.createBlock("wayfinder_armor_trim", SoundType.GRAVEL)));
        REGISTRY.register("wild_armor_trim", () -> new ArmorTrimBlock(DisplayBlocks.createBlock("wild_armor_trim", SoundType.STONE)));
        REGISTRY.register("brick", () -> new IngotBlock(DisplayBlocks.createBlock("brick", SoundType.DECORATED_POT)));
        REGISTRY.register("nether_brick", () -> new IngotBlock(DisplayBlocks.createBlock("nether_brick", SoundType.NETHER_BRICKS)));
        REGISTRY.register("iron_ingot", () -> new IngotBlock(DisplayBlocks.createBlock("iron_ingot", SoundType.METAL)));
        REGISTRY.register("copper_ingot", () -> new IngotBlock(DisplayBlocks.createBlock("copper_ingot", SoundType.COPPER)));
        REGISTRY.register("gold_ingot", () -> new IngotBlock(DisplayBlocks.createBlock("gold_ingot", SoundType.METAL)));
        REGISTRY.register("netherite_ingot", () -> new IngotBlock(DisplayBlocks.createBlock("netherite_ingot", SoundType.NETHERITE_BLOCK)));
        REGISTRY.register("coal", () -> new GemBlock(DisplayBlocks.createBlock("coal", SoundType.STONE)));
        REGISTRY.register("charcoal", () -> new GemBlock(DisplayBlocks.createBlock("charcoal", SoundType.STONE)));
        REGISTRY.register("amethyst_shard", () -> new GemBlock(DisplayBlocks.createBlock("amethyst_shard", SoundType.AMETHYST)));
        REGISTRY.register("diamond", () -> new GemBlock(DisplayBlocks.createBlock("diamond", SoundType.METAL)));
        REGISTRY.register("emerald", () -> new GemBlock(DisplayBlocks.createBlock("emerald", SoundType.METAL)));
        REGISTRY.register("lapis_lazuli", () -> new GemBlock(DisplayBlocks.createBlock("lapis_lazuli", SoundType.METAL)));
        REGISTRY.register("echo_shard", () -> new GemBlock(DisplayBlocks.createBlock("echo_shard", SoundType.AMETHYST)));
        REGISTRY.register("music_disc_5", () -> new MusicBlock(DisplayBlocks.createBlock("music_disc_5", SoundType.STONE)));
        REGISTRY.register("music_disc_11", () -> new MusicBlock(DisplayBlocks.createBlock("music_disc_11", SoundType.STONE)));
        REGISTRY.register("music_disc_13", () -> new MusicBlock(DisplayBlocks.createBlock("music_disc_13", SoundType.STONE)));
        REGISTRY.register("music_disc_blocks", () -> new MusicBlock(DisplayBlocks.createBlock("music_disc_blocks", SoundType.STONE)));
        REGISTRY.register("music_disc_cat", () -> new MusicBlock(DisplayBlocks.createBlock("music_disc_cat", SoundType.STONE)));
        REGISTRY.register("music_disc_chirp", () -> new MusicBlock(DisplayBlocks.createBlock("music_disc_chirp", SoundType.STONE)));
        REGISTRY.register("music_disc_creator", () -> new MusicBlock(DisplayBlocks.createBlock("music_disc_creator", SoundType.COPPER)));
        REGISTRY.register("music_disc_creator_music_box", () -> new MusicBlock(DisplayBlocks.createBlock("music_disc_creator_music_box", SoundType.COPPER)));
        REGISTRY.register("music_disc_far", () -> new MusicBlock(DisplayBlocks.createBlock("music_disc_far", SoundType.STONE)));
        REGISTRY.register("music_disc_mall", () -> new MusicBlock(DisplayBlocks.createBlock("music_disc_mall", SoundType.STONE)));
        REGISTRY.register("music_disc_mellohi", () -> new MusicBlock(DisplayBlocks.createBlock("music_disc_mellohi", SoundType.STONE)));
        REGISTRY.register("music_disc_otherside", () -> new MusicBlock(DisplayBlocks.createBlock("music_disc_otherside", SoundType.STONE)));
        REGISTRY.register("music_disc_pigstep", () -> new MusicBlock(DisplayBlocks.createBlock("music_disc_pigstep", SoundType.STONE)));
        REGISTRY.register("music_disc_precipice", () -> new MusicBlock(DisplayBlocks.createBlock("music_disc_precipice", SoundType.STONE)));
        REGISTRY.register("music_disc_relic", () -> new MusicBlock(DisplayBlocks.createBlock("music_disc_relic", SoundType.STONE)));
        REGISTRY.register("music_disc_stal", () -> new MusicBlock(DisplayBlocks.createBlock("music_disc_stal", SoundType.STONE)));
        REGISTRY.register("music_disc_strad", () -> new MusicBlock(DisplayBlocks.createBlock("music_disc_strad", SoundType.STONE)));
        REGISTRY.register("music_disc_wait", () -> new MusicBlock(DisplayBlocks.createBlock("music_disc_wait", SoundType.STONE)));
        REGISTRY.register("music_disc_ward", () -> new MusicBlock(DisplayBlocks.createBlock("music_disc_ward", SoundType.STONE)));
        DisplayBlocks.addModdedBlocks();
    }

    public static void addModdedBlocks() {
        if (ModList.get().isLoaded("alexscaves")) {
            REGISTRY.register("dinosaur_pottery_sherd", () -> new SherdBlock(DisplayBlocks.createBlock("dinosaur_pottery_sherd", SoundType.DECORATED_POT)));
            REGISTRY.register("footprint_pottery_sherd", () -> new SherdBlock(DisplayBlocks.createBlock("footprint_pottery_sherd", SoundType.DECORATED_POT)));
            REGISTRY.register("guardian_pottery_sherd", () -> new SherdBlock(DisplayBlocks.createBlock("guardian_pottery_sherd", SoundType.DECORATED_POT)));
            REGISTRY.register("hero_pottery_sherd", () -> new SherdBlock(DisplayBlocks.createBlock("hero_pottery_sherd", SoundType.DECORATED_POT)));
            REGISTRY.register("polarity_armor_trim", () -> new ArmorTrimBlock(DisplayBlocks.createBlock("polarity_armor_trim", SoundType.STONE)));
            REGISTRY.register("azure_neodymium_ingot", () -> new IngotBlock(DisplayBlocks.createBlock("azure_neodymium_ingot", SoundType.METAL)));
            REGISTRY.register("scarlet_neodymium_ingot", () -> new IngotBlock(DisplayBlocks.createBlock("scarlet_neodymium_ingot", SoundType.METAL)));
            REGISTRY.register("music_disc_fusion", () -> new MusicBlock(DisplayBlocks.createBlock("music_disc_fusion", SoundType.STONE)));
            REGISTRY.register("music_disc_tasty", () -> new MusicBlock(DisplayBlocks.createBlock("music_disc_tasty", SoundType.STONE)));
        }
        if (ModList.get().isLoaded("cloudstorage")) {
            REGISTRY.register("music_disc_drift", () -> new MusicBlock(DisplayBlocks.createBlock("music_disc_drift", SoundType.WOOL)));
        }
        if (ModList.get().isLoaded("create")) {
            REGISTRY.register("brass_ingot", () -> new IngotBlock(DisplayBlocks.createBlock("brass_ingot", SoundType.METAL)));
            REGISTRY.register("zinc_ingot", () -> new IngotBlock(DisplayBlocks.createBlock("zinc_ingot", SoundType.METAL)));
        }
        if (ModList.get().isLoaded("ecologics")) {
            REGISTRY.register("music_disc_coconut", () -> new MusicBlock(DisplayBlocks.createBlock("music_disc_coconut", SoundType.STONE)));
        }
        if (ModList.get().isLoaded("environmental")) {
            REGISTRY.register("music_disc_leaving_home", () -> new MusicBlock(DisplayBlocks.createBlock("music_disc_leaving_home", SoundType.STONE)));
            REGISTRY.register("music_disc_slabrave", () -> new MusicBlock(DisplayBlocks.createBlock("music_disc_slabrave", SoundType.STONE)));
        }
        if (ModList.get().isLoaded("friendsandfoes")) {
            REGISTRY.register("music_disc_around_the_corner", () -> new MusicBlock(DisplayBlocks.createBlock("music_disc_around_the_corner", SoundType.STONE)));
        }
        if (ModList.get().isLoaded("galosphere")) {
            REGISTRY.register("preserved_template", () -> new UpgradeBlock(DisplayBlocks.createBlock("preserved_template", SoundType.STONE)));
            REGISTRY.register("allurite_shard", () -> new GemBlock(DisplayBlocks.createBlock("allurite_shard", SoundType.AMETHYST)));
            REGISTRY.register("lumiere_shard", () -> new GemBlock(DisplayBlocks.createBlock("lumiere_shard", SoundType.AMETHYST)));
            REGISTRY.register("palladium_ingot", () -> new IngotBlock(DisplayBlocks.createBlock("palladium_ingot", SoundType.METAL)));
            REGISTRY.register("thirst_pottery_sherd", () -> new SherdBlock(DisplayBlocks.createBlock("thirst_pottery_sherd", SoundType.DECORATED_POT)));
            REGISTRY.register("wave_pottery_sherd", () -> new SherdBlock(DisplayBlocks.createBlock("wave_pottery_sherd", SoundType.DECORATED_POT)));
        }
        if (ModList.get().isLoaded("kobolds")) {
            REGISTRY.register("kobold_template", () -> new ArmorTrimBlock(DisplayBlocks.createBlock("kobold_template", SoundType.TUFF)));
            REGISTRY.register("music_disc_kobblestone", () -> new MusicBlock(DisplayBlocks.createBlock("music_disc_kobblestone", SoundType.STONE)));
        }
        if (ModList.get().isLoaded("revotedwildfire")) {
            REGISTRY.register("fireproof_upgrade", () -> new UpgradeBlock(DisplayBlocks.createBlock("fireproof_upgrade", SoundType.NETHER_BRICKS)));
        }
        if (ModList.get().isLoaded("spawn")) {
            REGISTRY.register("crown_pottery_sherd", () -> new SherdBlock(DisplayBlocks.createBlock("crown_pottery_sherd", SoundType.DECORATED_POT)));
            REGISTRY.register("spade_pottery_sherd", () -> new SherdBlock(DisplayBlocks.createBlock("spade_pottery_sherd", SoundType.DECORATED_POT)));
            REGISTRY.register("music_disc_rot", () -> new MusicBlock(DisplayBlocks.createBlock("music_disc_rot", SoundType.STONE)));
        }
        if (ModList.get().isLoaded("supplementaries")) {
            REGISTRY.register("ash_brick", () -> new IngotBlock(DisplayBlocks.createBlock("ash_brick", SoundType.DECORATED_POT)));
            REGISTRY.register("music_disc_heave_ho", () -> new MusicBlock(DisplayBlocks.createBlock("music_disc_heave_ho", SoundType.STONE)));
        }
        if (ModList.get().isLoaded("upgrade_aquatic")) {
            REGISTRY.register("music_disc_atlantis", () -> new MusicBlock(DisplayBlocks.createBlock("music_disc_atlantis", SoundType.STONE)));
        }
        if (ModList.get().isLoaded("vanillabackport")) {
            REGISTRY.register("resin_brick", () -> new IngotBlock(DisplayBlocks.createBlock("resin_brick", SoundType.DECORATED_POT)));
            REGISTRY.register("music_disc_tears", () -> new MusicBlock(DisplayBlocks.createBlock("music_disc_tears", SoundType.STONE)));
            REGISTRY.register("music_disc_lava_chicken", () -> new MusicBlock(DisplayBlocks.createBlock("music_disc_lava_chicken", SoundType.STONE)));
        }
    }

    private static BlockBehaviour.Properties createBlock(String name, SoundType sound) {
        return DisplayBlocks.createBaseProps(name).mapColor(MapColor.NONE).sound(sound);
    }

    private static BlockBehaviour.Properties createBaseProps(String name) {
        return BlockBehaviour.Properties.of().noTerrainParticles().instabreak().noOcclusion().pushReaction(PushReaction.DESTROY);
    }
}

