/*
 * Decompiled with CFR 0.152.
 */
package net.freedinner.display.block;

import com.mojang.serialization.MapCodec;
import net.freedinner.display.block.AbstractStackableBlock;
import net.freedinner.display.block.IPillowBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class GemBlock
extends AbstractStackableBlock
implements IPillowBlock {
    public static final MapCodec<GemBlock> CODEC = GemBlock.simpleCodec(GemBlock::new);

    public GemBlock(BlockBehaviour.Properties props) {
        super(props);
    }

    public MapCodec<GemBlock> codec() {
        return CODEC;
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        int i = this.getStacks(state);
        return switch (i) {
            case 1 -> {
                switch ((Direction)state.getValue((Property)FACING)) {
                    case NORTH: 
                    case SOUTH: {
                        yield GemBlock.box((double)6.0, (double)0.0, (double)5.0, (double)10.0, (double)2.0, (double)11.0);
                    }
                    case EAST: 
                    case WEST: {
                        yield GemBlock.box((double)5.0, (double)0.0, (double)6.0, (double)11.0, (double)2.0, (double)10.0);
                    }
                }
                yield GemBlock.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)2.0, (double)15.0);
            }
            case 2 -> GemBlock.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)2.0, (double)14.0);
            case 3 -> GemBlock.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)2.0, (double)15.0);
            case 4 -> GemBlock.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)4.0, (double)15.0);
            default -> GemBlock.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)4.0, (double)15.0);
        };
    }

    @Override
    public int getMaxStackable() {
        return 4;
    }
}

