/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.network.toclient;

import de.srendi.advancedperipherals.AdvancedPeripherals;
import de.srendi.advancedperipherals.common.util.ToastUtil;
import de.srendi.advancedperipherals.network.IAPPacket;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public class ToastToClientPacket
implements IAPPacket {
    public static final StreamCodec<RegistryFriendlyByteBuf, ToastToClientPacket> CODEC = StreamCodec.composite((StreamCodec)ComponentSerialization.STREAM_CODEC, packet -> packet.title, (StreamCodec)ComponentSerialization.STREAM_CODEC, packet -> packet.component, ToastToClientPacket::new);
    public static final CustomPacketPayload.Type<ToastToClientPacket> TYPE = new CustomPacketPayload.Type(AdvancedPeripherals.getRL("toasttoclient"));
    private final Component title;
    private final Component component;

    public ToastToClientPacket(Component title, Component component) {
        this.title = title;
        this.component = component;
    }

    @Override
    public void handle(@NotNull IPayloadContext context) {
        if (!FMLEnvironment.dist.isClient()) {
            AdvancedPeripherals.debug("Tried to display toasts on the server, aborting.");
            return;
        }
        ToastUtil.displayToast(this.title, this.component);
    }

    @NotNull
    public CustomPacketPayload.Type<ToastToClientPacket> type() {
        return TYPE;
    }
}

