/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.util;

import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class ScanUtils {
    public static void relativeTraverseBlocks(Level world, BlockPos center, int radius, BiConsumer<BlockState, BlockPos> consumer) {
        ScanUtils.traverseBlocks(world, center, radius, consumer, true);
    }

    public static void traverseBlocks(Level world, BlockPos center, int radius, BiConsumer<BlockState, BlockPos> consumer) {
        ScanUtils.traverseBlocks(world, center, radius, consumer, false);
    }

    public static void traverseBlocks(Level world, BlockPos center, int radius, BiConsumer<BlockState, BlockPos> consumer, boolean relativePosition) {
        int x = center.getX();
        int y = center.getY();
        int z = center.getZ();
        int minX = x - radius;
        int maxX = x + radius;
        int minY = y - radius;
        int maxY = y + radius;
        int minZ = z - radius;
        int maxZ = z + radius;
        BlockPos.MutableBlockPos subPos = new BlockPos.MutableBlockPos();
        for (int oX = minX; oX <= maxX; ++oX) {
            for (int oY = minY; oY <= maxY; ++oY) {
                for (int oZ = minZ; oZ <= maxZ; ++oZ) {
                    BlockState blockState = world.getBlockState((BlockPos)subPos.set(oX, oY, oZ));
                    if (blockState.isAir()) continue;
                    consumer.accept(blockState, relativePosition ? new BlockPos(oX - x, oY - y, oZ - z) : new BlockPos(oX, oY, oZ));
                }
            }
        }
    }
}

