/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.addons.refinedstorage;

import com.refinedmods.refinedstorage.api.core.Action;
import com.refinedmods.refinedstorage.api.network.Network;
import com.refinedmods.refinedstorage.api.network.storage.StorageNetworkComponent;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.storage.Actor;
import com.refinedmods.refinedstorage.common.support.resource.FluidResource;
import com.refinedmods.refinedstorage.neoforge.support.resource.VariantUtil;
import de.srendi.advancedperipherals.common.addons.refinedstorage.RSApi;
import de.srendi.advancedperipherals.common.util.inventory.FluidFilter;
import de.srendi.advancedperipherals.common.util.inventory.IStorageSystemFluidHandler;
import de.srendi.advancedperipherals.common.util.inventory.StorageProcessor;
import java.util.List;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;

public class RSFluidHandler
implements IStorageSystemFluidHandler {
    @NotNull
    private final Network network;
    private final StorageNetworkComponent component;

    public RSFluidHandler(@NotNull Network network) {
        this.network = network;
        this.component = (StorageNetworkComponent)network.getComponent(StorageNetworkComponent.class);
    }

    public int fill(FluidStack resource, @NotNull IFluidHandler.FluidAction action) {
        if (resource.isEmpty()) {
            return 0;
        }
        return (int)this.component.insert((ResourceKey)VariantUtil.ofFluidStack((FluidStack)resource), (long)resource.getAmount(), action.simulate() ? Action.SIMULATE : Action.EXECUTE, Actor.EMPTY);
    }

    @Override
    public int extractFluids(FluidFilter filter, StorageProcessor<FluidStack> processor, IFluidHandler.FluidAction action) {
        List<FluidResource> fluids = RSApi.getFluids(this.network, filter);
        if (fluids.isEmpty()) {
            return 0;
        }
        int needs = filter.getAmount();
        for (FluidResource fluid : fluids) {
            int extracted;
            int amount = (int)this.component.extract((ResourceKey)fluid, (long)needs, Action.SIMULATE, Actor.EMPTY);
            if (amount == 0 || (extracted = processor.process(VariantUtil.toFluidStack((FluidResource)fluid, (long)amount))) == 0) continue;
            needs -= extracted;
            if (action.execute()) {
                this.component.extract((ResourceKey)fluid, (long)extracted, Action.EXECUTE, Actor.EMPTY);
            }
            if (needs > 0) continue;
            break;
        }
        return filter.getAmount() - needs;
    }
}

