/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.addons.refinedstorage;

import com.refinedmods.refinedstorage.api.autocrafting.Ingredient;
import com.refinedmods.refinedstorage.api.autocrafting.Pattern;
import com.refinedmods.refinedstorage.api.autocrafting.status.TaskStatus;
import com.refinedmods.refinedstorage.api.network.Network;
import com.refinedmods.refinedstorage.api.network.autocrafting.AutocraftingNetworkComponent;
import com.refinedmods.refinedstorage.api.network.impl.node.AbstractNetworkNode;
import com.refinedmods.refinedstorage.api.network.impl.node.externalstorage.ExposedExternalStorage;
import com.refinedmods.refinedstorage.api.network.impl.node.externalstorage.ExternalStorageNetworkNode;
import com.refinedmods.refinedstorage.api.network.impl.node.storage.StorageNetworkNode;
import com.refinedmods.refinedstorage.api.network.impl.storage.StorageConfiguration;
import com.refinedmods.refinedstorage.api.network.node.GraphNetworkComponent;
import com.refinedmods.refinedstorage.api.network.node.NetworkNode;
import com.refinedmods.refinedstorage.api.network.storage.StorageNetworkComponent;
import com.refinedmods.refinedstorage.api.resource.ResourceAmount;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.storage.StateTrackedStorage;
import com.refinedmods.refinedstorage.api.storage.Storage;
import com.refinedmods.refinedstorage.api.storage.composite.CompositeStorage;
import com.refinedmods.refinedstorage.common.api.storage.SerializableStorage;
import com.refinedmods.refinedstorage.common.api.support.network.InWorldNetworkNodeContainer;
import com.refinedmods.refinedstorage.common.api.support.resource.PlatformResourceKey;
import com.refinedmods.refinedstorage.common.storage.StorageTypes;
import com.refinedmods.refinedstorage.common.support.resource.FluidResource;
import com.refinedmods.refinedstorage.common.support.resource.ItemResource;
import com.refinedmods.refinedstorage.mekanism.ChemicalResource;
import com.refinedmods.refinedstorage.mekanism.ChemicalResourceType;
import com.refinedmods.refinedstorage.neoforge.api.RefinedStorageNeoForgeApi;
import com.refinedmods.refinedstorage.neoforge.support.resource.VariantUtil;
import de.srendi.advancedperipherals.AdvancedPeripherals;
import de.srendi.advancedperipherals.common.addons.APAddon;
import de.srendi.advancedperipherals.common.addons.refinedstorage.RSCraftJob;
import de.srendi.advancedperipherals.common.addons.refinedstorage.RsStorageTypes;
import de.srendi.advancedperipherals.common.blocks.blockentities.RSBridgeEntity;
import de.srendi.advancedperipherals.common.setup.BlockEntityTypes;
import de.srendi.advancedperipherals.common.util.LuaConverter;
import de.srendi.advancedperipherals.common.util.Pair;
import de.srendi.advancedperipherals.common.util.inventory.ChemicalFilter;
import de.srendi.advancedperipherals.common.util.inventory.ChemicalUtil;
import de.srendi.advancedperipherals.common.util.inventory.FluidFilter;
import de.srendi.advancedperipherals.common.util.inventory.FluidUtil;
import de.srendi.advancedperipherals.common.util.inventory.GenericFilter;
import de.srendi.advancedperipherals.common.util.inventory.ItemFilter;
import de.srendi.advancedperipherals.common.util.inventory.ItemUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import mekanism.api.MekanismAPI;
import mekanism.api.chemical.ChemicalStack;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.fluids.FluidStack;
import org.apache.logging.log4j.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RSApi {
    public static void registerCapabilities(@NotNull RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(RefinedStorageNeoForgeApi.INSTANCE.getNetworkNodeContainerProviderCapability(), (BlockEntityType)BlockEntityTypes.RS_BRIDGE.get(), (blockEntity, side) -> blockEntity);
    }

    @Nullable
    public static ItemResource getItem(Network network, ItemFilter filter) {
        StorageNetworkComponent storage = (StorageNetworkComponent)network.getComponent(StorageNetworkComponent.class);
        for (ResourceAmount resourceAmount : storage.getAll()) {
            ItemResource itemResource;
            ResourceKey resourceKey = resourceAmount.resource();
            if (!(resourceKey instanceof ItemResource) || !filter.test((itemResource = (ItemResource)resourceKey).toItemStack())) continue;
            return itemResource;
        }
        return null;
    }

    public static List<ItemResource> getItems(Network network, ItemFilter filter) {
        ArrayList<ItemResource> items = new ArrayList<ItemResource>();
        StorageNetworkComponent storage = (StorageNetworkComponent)network.getComponent(StorageNetworkComponent.class);
        for (ResourceAmount resourceAmount : storage.getAll()) {
            ItemResource itemResource;
            ResourceKey resourceKey = resourceAmount.resource();
            if (!(resourceKey instanceof ItemResource) || !filter.test((itemResource = (ItemResource)resourceKey).toItemStack())) continue;
            items.add(itemResource);
        }
        return items;
    }

    @Nullable
    public static FluidResource getFluid(Network network, FluidFilter filter) {
        StorageNetworkComponent storage = (StorageNetworkComponent)network.getComponent(StorageNetworkComponent.class);
        for (ResourceAmount resourceAmount : storage.getAll()) {
            FluidResource fluidResource;
            ResourceKey resourceKey = resourceAmount.resource();
            if (!(resourceKey instanceof FluidResource) || !filter.test(VariantUtil.toFluidStack((FluidResource)(fluidResource = (FluidResource)resourceKey), (long)resourceAmount.amount()))) continue;
            return fluidResource;
        }
        return null;
    }

    public static List<FluidResource> getFluids(Network network, FluidFilter filter) {
        ArrayList<FluidResource> fluids = new ArrayList<FluidResource>();
        StorageNetworkComponent storage = (StorageNetworkComponent)network.getComponent(StorageNetworkComponent.class);
        for (ResourceAmount resourceAmount : storage.getAll()) {
            FluidResource fluidResource;
            ResourceKey resourceKey = resourceAmount.resource();
            if (!(resourceKey instanceof FluidResource) || !filter.test(VariantUtil.toFluidStack((FluidResource)(fluidResource = (FluidResource)resourceKey), (long)resourceAmount.amount()))) continue;
            fluids.add(fluidResource);
        }
        return fluids;
    }

    @Nullable
    public static ChemicalResource getChemical(Network network, ChemicalFilter filter) {
        StorageNetworkComponent storage = (StorageNetworkComponent)network.getComponent(StorageNetworkComponent.class);
        for (ResourceAmount resourceAmount : storage.getAll()) {
            ChemicalResource chemicalResource;
            ResourceKey resourceKey = resourceAmount.resource();
            if (!(resourceKey instanceof ChemicalResource) || !filter.test(ChemicalUtil.toChemicalStack((chemicalResource = (ChemicalResource)resourceKey).chemical(), resourceAmount.amount()))) continue;
            return chemicalResource;
        }
        return null;
    }

    public static List<ChemicalResource> getChemicals(Network network, ChemicalFilter filter) {
        ArrayList<ChemicalResource> chemicals = new ArrayList<ChemicalResource>();
        StorageNetworkComponent storage = (StorageNetworkComponent)network.getComponent(StorageNetworkComponent.class);
        for (ResourceAmount resourceAmount : storage.getAll()) {
            ChemicalResource chemicalResource;
            ResourceKey resourceKey = resourceAmount.resource();
            if (!(resourceKey instanceof ChemicalResource) || !filter.test(ChemicalUtil.toChemicalStack((chemicalResource = (ChemicalResource)resourceKey).chemical(), resourceAmount.amount()))) continue;
            chemicals.add(chemicalResource);
        }
        return chemicals;
    }

    @Nullable
    public static Map<String, Object> getParsedItem(Network network, ItemFilter filter) {
        StorageNetworkComponent storage = (StorageNetworkComponent)network.getComponent(StorageNetworkComponent.class);
        AutocraftingNetworkComponent autocrafting = (AutocraftingNetworkComponent)network.getComponent(AutocraftingNetworkComponent.class);
        for (ResourceAmount resourceAmount : storage.getAll()) {
            ItemResource itemResource;
            ResourceKey resourceKey = resourceAmount.resource();
            if (!(resourceKey instanceof ItemResource) || !filter.test((itemResource = (ItemResource)resourceKey).toItemStack())) continue;
            return RSApi.getObjectFromItemResource(resourceAmount, autocrafting);
        }
        return null;
    }

    @Nullable
    public static Map<String, Object> getParsedFluid(Network network, FluidFilter filter) {
        StorageNetworkComponent storage = (StorageNetworkComponent)network.getComponent(StorageNetworkComponent.class);
        AutocraftingNetworkComponent autocrafting = (AutocraftingNetworkComponent)network.getComponent(AutocraftingNetworkComponent.class);
        for (ResourceAmount resourceAmount : storage.getAll()) {
            FluidResource fluidResource;
            ResourceKey resourceKey = resourceAmount.resource();
            if (!(resourceKey instanceof FluidResource) || !filter.test(VariantUtil.toFluidStack((FluidResource)(fluidResource = (FluidResource)resourceKey), (long)resourceAmount.amount()))) continue;
            return RSApi.getObjectFromItemResource(resourceAmount, autocrafting);
        }
        return null;
    }

    @Nullable
    public static Map<String, Object> getParsedChemical(Network network, ChemicalFilter filter) {
        StorageNetworkComponent storage = (StorageNetworkComponent)network.getComponent(StorageNetworkComponent.class);
        AutocraftingNetworkComponent autocrafting = (AutocraftingNetworkComponent)network.getComponent(AutocraftingNetworkComponent.class);
        for (ResourceAmount resourceAmount : storage.getAll()) {
            ChemicalResource chemicalResource;
            ResourceKey resourceKey = resourceAmount.resource();
            if (!(resourceKey instanceof ChemicalResource) || !filter.test(ChemicalUtil.toChemicalStack((chemicalResource = (ChemicalResource)resourceKey).chemical(), resourceAmount.amount()))) continue;
            return RSApi.getObjectFromChemicalResource(resourceAmount, autocrafting);
        }
        return null;
    }

    public static List<Map<String, Object>> getParsedItems(Network network, ItemFilter filter) {
        ArrayList<Map<String, Object>> items = new ArrayList<Map<String, Object>>();
        StorageNetworkComponent storage = (StorageNetworkComponent)network.getComponent(StorageNetworkComponent.class);
        AutocraftingNetworkComponent autocrafting = (AutocraftingNetworkComponent)network.getComponent(AutocraftingNetworkComponent.class);
        for (ResourceAmount resourceAmount : storage.getAll()) {
            ItemResource itemResource;
            ResourceKey resourceKey = resourceAmount.resource();
            if (!(resourceKey instanceof ItemResource) || !filter.test((itemResource = (ItemResource)resourceKey).toItemStack())) continue;
            items.add(RSApi.getObjectFromItemResource(resourceAmount, autocrafting));
        }
        return items;
    }

    public static List<Map<String, Object>> getParsedFluids(Network network, FluidFilter filter) {
        ArrayList<Map<String, Object>> items = new ArrayList<Map<String, Object>>();
        StorageNetworkComponent storage = (StorageNetworkComponent)network.getComponent(StorageNetworkComponent.class);
        AutocraftingNetworkComponent autocrafting = (AutocraftingNetworkComponent)network.getComponent(AutocraftingNetworkComponent.class);
        for (ResourceAmount resourceAmount : storage.getAll()) {
            FluidResource fluidResource;
            ResourceKey resourceKey = resourceAmount.resource();
            if (!(resourceKey instanceof FluidResource) || !filter.test(VariantUtil.toFluidStack((FluidResource)(fluidResource = (FluidResource)resourceKey), (long)resourceAmount.amount()))) continue;
            items.add(RSApi.getObjectFromFluidResource(resourceAmount, autocrafting));
        }
        return items;
    }

    public static List<Map<String, Object>> getParsedChemicals(Network network, ChemicalFilter filter) {
        ArrayList<Map<String, Object>> items = new ArrayList<Map<String, Object>>();
        StorageNetworkComponent storage = (StorageNetworkComponent)network.getComponent(StorageNetworkComponent.class);
        AutocraftingNetworkComponent autocrafting = (AutocraftingNetworkComponent)network.getComponent(AutocraftingNetworkComponent.class);
        for (ResourceAmount resourceAmount : storage.getAll()) {
            ChemicalResource fluidResource;
            ResourceKey resourceKey = resourceAmount.resource();
            if (!(resourceKey instanceof ChemicalResource) || !filter.test(ChemicalUtil.toChemicalStack((fluidResource = (ChemicalResource)resourceKey).chemical(), resourceAmount.amount()))) continue;
            items.add(RSApi.getObjectFromFluidResource(resourceAmount, autocrafting));
        }
        return items;
    }

    public static List<Map<String, Object>> getCraftableItems(Network network, ItemFilter filter) {
        ArrayList<Map<String, Object>> items = new ArrayList<Map<String, Object>>();
        AutocraftingNetworkComponent autocrafting = (AutocraftingNetworkComponent)network.getComponent(AutocraftingNetworkComponent.class);
        StorageNetworkComponent storage = (StorageNetworkComponent)network.getComponent(StorageNetworkComponent.class);
        for (ResourceKey key : autocrafting.getOutputs()) {
            ItemResource itemResource;
            if (!(key instanceof ItemResource) || !filter.test((itemResource = (ItemResource)key).toItemStack())) continue;
            items.add(RSApi.getObjectFromResourceKey(key, storage.get(key), autocrafting));
        }
        return items;
    }

    public static List<Map<String, Object>> getCraftableFluids(Network network, FluidFilter filter) {
        ArrayList<Map<String, Object>> items = new ArrayList<Map<String, Object>>();
        AutocraftingNetworkComponent autocrafting = (AutocraftingNetworkComponent)network.getComponent(AutocraftingNetworkComponent.class);
        StorageNetworkComponent storage = (StorageNetworkComponent)network.getComponent(StorageNetworkComponent.class);
        for (ResourceKey key : autocrafting.getOutputs()) {
            FluidResource fluidResource;
            long amount = storage.get(key);
            if (!(key instanceof FluidResource) || !filter.test(VariantUtil.toFluidStack((FluidResource)(fluidResource = (FluidResource)key), (long)amount))) continue;
            items.add(RSApi.getObjectFromResourceKey(key, amount, autocrafting));
        }
        return items;
    }

    public static List<Map<String, Object>> getCraftableChemicals(Network network, ChemicalFilter filter) {
        ArrayList<Map<String, Object>> items = new ArrayList<Map<String, Object>>();
        AutocraftingNetworkComponent autocrafting = (AutocraftingNetworkComponent)network.getComponent(AutocraftingNetworkComponent.class);
        StorageNetworkComponent storage = (StorageNetworkComponent)network.getComponent(StorageNetworkComponent.class);
        for (ResourceKey key : autocrafting.getOutputs()) {
            ChemicalResource chemicalResource;
            long amount = storage.get(key);
            if (!(key instanceof ChemicalResource) || !filter.test(ChemicalUtil.toChemicalStack((chemicalResource = (ChemicalResource)key).chemical(), amount))) continue;
            items.add(RSApi.getObjectFromResourceKey(key, amount, autocrafting));
        }
        return items;
    }

    public static List<Object> getPatterns(Network network) {
        ArrayList<Object> patterns = new ArrayList<Object>();
        AutocraftingNetworkComponent autocrafting = (AutocraftingNetworkComponent)network.getComponent(AutocraftingNetworkComponent.class);
        for (Pattern pattern : autocrafting.getPatterns()) {
            patterns.add(RSApi.parsePattern(pattern, autocrafting));
        }
        return patterns;
    }

    public static List<Object> listCells(Network network) {
        ArrayList<Object> disks = new ArrayList<Object>();
        GraphNetworkComponent graphNetworkComponent = (GraphNetworkComponent)network.getComponent(GraphNetworkComponent.class);
        for (InWorldNetworkNodeContainer nodeContainer : graphNetworkComponent.getContainers(InWorldNetworkNodeContainer.class)) {
            NetworkNode networkNode = nodeContainer.getNode();
            if (!(networkNode instanceof StorageNetworkNode)) continue;
            StorageNetworkNode storageNetworkNode = (StorageNetworkNode)networkNode;
            CompositeStorage storage = (CompositeStorage)storageNetworkNode.getStorage();
            for (Storage disk : storage.getSources()) {
                if (!(disk instanceof StateTrackedStorage)) continue;
                StateTrackedStorage stateTrackedStorage = (StateTrackedStorage)disk;
                disks.add(RSApi.parseStorageDisk(stateTrackedStorage));
            }
        }
        return disks;
    }

    public static List<Object> listDrives(Network network) {
        ArrayList<Object> drives = new ArrayList<Object>();
        GraphNetworkComponent graphNetworkComponent = (GraphNetworkComponent)network.getComponent(GraphNetworkComponent.class);
        for (InWorldNetworkNodeContainer nodeContainer : graphNetworkComponent.getContainers(InWorldNetworkNodeContainer.class)) {
            NetworkNode networkNode = nodeContainer.getNode();
            if (!(networkNode instanceof StorageNetworkNode)) continue;
            StorageNetworkNode storageNetworkNode = (StorageNetworkNode)networkNode;
            drives.add(RSApi.parseDiskDrive(storageNetworkNode, nodeContainer));
        }
        return drives;
    }

    public static Pair<Pattern, String> findPatternFromFilters(Network network, @Nullable GenericFilter<?> inputFilter, @Nullable GenericFilter<?> outputFilter) {
        AutocraftingNetworkComponent autocraftingComponent = (AutocraftingNetworkComponent)network.getComponent(AutocraftingNetworkComponent.class);
        for (Pattern pattern : autocraftingComponent.getPatterns()) {
            boolean outputMatch;
            boolean inputMatch;
            block8: {
                if (pattern.layout().ingredients().isEmpty() || pattern.layout().outputs().isEmpty()) continue;
                inputMatch = false;
                outputMatch = false;
                if (inputFilter != null) {
                    for (Ingredient input : pattern.layout().ingredients()) {
                        for (ResourceKey possibleInput : input.inputs()) {
                            if (!inputFilter.testRS(new ResourceAmount(possibleInput, 1L))) continue;
                            inputMatch = true;
                            break block8;
                        }
                    }
                } else {
                    inputMatch = true;
                }
            }
            if (outputFilter != null) {
                for (ResourceAmount output : pattern.layout().outputs()) {
                    if (!outputFilter.testRS(output)) continue;
                    outputMatch = true;
                    break;
                }
            } else {
                outputMatch = true;
            }
            if (!inputMatch || !outputMatch) continue;
            return Pair.of(pattern, null);
        }
        return Pair.of(null, "NO_PATTERN_FOUND");
    }

    public static long getTotalStorage(Network network, RsStorageTypes type) {
        long total = 0L;
        GraphNetworkComponent graphNetworkComponent = (GraphNetworkComponent)network.getComponent(GraphNetworkComponent.class);
        for (InWorldNetworkNodeContainer nodeContainer : graphNetworkComponent.getContainers(InWorldNetworkNodeContainer.class)) {
            NetworkNode networkNode = nodeContainer.getNode();
            if (!(networkNode instanceof StorageNetworkNode)) continue;
            StorageNetworkNode storageNetworkNode = (StorageNetworkNode)networkNode;
            CompositeStorage storage = (CompositeStorage)storageNetworkNode.getStorage();
            for (Storage disk : storage.getSources()) {
                if (!(disk instanceof StateTrackedStorage)) continue;
                StateTrackedStorage stateTrackedStorage = (StateTrackedStorage)disk;
                Storage storage2 = stateTrackedStorage.getDelegate();
                if (storage2 instanceof SerializableStorage) {
                    SerializableStorage serializableStorage = (SerializableStorage)storage2;
                    if (type.getStorageType() != null && serializableStorage.getType() != type.getStorageType()) continue;
                }
                total += stateTrackedStorage.getCapacity();
            }
        }
        return total;
    }

    public static long getUsedStorage(Network network, RsStorageTypes type) {
        long used = 0L;
        GraphNetworkComponent graphNetworkComponent = (GraphNetworkComponent)network.getComponent(GraphNetworkComponent.class);
        for (InWorldNetworkNodeContainer nodeContainer : graphNetworkComponent.getContainers(InWorldNetworkNodeContainer.class)) {
            NetworkNode networkNode = nodeContainer.getNode();
            if (!(networkNode instanceof StorageNetworkNode)) continue;
            StorageNetworkNode storageNetworkNode = (StorageNetworkNode)networkNode;
            CompositeStorage storage = (CompositeStorage)storageNetworkNode.getStorage();
            for (Storage disk : storage.getSources()) {
                if (!(disk instanceof StateTrackedStorage)) continue;
                StateTrackedStorage stateTrackedStorage = (StateTrackedStorage)disk;
                Storage storage2 = stateTrackedStorage.getDelegate();
                if (storage2 instanceof SerializableStorage) {
                    SerializableStorage serializableStorage = (SerializableStorage)storage2;
                    if (type.getStorageType() != null && serializableStorage.getType() != type.getStorageType()) continue;
                }
                used += stateTrackedStorage.getStored();
            }
        }
        return used;
    }

    public static long getTotalExternalStorage(Network network, RsStorageTypes type) {
        long total = 0L;
        GraphNetworkComponent graphNetworkComponent = (GraphNetworkComponent)network.getComponent(GraphNetworkComponent.class);
        for (InWorldNetworkNodeContainer nodeContainer : graphNetworkComponent.getContainers(InWorldNetworkNodeContainer.class)) {
            NetworkNode networkNode = nodeContainer.getNode();
            if (!(networkNode instanceof ExternalStorageNetworkNode)) continue;
            ExternalStorageNetworkNode storageNetworkNode = (ExternalStorageNetworkNode)networkNode;
            networkNode = (ExposedExternalStorage)storageNetworkNode.getStorage();
        }
        return total;
    }

    public static long getUsedExternalStorage(Network network, RsStorageTypes type) {
        long used = 0L;
        if (type.getStorageType() == null) {
            return used;
        }
        GraphNetworkComponent graphNetworkComponent = (GraphNetworkComponent)network.getComponent(GraphNetworkComponent.class);
        for (InWorldNetworkNodeContainer nodeContainer : graphNetworkComponent.getContainers(InWorldNetworkNodeContainer.class)) {
            NetworkNode networkNode = nodeContainer.getNode();
            if (!(networkNode instanceof ExternalStorageNetworkNode)) continue;
            ExternalStorageNetworkNode storageNetworkNode = (ExternalStorageNetworkNode)networkNode;
            ExposedExternalStorage storage = (ExposedExternalStorage)storageNetworkNode.getStorage();
            used += storage.getAll().stream().filter(amount -> type.getStorageType().isAllowed(amount.resource())).mapToLong(ResourceAmount::amount).sum();
        }
        return used;
    }

    public static List<Object> getCraftingTasks(Network network, RSBridgeEntity entity) {
        ArrayList<Object> tasks = new ArrayList<Object>();
        AutocraftingNetworkComponent autocrafting = (AutocraftingNetworkComponent)network.getComponent(AutocraftingNetworkComponent.class);
        block0: for (TaskStatus status : autocrafting.getStatuses()) {
            for (RSCraftJob task : entity.getJobs()) {
                if (!status.info().id().equals((Object)task.getCraftingTask().info().id())) continue;
                tasks.add(RSApi.parseCraftingTask(task, status, autocrafting));
                continue block0;
            }
            tasks.add(RSApi.parseCraftingTask(null, status, autocrafting));
        }
        return tasks;
    }

    public static long getEnergyUsage(Network network) {
        long energyUsage = 0L;
        GraphNetworkComponent graphNetworkComponent = (GraphNetworkComponent)network.getComponent(GraphNetworkComponent.class);
        for (InWorldNetworkNodeContainer nodeContainer : graphNetworkComponent.getContainers(InWorldNetworkNodeContainer.class)) {
            NetworkNode networkNode = nodeContainer.getNode();
            if (!(networkNode instanceof AbstractNetworkNode)) continue;
            AbstractNetworkNode abstractNetworkNode = (AbstractNetworkNode)networkNode;
            energyUsage += abstractNetworkNode.getEnergyUsage();
        }
        return energyUsage;
    }

    public static Map<String, Object> getObjectFromResourceKey(@NotNull ResourceKey resource, @Nullable AutocraftingNetworkComponent autocraftingComponent) {
        return RSApi.getObjectFromResourceKey(resource, 0L, autocraftingComponent);
    }

    public static Map<String, Object> getObjectFromResourceKey(@NotNull ResourceKey resource, long count, @Nullable AutocraftingNetworkComponent autocraftingComponent) {
        boolean countZeroOrLower;
        boolean bl = countZeroOrLower = count <= 0L;
        if (resource instanceof ItemResource) {
            if (countZeroOrLower) {
                return RSApi.getObjectFromItemResource(new ResourceAmount(resource, 1L), count, autocraftingComponent);
            }
            return RSApi.getObjectFromItemResource(new ResourceAmount(resource, count), autocraftingComponent);
        }
        if (resource instanceof FluidResource) {
            if (countZeroOrLower) {
                return RSApi.getObjectFromFluidResource(new ResourceAmount(resource, 1L), count, autocraftingComponent);
            }
            return RSApi.getObjectFromFluidResource(new ResourceAmount(resource, count), autocraftingComponent);
        }
        if (APAddon.REFINEDSTORAGE_MEKANISM.isLoaded() && resource instanceof ChemicalResource) {
            if (countZeroOrLower) {
                return RSApi.getObjectFromChemicalResource(new ResourceAmount(resource, 1L), count, autocraftingComponent);
            }
            return RSApi.getObjectFromChemicalResource(new ResourceAmount(resource, count), autocraftingComponent);
        }
        AdvancedPeripherals.debug("Could not create table from unknown resource " + String.valueOf(resource.getClass()) + " - Report this to the maintainer of ap", Level.WARN);
        return Collections.emptyMap();
    }

    public static Map<String, Object> getObjectFromResourceAmount(@NotNull ResourceAmount resourceAmount, @Nullable AutocraftingNetworkComponent autocraftingComponent) {
        if (resourceAmount.resource() instanceof ItemResource) {
            return RSApi.getObjectFromItemResource(resourceAmount, autocraftingComponent);
        }
        if (resourceAmount.resource() instanceof FluidResource) {
            return RSApi.getObjectFromFluidResource(resourceAmount, autocraftingComponent);
        }
        if (APAddon.REFINEDSTORAGE_MEKANISM.isLoaded() && resourceAmount.resource() instanceof ChemicalResource) {
            return RSApi.getObjectFromChemicalResource(resourceAmount, autocraftingComponent);
        }
        AdvancedPeripherals.debug("Could not create table from unknown resourceAmount " + String.valueOf(resourceAmount.getClass()) + " - Report this to the maintainer of ap", Level.WARN);
        return Collections.emptyMap();
    }

    public static boolean isSameResource(ResourceKey resource, ResourceKey toCompare) {
        if (resource == null || toCompare == null) {
            return false;
        }
        if (resource instanceof PlatformResourceKey) {
            PlatformResourceKey platformResource = (PlatformResourceKey)resource;
            if (toCompare instanceof PlatformResourceKey) {
                PlatformResourceKey toComparePlatformResource = (PlatformResourceKey)toCompare;
                if (platformResource.getResourceType() != toComparePlatformResource.getResourceType()) {
                    return false;
                }
            }
        }
        if (resource instanceof ItemResource) {
            ItemResource itemResource = (ItemResource)resource;
            if (toCompare instanceof ItemResource) {
                ItemResource toCompareItemResource = (ItemResource)toCompare;
                return ItemUtil.getRegistryKey(itemResource.item()).equals((Object)ItemUtil.getRegistryKey(toCompareItemResource.item()));
            }
        }
        if (resource instanceof FluidResource) {
            FluidResource fluidResource = (FluidResource)resource;
            if (toCompare instanceof FluidResource) {
                FluidResource toCompareFluidResource = (FluidResource)toCompare;
                return FluidUtil.getRegistryKey(fluidResource.fluid()).equals((Object)FluidUtil.getRegistryKey(toCompareFluidResource.fluid()));
            }
        }
        if (APAddon.REFINEDSTORAGE_MEKANISM.isLoaded() && resource instanceof ChemicalResource) {
            ChemicalResource chemicalResource = (ChemicalResource)resource;
            if (toCompare instanceof ChemicalResource) {
                ChemicalResource toCompareChemicalResource = (ChemicalResource)toCompare;
                return ChemicalUtil.getRegistryKey(chemicalResource.chemical()).equals((Object)ChemicalUtil.getRegistryKey(toCompareChemicalResource.chemical()));
            }
        }
        return false;
    }

    public static Object parseDiskDrive(StorageNetworkNode diskDrive, InWorldNetworkNodeContainer nodeContainer) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        StorageConfiguration storageConfiguration = diskDrive.getStorageConfiguration();
        CompositeStorage storage = (CompositeStorage)diskDrive.getStorage();
        ArrayList<Object> disks = new ArrayList<Object>();
        for (Storage disk : storage.getSources()) {
            if (!(disk instanceof StateTrackedStorage)) continue;
            StateTrackedStorage stateTrackedStorage = (StateTrackedStorage)disk;
            disks.add(RSApi.parseStorageDisk(stateTrackedStorage));
        }
        properties.put("used", diskDrive.getStored());
        properties.put("total", diskDrive.getCapacity());
        properties.put("disks", disks);
        properties.put("mode", storageConfiguration.getFilterMode().toString());
        properties.put("access_type", storageConfiguration.getAccessMode().toString());
        properties.put("position", LuaConverter.posToObject(nodeContainer.getLocalPosition()));
        properties.put("priority", nodeContainer.getPriority());
        return properties;
    }

    public static Object parseStorageDisk(StateTrackedStorage disk) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("used", disk.getStored());
        properties.put("capacity", disk.getCapacity());
        properties.put("state", disk.getState().toString());
        Storage storage = disk.getDelegate();
        if (storage instanceof SerializableStorage) {
            SerializableStorage serializableStorage = (SerializableStorage)storage;
            String type = serializableStorage.getType() == StorageTypes.ITEM ? "item" : (serializableStorage.getType() == StorageTypes.FLUID ? "fluid" : (APAddon.REFINEDSTORAGE_MEKANISM.isLoaded() && serializableStorage.getType() == ChemicalResourceType.STORAGE_TYPE ? "chemical" : "unknown"));
            properties.put("type", type);
        }
        return properties;
    }

    public static Object parseCraftingTask(@Nullable RSCraftJob task, TaskStatus status, @Nullable AutocraftingNetworkComponent autocraftingComponent) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("bridge_id", task == null ? -1L : task.getId());
        properties.put("id", status.info().id().toString());
        properties.put("quantity", status.info().amount());
        properties.put("crafted", status.items().stream().filter(item -> RSApi.isSameResource(item.resource(), status.info().resource())).map(item -> status.info().amount() - item.crafting()).findFirst().orElse(-1L));
        properties.put("resource", RSApi.getObjectFromResourceKey(status.info().resource(), status.info().amount(), autocraftingComponent));
        properties.put("completion", status.percentageCompleted());
        return properties;
    }

    public static Object parsePattern(Pattern pattern, @Nullable AutocraftingNetworkComponent autocraftingComponent) {
        if (pattern == null) {
            return null;
        }
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("primaryOutput", RSApi.getObjectFromResourceAmount((ResourceAmount)pattern.layout().outputs().getFirst(), autocraftingComponent));
        properties.put("outputs", pattern.layout().outputs().stream().map(resource -> RSApi.getObjectFromResourceAmount(resource, autocraftingComponent)).toList());
        List inputs = pattern.layout().ingredients().stream().map(ingredient -> ingredient.inputs().stream().map(key -> RSApi.getObjectFromResourceKey(key, ingredient.amount(), autocraftingComponent)).collect(Collectors.toList())).collect(Collectors.toList());
        properties.put("inputs", inputs);
        properties.put("patternType", pattern.layout().type().toString());
        properties.put("id", pattern.id().toString());
        return properties;
    }

    public static Map<String, Object> getObjectFromItemResource(ResourceAmount trackedResourceAmount, @Nullable AutocraftingNetworkComponent autocraftingComponent) {
        ItemResource resource = (ItemResource)trackedResourceAmount.resource();
        long count = trackedResourceAmount.amount();
        ItemStack stack = resource.toItemStack();
        Map<String, Object> properties = LuaConverter.itemStackToObject(stack, count);
        properties.put("isCraftable", autocraftingComponent != null && !autocraftingComponent.getPatternsByOutput(trackedResourceAmount.resource()).isEmpty());
        return properties;
    }

    public static Map<String, Object> getObjectFromItemResource(ResourceAmount trackedResourceAmount, long alternateCount, @Nullable AutocraftingNetworkComponent autocraftingComponent) {
        Map<String, Object> properties = RSApi.getObjectFromItemResource(trackedResourceAmount, autocraftingComponent);
        properties.put("count", alternateCount);
        return properties;
    }

    public static Map<String, Object> getObjectFromFluidResource(ResourceAmount trackedResourceAmount, @Nullable AutocraftingNetworkComponent autocraftingComponent) {
        FluidResource resource = (FluidResource)trackedResourceAmount.resource();
        long count = trackedResourceAmount.amount();
        FluidStack stack = VariantUtil.toFluidStack((FluidResource)resource, (long)count);
        Map<String, Object> properties = LuaConverter.fluidStackToObject(stack, count);
        properties.put("isCraftable", autocraftingComponent != null && !autocraftingComponent.getPatternsByOutput(trackedResourceAmount.resource()).isEmpty());
        return properties;
    }

    public static Map<String, Object> getObjectFromFluidResource(ResourceAmount trackedResourceAmount, long alternateCount, @Nullable AutocraftingNetworkComponent autocraftingComponent) {
        Map<String, Object> properties = RSApi.getObjectFromFluidResource(trackedResourceAmount, autocraftingComponent);
        properties.put("count", alternateCount);
        return properties;
    }

    public static Map<String, Object> getObjectFromChemicalResource(ResourceAmount trackedResourceAmount, @Nullable AutocraftingNetworkComponent autocraftingComponent) {
        ChemicalResource resource = (ChemicalResource)trackedResourceAmount.resource();
        long count = trackedResourceAmount.amount();
        ChemicalStack stack = RSApi.resourceToChemicalStack(resource, count);
        Map<String, Object> properties = LuaConverter.chemicalStackToObject(stack, count);
        properties.put("isCraftable", autocraftingComponent != null && !autocraftingComponent.getPatternsByOutput(trackedResourceAmount.resource()).isEmpty());
        return properties;
    }

    public static Map<String, Object> getObjectFromChemicalResource(ResourceAmount trackedResourceAmount, long alternateCount, @Nullable AutocraftingNetworkComponent autocraftingComponent) {
        Map<String, Object> properties = RSApi.getObjectFromChemicalResource(trackedResourceAmount, autocraftingComponent);
        properties.put("count", alternateCount);
        return properties;
    }

    public static ChemicalStack resourceToChemicalStack(ResourceAmount resourceAmount) {
        ResourceKey resourceKey = resourceAmount.resource();
        if (resourceKey instanceof ChemicalResource) {
            ChemicalResource chemicalResource = (ChemicalResource)resourceKey;
            return new ChemicalStack(MekanismAPI.CHEMICAL_REGISTRY.wrapAsHolder((Object)chemicalResource.chemical()), resourceAmount.amount());
        }
        return ChemicalStack.EMPTY;
    }

    public static ChemicalStack resourceToChemicalStack(ChemicalResource resource, long alternateCount) {
        return new ChemicalStack(MekanismAPI.CHEMICAL_REGISTRY.wrapAsHolder((Object)resource.chemical()), alternateCount);
    }

    public static ChemicalStack resourceToChemicalStack(ChemicalResource resource) {
        return RSApi.resourceToChemicalStack(resource, 1L);
    }
}

