/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.addons.computercraft.peripheral;

import appeng.api.crafting.IPatternDetails;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IManagedGridNode;
import appeng.api.networking.crafting.ICraftingCPU;
import appeng.api.networking.crafting.ICraftingService;
import appeng.api.stacks.AEFluidKey;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.storage.MEStorage;
import appeng.crafting.pattern.EncodedPatternItem;
import dan200.computercraft.api.lua.IArguments;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.lua.LuaTable;
import dan200.computercraft.api.lua.MethodResult;
import dan200.computercraft.api.lua.ObjectLuaTable;
import dan200.computercraft.api.peripheral.IComputerAccess;
import de.srendi.advancedperipherals.common.addons.APAddon;
import de.srendi.advancedperipherals.common.addons.appliedenergistics.AEApi;
import de.srendi.advancedperipherals.common.addons.appliedenergistics.AECraftJob;
import de.srendi.advancedperipherals.common.addons.appliedenergistics.AEMekanismApi;
import de.srendi.advancedperipherals.common.addons.appliedenergistics.MEFluidHandler;
import de.srendi.advancedperipherals.common.addons.appliedenergistics.MEItemHandler;
import de.srendi.advancedperipherals.common.addons.computercraft.owner.BlockEntityPeripheralOwner;
import de.srendi.advancedperipherals.common.blocks.blockentities.MEBridgeEntity;
import de.srendi.advancedperipherals.common.configuration.APConfig;
import de.srendi.advancedperipherals.common.util.EmptyLuaTable;
import de.srendi.advancedperipherals.common.util.Pair;
import de.srendi.advancedperipherals.common.util.StatusConstants;
import de.srendi.advancedperipherals.common.util.inventory.ChemicalFilter;
import de.srendi.advancedperipherals.common.util.inventory.FluidFilter;
import de.srendi.advancedperipherals.common.util.inventory.FluidUtil;
import de.srendi.advancedperipherals.common.util.inventory.GenericFilter;
import de.srendi.advancedperipherals.common.util.inventory.IStorageSystemPeripheral;
import de.srendi.advancedperipherals.common.util.inventory.InventoryUtil;
import de.srendi.advancedperipherals.common.util.inventory.ItemFilter;
import de.srendi.advancedperipherals.lib.peripherals.BasePeripheral;
import java.util.ArrayList;
import java.util.Map;
import me.ramidzkh.mekae2.ae2.MekanismKey;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MEBridgePeripheral
extends BasePeripheral<BlockEntityPeripheralOwner<MEBridgeEntity>>
implements IStorageSystemPeripheral {
    public static final String PERIPHERAL_TYPE = "me_bridge";
    private final MEBridgeEntity bridge;
    private IGridNode node;

    public MEBridgePeripheral(MEBridgeEntity tileEntity) {
        super(PERIPHERAL_TYPE, new BlockEntityPeripheralOwner<MEBridgeEntity>(tileEntity));
        this.bridge = tileEntity;
        this.node = tileEntity.getActionableNode();
    }

    public void setNode(IManagedGridNode node) {
        this.node = node.getNode();
    }

    @Override
    public boolean isEnabled() {
        return (Boolean)APConfig.PERIPHERALS_CONFIG.enableMEBridge.get();
    }

    private ICraftingService getCraftingService() {
        return this.node.getGrid().getCraftingService();
    }

    public MEBridgeEntity getBridge() {
        return this.bridge;
    }

    protected MethodResult exportToChest(@NotNull IArguments arguments, IItemHandler targetInventory) throws LuaException {
        MEStorage monitor = AEApi.getMonitor(this.node);
        MEItemHandler itemHandler = new MEItemHandler(monitor, this.bridge);
        Pair<ItemFilter, String> filter = ItemFilter.parse(new ObjectLuaTable(arguments.getTable(0)));
        if (filter.rightPresent()) {
            return MethodResult.of((Object[])new Object[]{0, filter.getRight()});
        }
        return MethodResult.of((Object[])new Object[]{InventoryUtil.moveItem(itemHandler, targetInventory, filter.getLeft()), null});
    }

    protected MethodResult exportToTank(@NotNull IArguments arguments, IFluidHandler targetTank) throws LuaException {
        MEStorage monitor = AEApi.getMonitor(this.node);
        MEFluidHandler fluidHandler = new MEFluidHandler(monitor, this.bridge);
        Pair<FluidFilter, String> filter = FluidFilter.parse(new ObjectLuaTable(arguments.getTable(0)));
        if (filter.rightPresent()) {
            return MethodResult.of((Object[])new Object[]{0, filter.getRight()});
        }
        return MethodResult.of((Object[])new Object[]{FluidUtil.moveFluid(fluidHandler, targetTank, filter.getLeft()), null});
    }

    protected MethodResult importToME(@NotNull IArguments arguments, IItemHandler targetInventory) throws LuaException {
        MEStorage monitor = AEApi.getMonitor(this.node);
        MEItemHandler itemHandler = new MEItemHandler(monitor, this.bridge);
        Pair<ItemFilter, String> filter = ItemFilter.parse(new ObjectLuaTable(arguments.getTable(0)));
        if (filter.rightPresent()) {
            return MethodResult.of((Object[])new Object[]{0, filter.getRight()});
        }
        return MethodResult.of((Object[])new Object[]{InventoryUtil.moveItem(targetInventory, itemHandler, filter.getLeft()), null});
    }

    protected MethodResult importToME(@NotNull IArguments arguments, IFluidHandler targetTank) throws LuaException {
        MEStorage monitor = AEApi.getMonitor(this.node);
        MEFluidHandler fluidHandler = new MEFluidHandler(monitor, this.bridge);
        Pair<FluidFilter, String> filter = FluidFilter.parse(new ObjectLuaTable(arguments.getTable(0)));
        if (filter.rightPresent()) {
            return MethodResult.of((Object[])new Object[]{0, filter.getRight()});
        }
        return MethodResult.of((Object[])new Object[]{FluidUtil.moveFluid(targetTank, fluidHandler, filter.getLeft()), null});
    }

    private MethodResult notConnected(@Nullable Object defaultValue) {
        return MethodResult.of((Object[])new Object[]{defaultValue, StatusConstants.NOT_CONNECTED.toString()});
    }

    private boolean isAvailable() {
        return this.node.hasGridBooted();
    }

    @Override
    @LuaFunction(mainThread=true)
    public final boolean isConnected() {
        return this.isAvailable();
    }

    @Override
    @LuaFunction(mainThread=true)
    public MethodResult isOnline() {
        return MethodResult.of((Object)this.node.isOnline());
    }

    @Override
    @LuaFunction(mainThread=true)
    public final MethodResult getItem(IArguments arguments) throws LuaException {
        if (!this.isAvailable()) {
            return this.notConnected(null);
        }
        MEStorage monitor = AEApi.getMonitor(this.node);
        Pair<ItemFilter, String> filter = ItemFilter.parse(new ObjectLuaTable(arguments.getTable(0)));
        if (filter.rightPresent()) {
            return MethodResult.of((Object[])new Object[]{null, filter.getRight()});
        }
        ItemFilter parsedFilter = filter.getLeft();
        if (parsedFilter.isEmpty()) {
            return MethodResult.of((Object[])new Object[]{null, StatusConstants.EMPTY_FILTER.toString()});
        }
        return MethodResult.of(AEApi.parseAeStack(AEApi.findAEStackFromFilter(monitor, this.getCraftingService(), parsedFilter), this.getCraftingService()));
    }

    @Override
    @LuaFunction(mainThread=true)
    public MethodResult getFluid(IArguments arguments) throws LuaException {
        if (!this.isAvailable()) {
            return this.notConnected(null);
        }
        Pair<FluidFilter, String> filter = FluidFilter.parse(new ObjectLuaTable(arguments.getTable(0)));
        if (filter.rightPresent()) {
            return MethodResult.of((Object[])new Object[]{null, filter.getRight()});
        }
        FluidFilter parsedFilter = filter.getLeft();
        if (parsedFilter.isEmpty()) {
            return MethodResult.of((Object[])new Object[]{null, StatusConstants.EMPTY_FILTER.toString()});
        }
        return MethodResult.of(AEApi.parseAeStack(AEApi.findAEFluidFromFilter(AEApi.getMonitor(this.node), this.getCraftingService(), parsedFilter), this.getCraftingService()));
    }

    @Override
    @LuaFunction(mainThread=true)
    public MethodResult getChemical(IArguments arguments) throws LuaException {
        if (!this.isAvailable()) {
            return this.notConnected(null);
        }
        Pair<ChemicalFilter, String> filter = ChemicalFilter.parse(new ObjectLuaTable(arguments.getTable(0)));
        if (filter.rightPresent()) {
            return MethodResult.of((Object[])new Object[]{null, filter.getRight()});
        }
        ChemicalFilter parsedFilter = filter.getLeft();
        if (parsedFilter.isEmpty()) {
            return MethodResult.of((Object[])new Object[]{null, StatusConstants.EMPTY_FILTER.toString()});
        }
        return MethodResult.of(AEApi.parseAeStack(AEApi.findAEChemicalFromFilter(AEApi.getMonitor(this.node), this.getCraftingService(), parsedFilter), this.getCraftingService()));
    }

    @Override
    @LuaFunction(mainThread=true)
    public final MethodResult getItems(IArguments arguments) throws LuaException {
        if (!this.isAvailable()) {
            return this.notConnected(null);
        }
        Pair<ItemFilter, String> filter = ItemFilter.parse(EmptyLuaTable.orEmpty(arguments.optTable(0).orElse(null)));
        if (filter.rightPresent()) {
            return MethodResult.of((Object[])new Object[]{null, filter.getRight()});
        }
        ItemFilter parsedFilter = filter.getLeft();
        return MethodResult.of(AEApi.listItems(AEApi.getMonitor(this.node), this.getCraftingService(), parsedFilter));
    }

    @Override
    @LuaFunction(mainThread=true)
    public final MethodResult getFluids(IArguments arguments) throws LuaException {
        if (!this.isAvailable()) {
            return this.notConnected(null);
        }
        Pair<FluidFilter, String> filter = FluidFilter.parse(EmptyLuaTable.orEmpty(arguments.optTable(0).orElse(null)));
        if (filter.rightPresent()) {
            return MethodResult.of((Object[])new Object[]{null, filter.getRight()});
        }
        FluidFilter parsedFilter = filter.getLeft();
        return MethodResult.of(AEApi.listFluids(AEApi.getMonitor(this.node), this.getCraftingService(), parsedFilter));
    }

    @Override
    @LuaFunction(mainThread=true)
    public MethodResult getChemicals(IArguments arguments) throws LuaException {
        if (!this.isAvailable()) {
            return this.notConnected(null);
        }
        if (!APAddon.APP_MEKANISTICS.isLoaded()) {
            return MethodResult.of((Object[])new Object[]{null, StatusConstants.ADDON_NOT_LOADED.withInfo(APAddon.APP_MEKANISTICS.name())});
        }
        Pair<ChemicalFilter, String> filter = ChemicalFilter.parse(EmptyLuaTable.orEmpty(arguments.optTable(0).orElse(null)));
        if (filter.rightPresent()) {
            return MethodResult.of((Object[])new Object[]{null, filter.getRight()});
        }
        ChemicalFilter parsedFilter = filter.getLeft();
        return MethodResult.of(AEApi.listChemicals(AEApi.getMonitor(this.node), this.getCraftingService(), parsedFilter));
    }

    @Override
    @LuaFunction(mainThread=true)
    public final MethodResult getCraftableItems(IArguments arguments) throws LuaException {
        if (!this.isAvailable()) {
            return this.notConnected(null);
        }
        Pair<ItemFilter, String> filter = ItemFilter.parse(EmptyLuaTable.orEmpty(arguments.optTable(0).orElse(null)));
        if (filter.rightPresent()) {
            return MethodResult.of((Object[])new Object[]{null, filter.getRight()});
        }
        ItemFilter parsedFilter = filter.getLeft();
        return MethodResult.of(AEApi.listCraftableItems(AEApi.getMonitor(this.node), this.getCraftingService(), parsedFilter));
    }

    @Override
    @LuaFunction(mainThread=true)
    public final MethodResult getCraftableFluids(IArguments arguments) throws LuaException {
        if (!this.isAvailable()) {
            return this.notConnected(null);
        }
        Pair<FluidFilter, String> filter = FluidFilter.parse(EmptyLuaTable.orEmpty(arguments.optTable(0).orElse(null)));
        if (filter.rightPresent()) {
            return MethodResult.of((Object[])new Object[]{null, filter.getRight()});
        }
        FluidFilter parsedFilter = filter.getLeft();
        return MethodResult.of(AEApi.listCraftableFluids(AEApi.getMonitor(this.node), this.getCraftingService(), parsedFilter));
    }

    @Override
    public MethodResult getCraftableChemicals(IArguments arguments) throws LuaException {
        if (!this.isAvailable()) {
            return this.notConnected(null);
        }
        if (!APAddon.APP_MEKANISTICS.isLoaded()) {
            return MethodResult.of((Object[])new Object[]{null, StatusConstants.ADDON_NOT_LOADED.withInfo(APAddon.APP_MEKANISTICS.name())});
        }
        Pair<ChemicalFilter, String> filter = ChemicalFilter.parse(EmptyLuaTable.orEmpty(arguments.optTable(0).orElse(null)));
        if (filter.rightPresent()) {
            return MethodResult.of((Object[])new Object[]{null, filter.getRight()});
        }
        ChemicalFilter parsedFilter = filter.getLeft();
        return MethodResult.of(AEApi.listCraftableChemicals(AEApi.getMonitor(this.node), this.getCraftingService(), parsedFilter));
    }

    @Override
    @LuaFunction(mainThread=true)
    public final MethodResult getCells() {
        if (!this.isAvailable()) {
            return this.notConnected(null);
        }
        return MethodResult.of(AEApi.listCells(this.node));
    }

    @Override
    @LuaFunction(mainThread=true)
    public MethodResult getDrives() {
        if (!this.isAvailable()) {
            return this.notConnected(null);
        }
        return MethodResult.of(AEApi.listDrives(this.node.getGrid()));
    }

    @Override
    @LuaFunction(mainThread=true)
    public final MethodResult importItem(IComputerAccess computer, IArguments arguments) throws LuaException {
        if (!this.isAvailable()) {
            return this.notConnected(0);
        }
        String side = arguments.getString(1);
        IItemHandler inventory = InventoryUtil.getHandlerFromDirection(side, this.owner);
        if (inventory == null) {
            inventory = InventoryUtil.getHandlerFromName(computer, side);
        }
        if (inventory == null) {
            return MethodResult.of((Object[])new Object[]{0, StatusConstants.INVENTORY_NOT_FOUND.name()});
        }
        return this.importToME(arguments, inventory);
    }

    @Override
    @LuaFunction(mainThread=true)
    public final MethodResult exportItem(IComputerAccess computer, @NotNull IArguments arguments) throws LuaException {
        if (!this.isAvailable()) {
            return this.notConnected(0);
        }
        String side = arguments.getString(1);
        IItemHandler inventory = InventoryUtil.getHandlerFromDirection(side, this.owner);
        if (inventory == null) {
            inventory = InventoryUtil.getHandlerFromName(computer, side);
        }
        if (inventory == null) {
            return MethodResult.of((Object[])new Object[]{0, StatusConstants.INVENTORY_NOT_FOUND.name()});
        }
        return this.exportToChest(arguments, inventory);
    }

    @Override
    @LuaFunction(mainThread=true)
    public final MethodResult importFluid(IComputerAccess computer, IArguments arguments) throws LuaException {
        if (!this.isAvailable()) {
            return this.notConnected(0);
        }
        String side = arguments.getString(1);
        IFluidHandler fluidHandler = FluidUtil.getHandlerFromDirection(side, this.owner);
        if (fluidHandler == null) {
            fluidHandler = FluidUtil.getHandlerFromName(computer, side);
        }
        if (fluidHandler == null) {
            return MethodResult.of((Object[])new Object[]{0, StatusConstants.INVENTORY_NOT_FOUND.name()});
        }
        return this.importToME(arguments, fluidHandler);
    }

    @Override
    @LuaFunction(mainThread=true)
    public final MethodResult exportFluid(IComputerAccess computer, IArguments arguments) throws LuaException {
        if (!this.isAvailable()) {
            return this.notConnected(0);
        }
        String side = arguments.getString(1);
        IFluidHandler fluidHandler = FluidUtil.getHandlerFromDirection(side, this.owner);
        if (fluidHandler == null) {
            fluidHandler = FluidUtil.getHandlerFromName(computer, side);
        }
        if (fluidHandler == null) {
            return MethodResult.of((Object[])new Object[]{0, StatusConstants.INVENTORY_NOT_FOUND.name()});
        }
        return this.exportToTank(arguments, fluidHandler);
    }

    @Override
    @LuaFunction(mainThread=true)
    public MethodResult importChemical(IComputerAccess computer, IArguments arguments) throws LuaException {
        if (!this.isAvailable()) {
            return this.notConnected(0);
        }
        if (!APAddon.APP_MEKANISTICS.isLoaded()) {
            return MethodResult.of((Object[])new Object[]{null, StatusConstants.ADDON_NOT_LOADED.withInfo(APAddon.APP_MEKANISTICS.name())});
        }
        return AEMekanismApi.importToME(arguments, computer, this);
    }

    @Override
    @LuaFunction(mainThread=true)
    public MethodResult exportChemical(IComputerAccess computer, IArguments arguments) throws LuaException {
        if (!this.isAvailable()) {
            return this.notConnected(0);
        }
        if (!APAddon.APP_MEKANISTICS.isLoaded()) {
            return MethodResult.of((Object[])new Object[]{null, StatusConstants.ADDON_NOT_LOADED.withInfo(APAddon.APP_MEKANISTICS.name())});
        }
        return AEMekanismApi.exportToTank(arguments, computer, this);
    }

    @Override
    @LuaFunction(mainThread=true)
    public MethodResult getPatterns(IArguments arguments) throws LuaException {
        Pair<Pair<EncodedPatternItem<?>, IPatternDetails>, String> pattern;
        boolean hasAnyFilter;
        if (!this.isAvailable()) {
            return this.notConnected(null);
        }
        LuaTable<Object, Object> filterTable = EmptyLuaTable.orEmpty(arguments.optTable(0).orElse(null));
        if (filterTable.isEmpty()) {
            return MethodResult.of(AEApi.listPatterns(this.node.getGrid(), this.getLevel()));
        }
        boolean hasInputFilter = filterTable.containsKey((Object)"input");
        boolean hasOutputFilter = filterTable.containsKey((Object)"output");
        boolean bl = hasAnyFilter = hasInputFilter || hasOutputFilter;
        if (!hasAnyFilter) {
            return MethodResult.of((Object[])new Object[]{null, "NO_FILTER"});
        }
        GenericFilter<?> inputFilter = null;
        GenericFilter<?> outputFilter = null;
        if (hasInputFilter) {
            ObjectLuaTable inputFilterTable = new ObjectLuaTable(filterTable.getTable("input"));
            inputFilter = GenericFilter.parseGeneric(inputFilterTable).getLeft();
        }
        if (hasOutputFilter) {
            ObjectLuaTable outputFilterTable = new ObjectLuaTable(filterTable.getTable("output"));
            outputFilter = GenericFilter.parseGeneric(outputFilterTable).getLeft();
        }
        if ((pattern = AEApi.findPatternFromFilters(this.node.getGrid(), this.getLevel(), inputFilter, outputFilter)).getRight() != null) {
            return MethodResult.of((Object[])new Object[]{null, pattern.getRight()});
        }
        return MethodResult.of(AEApi.parsePattern(pattern.getLeft()));
    }

    @Override
    @LuaFunction(mainThread=true)
    public final MethodResult getStoredEnergy() {
        if (!this.isAvailable()) {
            return this.notConnected(0);
        }
        return MethodResult.of((Object)this.node.getGrid().getEnergyService().getStoredPower());
    }

    @Override
    @LuaFunction(mainThread=true)
    public final MethodResult getEnergyCapacity() {
        if (!this.isAvailable()) {
            return this.notConnected(0);
        }
        return MethodResult.of((Object)this.node.getGrid().getEnergyService().getMaxStoredPower());
    }

    @Override
    @LuaFunction(mainThread=true)
    public final MethodResult getEnergyUsage() {
        if (!this.isAvailable()) {
            return this.notConnected(0);
        }
        return MethodResult.of((Object)this.node.getGrid().getEnergyService().getAvgPowerUsage());
    }

    @Override
    @LuaFunction(mainThread=true)
    public final MethodResult getAverageEnergyInput() {
        if (!this.isAvailable()) {
            return this.notConnected(0);
        }
        return MethodResult.of((Object)this.node.getGrid().getEnergyService().getAvgPowerInjection());
    }

    @Override
    @LuaFunction(mainThread=true)
    public MethodResult getTotalExternalItemStorage() {
        if (!this.isAvailable()) {
            return this.notConnected(0);
        }
        return MethodResult.of((Object)AEApi.getTotalExternalItemStorage(this.node));
    }

    @Override
    @LuaFunction(mainThread=true)
    public MethodResult getTotalExternalFluidStorage() {
        if (!this.isAvailable()) {
            return this.notConnected(0);
        }
        return MethodResult.of((Object)AEApi.getTotalExternalFluidStorage(this.node));
    }

    @Override
    @LuaFunction(mainThread=true)
    public MethodResult getTotalExternalChemicalStorage() {
        if (!this.isAvailable()) {
            return this.notConnected(0);
        }
        return MethodResult.of((Object)AEApi.getTotalExternalChemicalStorage(this.node));
    }

    @Override
    @LuaFunction(mainThread=true)
    public final MethodResult getTotalItemStorage() {
        if (!this.isAvailable()) {
            return this.notConnected(0);
        }
        return MethodResult.of((Object)AEApi.getTotalItemStorage(this.node));
    }

    @Override
    @LuaFunction(mainThread=true)
    public final MethodResult getTotalFluidStorage() {
        if (!this.isAvailable()) {
            return this.notConnected(0);
        }
        return MethodResult.of((Object)AEApi.getTotalFluidStorage(this.node));
    }

    @Override
    @LuaFunction(mainThread=true)
    public MethodResult getTotalChemicalStorage() {
        if (!this.isAvailable()) {
            return this.notConnected(0);
        }
        return MethodResult.of((Object)AEApi.getTotalChemicalStorage(this.node));
    }

    @Override
    @LuaFunction(mainThread=true)
    public MethodResult getUsedExternalItemStorage() {
        if (!this.isAvailable()) {
            return this.notConnected(0);
        }
        return MethodResult.of((Object)AEApi.getUsedExternalItemStorage(this.node));
    }

    @Override
    @LuaFunction(mainThread=true)
    public MethodResult getUsedExternalFluidStorage() {
        if (!this.isAvailable()) {
            return this.notConnected(0);
        }
        return MethodResult.of((Object)AEApi.getUsedExternalFluidStorage(this.node));
    }

    @Override
    @LuaFunction(mainThread=true)
    public MethodResult getUsedExternalChemicalStorage() {
        if (!this.isAvailable()) {
            return this.notConnected(0);
        }
        return MethodResult.of((Object)AEApi.getUsedExternalChemicalStorage(this.node));
    }

    @Override
    @LuaFunction(mainThread=true)
    public final MethodResult getUsedItemStorage() {
        if (!this.isAvailable()) {
            return this.notConnected(0);
        }
        return MethodResult.of((Object)AEApi.getUsedItemStorage(this.node));
    }

    @Override
    @LuaFunction(mainThread=true)
    public final MethodResult getUsedFluidStorage() {
        if (!this.isAvailable()) {
            return this.notConnected(0);
        }
        return MethodResult.of((Object)AEApi.getUsedFluidStorage(this.node));
    }

    @Override
    @LuaFunction(mainThread=true)
    public MethodResult getUsedChemicalStorage() {
        if (!this.isAvailable()) {
            return this.notConnected(0);
        }
        return MethodResult.of((Object)AEApi.getUsedChemicalStorage(this.node));
    }

    @Override
    @LuaFunction(mainThread=true)
    public MethodResult getAvailableExternalItemStorage() {
        if (!this.isAvailable()) {
            return this.notConnected(0);
        }
        return MethodResult.of((Object)AEApi.getAvailableExternalItemStorage(this.node));
    }

    @Override
    @LuaFunction(mainThread=true)
    public MethodResult getAvailableExternalFluidStorage() {
        if (!this.isAvailable()) {
            return this.notConnected(0);
        }
        return MethodResult.of((Object)AEApi.getAvailableExternalFluidStorage(this.node));
    }

    @Override
    @LuaFunction(mainThread=true)
    public MethodResult getAvailableExternalChemicalStorage() {
        if (!this.isAvailable()) {
            return this.notConnected(0);
        }
        return MethodResult.of((Object)AEApi.getAvailableExternalChemicalStorage(this.node));
    }

    @Override
    @LuaFunction(mainThread=true)
    public final MethodResult getAvailableItemStorage() {
        if (!this.isAvailable()) {
            return this.notConnected(0);
        }
        return MethodResult.of((Object)AEApi.getAvailableItemStorage(this.node));
    }

    @Override
    @LuaFunction(mainThread=true)
    public final MethodResult getAvailableFluidStorage() {
        if (!this.isAvailable()) {
            return this.notConnected(0);
        }
        return MethodResult.of((Object)AEApi.getAvailableFluidStorage(this.node));
    }

    @Override
    @LuaFunction(mainThread=true)
    public MethodResult getAvailableChemicalStorage() {
        if (!this.isAvailable()) {
            return this.notConnected(0);
        }
        return MethodResult.of((Object)AEApi.getAvailableChemicalStorage(this.node));
    }

    @Override
    @LuaFunction
    public final MethodResult craftItem(IComputerAccess computer, IArguments arguments) throws LuaException {
        if (!this.isAvailable()) {
            return this.notConnected(null);
        }
        Pair<ItemFilter, String> filter = ItemFilter.parse(new ObjectLuaTable(arguments.getTable(0)));
        if (filter.rightPresent()) {
            return MethodResult.of((Object[])new Object[]{null, filter.getRight()});
        }
        ItemFilter parsedFilter = filter.getLeft();
        if (parsedFilter.isEmpty()) {
            return MethodResult.of((Object[])new Object[]{null, StatusConstants.EMPTY_FILTER.toString()});
        }
        String cpuName = arguments.optString(1, "");
        ICraftingCPU target = AEApi.getCraftingCPU(this.node, cpuName);
        if (!cpuName.isEmpty() && target == null) {
            return MethodResult.of((Object[])new Object[]{null, StatusConstants.CPU_NOT_FOUND.withInfo(cpuName)});
        }
        ICraftingService craftingGrid = (ICraftingService)this.node.getGrid().getService(ICraftingService.class);
        Pair<Long, AEItemKey> stack = AEApi.findAEStackFromFilter(AEApi.getMonitor(this.bridge.getGridNode()), craftingGrid, parsedFilter);
        if (stack.getRight() == null && stack.getLeft() == 0L) {
            return MethodResult.of((Object[])new Object[]{null, StatusConstants.NOT_CRAFTABLE.toString()});
        }
        AECraftJob job = new AECraftJob(((BlockEntityPeripheralOwner)this.owner).getLevel(), computer, this.node, (AEKey)stack.getRight(), parsedFilter.getCount(), this.bridge, target);
        this.bridge.addJob(job);
        return MethodResult.of((Object)job.withCPU(target));
    }

    @Override
    @LuaFunction
    public final MethodResult craftFluid(IComputerAccess computer, IArguments arguments) throws LuaException {
        if (!this.isAvailable()) {
            return this.notConnected(null);
        }
        Pair<FluidFilter, String> filter = FluidFilter.parse(new ObjectLuaTable(arguments.getTable(0)));
        if (filter.rightPresent()) {
            return MethodResult.of((Object[])new Object[]{null, filter.getRight()});
        }
        FluidFilter parsedFilter = filter.getLeft();
        if (parsedFilter.isEmpty()) {
            return MethodResult.of((Object[])new Object[]{null, StatusConstants.EMPTY_FILTER.toString()});
        }
        String cpuName = arguments.optString(1, "");
        ICraftingCPU target = AEApi.getCraftingCPU(this.node, cpuName);
        if (!cpuName.isEmpty() && target == null) {
            return MethodResult.of((Object[])new Object[]{null, StatusConstants.CPU_NOT_FOUND.withInfo(cpuName)});
        }
        ICraftingService craftingGrid = (ICraftingService)this.node.getGrid().getService(ICraftingService.class);
        Pair<Long, AEFluidKey> stack = AEApi.findAEFluidFromFilter(AEApi.getMonitor(this.bridge.getGridNode()), craftingGrid, parsedFilter);
        if (stack.getRight() == null && stack.getLeft() == 0L) {
            return MethodResult.of((Object[])new Object[]{false, StatusConstants.NOT_CRAFTABLE.toString()});
        }
        AECraftJob job = new AECraftJob(((BlockEntityPeripheralOwner)this.owner).getLevel(), computer, this.node, (AEKey)stack.getRight(), parsedFilter.getAmount(), this.bridge, target);
        this.bridge.addJob(job);
        return MethodResult.of((Object)job.withCPU(target));
    }

    @Override
    public MethodResult craftChemical(IComputerAccess computer, IArguments arguments) throws LuaException {
        if (!this.isAvailable()) {
            return this.notConnected(null);
        }
        if (!APAddon.APP_MEKANISTICS.isLoaded()) {
            return MethodResult.of((Object[])new Object[]{null, StatusConstants.ADDON_NOT_LOADED.withInfo(APAddon.APP_MEKANISTICS.name())});
        }
        Pair<ChemicalFilter, String> filter = ChemicalFilter.parse(new ObjectLuaTable(arguments.getTable(0)));
        if (filter.rightPresent()) {
            return MethodResult.of((Object[])new Object[]{null, filter.getRight()});
        }
        ChemicalFilter parsedFilter = filter.getLeft();
        if (parsedFilter.isEmpty()) {
            return MethodResult.of((Object[])new Object[]{null, StatusConstants.EMPTY_FILTER.toString()});
        }
        String cpuName = arguments.optString(1, "");
        ICraftingCPU target = AEApi.getCraftingCPU(this.node, cpuName);
        if (!cpuName.isEmpty() && target == null) {
            return MethodResult.of((Object[])new Object[]{null, StatusConstants.CPU_NOT_FOUND.withInfo(cpuName)});
        }
        ICraftingService craftingGrid = (ICraftingService)this.node.getGrid().getService(ICraftingService.class);
        Pair<Long, MekanismKey> stack = AEApi.findAEChemicalFromFilter(AEApi.getMonitor(this.bridge.getGridNode()), craftingGrid, parsedFilter);
        if (stack.getRight() == null && stack.getLeft() == 0L) {
            return MethodResult.of((Object[])new Object[]{false, StatusConstants.NOT_CRAFTABLE.toString()});
        }
        AECraftJob job = new AECraftJob(((BlockEntityPeripheralOwner)this.owner).getLevel(), computer, this.node, (AEKey)stack.getRight(), parsedFilter.getAmount(), this.bridge, target);
        this.bridge.addJob(job);
        return MethodResult.of((Object)job.withCPU(target));
    }

    @Override
    @LuaFunction(mainThread=true)
    public MethodResult getCraftingTasks() {
        if (!this.isAvailable()) {
            return this.notConnected(null);
        }
        ICraftingService craftingGrid = (ICraftingService)this.node.getGrid().getService(ICraftingService.class);
        ArrayList<Object> jobs = new ArrayList<Object>();
        for (AECraftJob job : this.bridge.getJobs()) {
            for (ICraftingCPU cpu : craftingGrid.getCpus()) {
                if (!cpu.isBusy() || !job.getToCraft().matches(cpu.getJobStatus().crafting())) continue;
                jobs.add(AEApi.parseCraftingJob(cpu.getJobStatus(), job, cpu));
            }
        }
        return MethodResult.of(jobs);
    }

    @Override
    @LuaFunction(mainThread=true)
    public MethodResult getCraftingTask(int id) {
        if (!this.isAvailable()) {
            return this.notConnected(null);
        }
        AECraftJob foundJob = null;
        for (AECraftJob job : this.bridge.getJobs()) {
            if (job.getId() != (long)id) continue;
            foundJob = job;
            break;
        }
        return MethodResult.of(foundJob);
    }

    @Override
    @LuaFunction(mainThread=true)
    public MethodResult cancelCraftingTasks(IArguments arguments) throws LuaException {
        if (!this.isAvailable()) {
            return this.notConnected(0);
        }
        ICraftingService craftingGrid = (ICraftingService)this.node.getGrid().getService(ICraftingService.class);
        Pair<GenericFilter<?>, String> filter = GenericFilter.parseGeneric(new ObjectLuaTable(arguments.getTable(0)));
        if (filter.getRight() != null) {
            return MethodResult.of((Object[])new Object[]{0, filter.getRight()});
        }
        GenericFilter<?> parsedFilter = filter.getLeft();
        int jobsCanceled = 0;
        for (ICraftingCPU cpu : craftingGrid.getCpus()) {
            if (cpu.getJobStatus() == null || !parsedFilter.testAE(cpu.getJobStatus().crafting())) continue;
            cpu.cancelJob();
            ++jobsCanceled;
        }
        return MethodResult.of((Object)jobsCanceled);
    }

    @Override
    @LuaFunction(mainThread=true)
    public final MethodResult isCraftable(IArguments arguments) throws LuaException {
        if (!this.isAvailable()) {
            return this.notConnected(false);
        }
        Pair<GenericFilter<?>, String> filter = GenericFilter.parseGeneric(new ObjectLuaTable(arguments.getTable(0)));
        if (filter.getRight() != null) {
            return MethodResult.of((Object[])new Object[]{false, filter.getRight()});
        }
        GenericFilter<?> parsedFilter = filter.getLeft();
        if (parsedFilter.isEmpty()) {
            return MethodResult.of((Object[])new Object[]{false, StatusConstants.EMPTY_FILTER.toString()});
        }
        return MethodResult.of((Object)(AEApi.findPatternFromFilters(this.node.getGrid(), this.getLevel(), null, parsedFilter).getLeft() != null ? 1 : 0));
    }

    @Override
    @LuaFunction(mainThread=true)
    public final MethodResult isCrafting(IArguments arguments) throws LuaException {
        if (!this.isAvailable()) {
            return this.notConnected(false);
        }
        ICraftingService grid = (ICraftingService)this.node.getGrid().getService(ICraftingService.class);
        Pair<GenericFilter<?>, String> filter = GenericFilter.parseGeneric(new ObjectLuaTable(arguments.getTable(0)));
        if (filter.getRight() != null) {
            return MethodResult.of((Object[])new Object[]{false, filter.getRight()});
        }
        GenericFilter<?> parsedFilter = filter.getLeft();
        if (parsedFilter.isEmpty()) {
            return MethodResult.of((Object[])new Object[]{false, StatusConstants.EMPTY_FILTER.toString()});
        }
        String cpuName = arguments.optString(1, "");
        ICraftingCPU craftingCPU = AEApi.getCraftingCPU(this.node, cpuName);
        return MethodResult.of((Object)AEApi.isCrafting(grid, parsedFilter, craftingCPU));
    }

    @LuaFunction(mainThread=true)
    public final MethodResult getCraftingCPUs() {
        if (!this.isAvailable()) {
            return this.notConnected(null);
        }
        ICraftingService grid = (ICraftingService)this.node.getGrid().getService(ICraftingService.class);
        ArrayList<Map<String, Object>> map = new ArrayList<Map<String, Object>>();
        for (ICraftingCPU iCraftingCPU : grid.getCpus()) {
            Map<String, Object> cpu = AEApi.parseCraftingCPU(iCraftingCPU, false);
            map.add(cpu);
        }
        return MethodResult.of(map);
    }
}

