/*
 * Decompiled with CFR 0.152.
 */
package dev.corgitaco.ohthetreesyoullgrow.world.level.levelgen.feature;

import com.mojang.serialization.Codec;
import dev.corgitaco.ohthetreesyoullgrow.world.level.chunk.RandomTickScheduler;
import dev.corgitaco.ohthetreesyoullgrow.world.level.levelgen.feature.configurations.TreeFromStructureNBTConfigV2;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TreeFromStructureNBTFeatureV2
extends Feature<TreeFromStructureNBTConfigV2> {
    private static final boolean DEBUG = false;
    public static final List<BlockStateModifier> BLOCK_STATE_MODIFIERS = (List)Util.make(new ArrayList(), list -> {
        list.add((modifiedPos, state, nbtState, rotation, level, directionOfGrowth) -> {
            for (Property property : state.getProperties()) {
                if (!nbtState.hasProperty(property)) continue;
                Comparable value = nbtState.getValue(property);
                state = (BlockState)state.setValue(property, value);
            }
            return state;
        });
        list.add((modifiedPos, lastState, nbtState, rotation, level, directionOfGrowth) -> {
            if (lastState.hasProperty((Property)BlockStateProperties.WATERLOGGED)) {
                FluidState fluidState = level.getFluidState(modifiedPos);
                lastState = fluidState.is((Fluid)Fluids.WATER) && fluidState.getAmount() >= 7 ? (BlockState)lastState.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(true)) : (BlockState)lastState.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(false));
            }
            return lastState;
        });
        list.add((modifiedPos, lastState, nbtState, rotation, level, directionOfGrowth) -> lastState.rotate(rotation));
        list.add((modifiedPos, lastState, nbtState, rotation, level, directionOfGrowth) -> {
            if (lastState.hasProperty((Property)BlockStateProperties.AXIS)) {
                Direction.Axis axis = (Direction.Axis)lastState.getValue((Property)BlockStateProperties.AXIS);
                Direction.Axis directionOfGrowthAxis = directionOfGrowth.getAxis();
                switch (directionOfGrowthAxis) {
                    case Y: {
                        break;
                    }
                    case X: {
                        if (axis == Direction.Axis.Y) {
                            lastState = (BlockState)lastState.setValue((Property)BlockStateProperties.AXIS, (Comparable)Direction.Axis.X);
                            break;
                        }
                        if (axis != Direction.Axis.X) break;
                        lastState = (BlockState)lastState.setValue((Property)BlockStateProperties.AXIS, (Comparable)Direction.Axis.Y);
                        break;
                    }
                    case Z: {
                        if (axis == Direction.Axis.Y) {
                            lastState = (BlockState)lastState.setValue((Property)BlockStateProperties.AXIS, (Comparable)Direction.Axis.Z);
                            break;
                        }
                        if (axis != Direction.Axis.Z) break;
                        lastState = (BlockState)lastState.setValue((Property)BlockStateProperties.AXIS, (Comparable)Direction.Axis.Y);
                    }
                }
            }
            return lastState;
        });
    });

    public TreeFromStructureNBTFeatureV2(Codec<TreeFromStructureNBTConfigV2> $$0) {
        super($$0);
    }

    public boolean place(FeaturePlaceContext<TreeFromStructureNBTConfigV2> featurePlaceContext) {
        TreeFromStructureNBTConfigV2 config = (TreeFromStructureNBTConfigV2)featurePlaceContext.config();
        BlockStateProvider logProvider = config.logProvider();
        List<BlockStateProvider> leavesProvider = config.leavesProvider();
        WorldGenLevel level = featurePlaceContext.level();
        StructureTemplateManager templateManager = level.getLevel().getStructureManager();
        ResourceLocation baseLocation = config.baseLocation();
        Optional baseTemplateOptional = templateManager.get(baseLocation);
        ResourceLocation canopyLocation = config.canopyLocation();
        Optional canopyTemplateOptional = templateManager.get(canopyLocation);
        if (baseTemplateOptional.isEmpty()) {
            throw TreeFromStructureNBTFeatureV2.noTreePartPresent(baseLocation);
        }
        if (canopyTemplateOptional.isEmpty()) {
            throw TreeFromStructureNBTFeatureV2.noTreePartPresent(canopyLocation);
        }
        StructureTemplate baseTemplate = (StructureTemplate)baseTemplateOptional.get();
        StructureTemplate canopyTemplate = (StructureTemplate)canopyTemplateOptional.get();
        List basePalettes = baseTemplate.palettes;
        List canopyPalettes = canopyTemplate.palettes;
        BlockPos origin = featurePlaceContext.origin();
        RandomSource random = featurePlaceContext.random();
        StructurePlaceSettings placeSettings = new StructurePlaceSettings().setRotation(Rotation.getRandom((RandomSource)random));
        StructureTemplate.Palette trunkBasePalette = placeSettings.getRandomPalette(basePalettes, origin);
        StructureTemplate.Palette randomCanopyPalette = placeSettings.getRandomPalette(canopyPalettes, origin);
        List center = trunkBasePalette.blocks(Blocks.WHITE_WOOL);
        if (center.isEmpty()) {
            throw new IllegalArgumentException("No trunk central position was specified for structure NBT palette %s. Trunk central position is specified with white wool.".formatted(config.baseLocation()));
        }
        if (center.size() > 1) {
            throw new IllegalArgumentException("There cannot be more than one trunk central position for structure NBT palette %s. Trunk central position is specified with white wool.".formatted(config.baseLocation()));
        }
        BlockPos centerOffset = ((StructureTemplate.StructureBlockInfo)center.getFirst()).pos();
        centerOffset = new BlockPos(-centerOffset.getX(), 0, -centerOffset.getZ());
        List<StructureTemplate.StructureBlockInfo> logs = TreeFromStructureNBTFeatureV2.getStructureInfosInStructurePalletteFromBlockList(config.logTarget(), trunkBasePalette);
        List logBuilders = trunkBasePalette.blocks(Blocks.RED_WOOL);
        if (logBuilders.isEmpty()) {
            throw new UnsupportedOperationException(String.format("\"%s\" is missing log builders.", baseLocation));
        }
        int trunkLength = config.height().sample(random);
        int maxTrunkBuildingDepth = config.maxLogDepth();
        Direction direction = TreeFromStructureNBTFeatureV2.findDirectionOfGrowthFromOrientation(config.orientation(), config, logBuilders, placeSettings, centerOffset, level, origin, random);
        if (direction == null) {
            return false;
        }
        HashMap<BlockPos, BlockState> leavePositions = new HashMap<BlockPos, BlockState>();
        HashMap<BlockPos, BlockState> logPositions = new HashMap<BlockPos, BlockState>();
        HashMap<BlockPos, BlockState> additionalPositions = new HashMap<BlockPos, BlockState>();
        TreeFromStructureNBTFeatureV2.fillTrunkPositions(logProvider, leavesProvider, config, level, random, origin, placeSettings, trunkBasePalette, centerOffset, logs, logBuilders, leavePositions, logPositions, additionalPositions, maxTrunkBuildingDepth, direction);
        if (!TreeFromStructureNBTFeatureV2.fillCanopyPositions(trunkBasePalette.blocks(Blocks.YELLOW_WOOL), config, level, random, placeSettings, centerOffset, origin, randomCanopyPalette, leavePositions, logPositions, additionalPositions, trunkLength, direction)) {
            return false;
        }
        if (config.isSapling() && TreeFromStructureNBTFeatureV2.validateLogPositions(logPositions, config, level)) {
            return false;
        }
        if (TreeFromStructureNBTFeatureV2.insideStructure(logPositions, level, config)) {
            return false;
        }
        TreeFromStructureNBTFeatureV2.placeKnownBlockPositions(logPositions, level);
        TreeFromStructureNBTFeatureV2.placeKnownLeavePositions(leavePositions, level);
        TreeFromStructureNBTFeatureV2.placeKnownBlockPositions(additionalPositions, level);
        HashSet<BlockPos> decorationPositions = new HashSet<BlockPos>();
        TreeFromStructureNBTFeatureV2.placeTreeDecorations(config.treeDecorators(), level, random, leavePositions.keySet(), logPositions.keySet(), decorationPositions);
        return true;
    }

    private static boolean doAllPositionsTouchGround(List<StructureTemplate.StructureBlockInfo> logBuilders, StructurePlaceSettings placeSettings, BlockPos centerOffset, BlockPos origin, TreeFromStructureNBTConfigV2 config, WorldGenLevel level, Direction direction) {
        for (StructureTemplate.StructureBlockInfo logBuilder : logBuilders) {
            BlockPos pos = TreeFromStructureNBTFeatureV2.getModifiedPos(placeSettings, logBuilder, centerOffset, origin);
            pos = TreeFromStructureNBTFeatureV2.rotateInDirectionAroundOrigin(pos, origin, direction);
            if (TreeFromStructureNBTFeatureV2.isOnGround(config.maxLogDepth(), level, pos, config.growableOn(), direction)) continue;
            return false;
        }
        return true;
    }

    @Nullable
    private static Direction findDirectionOfGrowthFromOrientation(TreeFromStructureNBTConfigV2.Orientation orientation, TreeFromStructureNBTConfigV2 config, List<StructureTemplate.StructureBlockInfo> logBuilders, StructurePlaceSettings placeSettings, BlockPos centerOffset, WorldGenLevel level, BlockPos origin, RandomSource random) {
        switch (orientation) {
            case STANDARD: {
                if (TreeFromStructureNBTFeatureV2.doAllPositionsTouchGround(logBuilders, placeSettings, centerOffset, origin, config, level, Direction.UP)) {
                    return Direction.UP;
                }
                return null;
            }
            case UPSIDE_DOWN: {
                if (TreeFromStructureNBTFeatureV2.doAllPositionsTouchGround(logBuilders, placeSettings, centerOffset, origin, config, level, Direction.DOWN)) {
                    return Direction.DOWN;
                }
                return null;
            }
            case SIDEWAYS: {
                List horizontalDirections = Direction.Plane.HORIZONTAL.shuffledCopy(random);
                ArrayList<Direction> validDirections = new ArrayList<Direction>(horizontalDirections.size());
                for (Direction direction : horizontalDirections) {
                    if (!TreeFromStructureNBTFeatureV2.doAllPositionsTouchGround(logBuilders, placeSettings, centerOffset, origin, config, level, direction)) continue;
                    validDirections.add(direction);
                }
                if (!validDirections.isEmpty()) {
                    return (Direction)validDirections.getFirst();
                }
                return null;
            }
        }
        throw new IllegalArgumentException("Unreachable statement, orientation %s is not supported.".formatted(new Object[]{orientation}));
    }

    private static boolean fillCanopyPositions(List<StructureTemplate.StructureBlockInfo> canopyAnchor, TreeFromStructureNBTConfigV2 config, WorldGenLevel level, RandomSource randomSource, StructurePlaceSettings placeSettings, BlockPos centerOffset, BlockPos origin, StructureTemplate.Palette randomCanopyPalette, Map<BlockPos, BlockState> leavePositions, Map<BlockPos, BlockState> logPositions, Map<BlockPos, BlockState> additionalPositions, int trunkLength, Direction treeGrowthDirection) {
        if (!canopyAnchor.isEmpty()) {
            if (canopyAnchor.size() > 1) {
                throw new IllegalArgumentException("There cannot be more than one central canopy position. Canopy central position is specified with yellow wool on the trunk palette.");
            }
            return TreeFromStructureNBTFeatureV2.fillCanopyPositions(config.logProvider(), config.leavesProvider(), config, level, randomSource, TreeFromStructureNBTFeatureV2.getModifiedPos(placeSettings, canopyAnchor.getFirst(), centerOffset, origin), placeSettings, randomCanopyPalette, leavePositions, logPositions, additionalPositions, trunkLength, treeGrowthDirection);
        }
        return TreeFromStructureNBTFeatureV2.fillCanopyPositions(config.logProvider(), config.leavesProvider(), config, level, randomSource, origin, placeSettings, randomCanopyPalette, leavePositions, logPositions, additionalPositions, trunkLength, treeGrowthDirection);
    }

    private static boolean insideStructure(Map<BlockPos, BlockState> logPositions, WorldGenLevel level, TreeFromStructureNBTConfigV2 config) {
        if (level instanceof WorldGenRegion) {
            WorldGenRegion region = (WorldGenRegion)level;
            for (BlockPos trunkPosition : logPositions.keySet()) {
                ChunkAccess chunk = level.getChunk(trunkPosition);
                for (StructureStart structureStart : chunk.getAllStarts().values()) {
                    for (StructurePiece piece : structureStart.getPieces()) {
                        if (!piece.getBoundingBox().isInside((Vec3i)trunkPosition) || TreeFromStructureNBTFeatureV2.testValidPos(config, level, trunkPosition)) continue;
                        return true;
                    }
                }
                for (Map.Entry entry : chunk.getAllReferences().entrySet()) {
                    Structure structure = (Structure)entry.getKey();
                    LongSet references = (LongSet)entry.getValue();
                    LongIterator longIterator = references.iterator();
                    while (longIterator.hasNext()) {
                        ChunkAccess referenceChunk;
                        StructureStart startForStructure;
                        int chunkZ;
                        long reference = (Long)longIterator.next();
                        int chunkX = ChunkPos.getX((long)reference);
                        if (!region.hasChunk(chunkX, chunkZ = ChunkPos.getZ((long)reference)) || (startForStructure = (referenceChunk = region.getChunk(chunkX, chunkZ, ChunkStatus.STRUCTURE_STARTS, true)).getStartForStructure(structure)) == null) continue;
                        for (StructurePiece piece : startForStructure.getPieces()) {
                            if (!piece.getBoundingBox().isInside((Vec3i)trunkPosition) || TreeFromStructureNBTFeatureV2.testValidPos(config, level, trunkPosition)) continue;
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }

    private static boolean validateLogPositions(Map<BlockPos, BlockState> logPositions, TreeFromStructureNBTConfigV2 config, WorldGenLevel level) {
        for (BlockPos trunkPosition : logPositions.keySet()) {
            if (TreeFromStructureNBTFeatureV2.testValidPos(config, level, trunkPosition)) continue;
            return true;
        }
        return false;
    }

    private static boolean testValidPos(TreeFromStructureNBTConfigV2 config, WorldGenLevel level, BlockPos trunkPosition) {
        return config.leavesPlacementFilter().test((Object)level, (Object)trunkPosition);
    }

    private static void placeKnownBlockPositions(Map<BlockPos, BlockState> trunkPositions, WorldGenLevel level) {
        for (Map.Entry<BlockPos, BlockState> entry : trunkPositions.entrySet()) {
            BlockPos trunkPosition = entry.getKey();
            BlockState state = entry.getValue();
            level.setBlock(trunkPosition, state, 2);
        }
    }

    private static void placeKnownLeavePositions(Map<BlockPos, BlockState> leavePositions, WorldGenLevel level) {
        ArrayList<Runnable> leavesPostApply = new ArrayList<Runnable>(leavePositions.size());
        for (Map.Entry<BlockPos, BlockState> entry : leavePositions.entrySet()) {
            BlockPos leavePosition = entry.getKey();
            BlockState state = entry.getValue();
            level.setBlock(leavePosition, state, 2);
            if (!state.hasProperty((Property)LeavesBlock.DISTANCE)) continue;
            Runnable postProcess = () -> {
                BlockState blockState = LeavesBlock.updateDistance((BlockState)state, (LevelAccessor)level, (BlockPos)leavePosition);
                if ((Integer)blockState.getValue((Property)LeavesBlock.DISTANCE) < 7) {
                    if (blockState.hasProperty((Property)LeavesBlock.PERSISTENT)) {
                        blockState = (BlockState)blockState.setValue((Property)LeavesBlock.PERSISTENT, (Comparable)Boolean.valueOf(false));
                    }
                    level.setBlock(leavePosition, blockState, 2);
                    level.scheduleTick(leavePosition, blockState.getBlock(), 0);
                } else {
                    level.removeBlock(leavePosition, false);
                    leavePositions.remove(leavePosition.immutable());
                }
            };
            leavesPostApply.add(postProcess);
        }
        leavesPostApply.forEach(Runnable::run);
    }

    public static void fillTrunkPositions(BlockStateProvider logProvider, List<BlockStateProvider> leavesProvider, TreeFromStructureNBTConfigV2 config, WorldGenLevel level, RandomSource randomSource, BlockPos origin, StructurePlaceSettings placeSettings, StructureTemplate.Palette trunkBasePalette, BlockPos centerOffset, List<StructureTemplate.StructureBlockInfo> logs, List<StructureTemplate.StructureBlockInfo> logBuilders, Map<BlockPos, BlockState> leavePositions, Map<BlockPos, BlockState> trunkPositions, Map<BlockPos, BlockState> additionalBlocks, int maxTrunkBuildingDepth, Direction treeGrowthDirection) {
        TreeFromStructureNBTFeatureV2.fillLogsUnder(logProvider, level, randomSource, origin, placeSettings, centerOffset, logBuilders, maxTrunkBuildingDepth, config.growableOn(), trunkPositions, treeGrowthDirection);
        TreeFromStructureNBTFeatureV2.placeLogsWithRotation(logProvider, level, randomSource, origin, placeSettings, centerOffset, logs, trunkPositions, treeGrowthDirection);
        TreeFromStructureNBTFeatureV2.placeLeavesWithCalculatedDistanceAndRotation(leavesProvider, level, origin, randomSource, placeSettings, TreeFromStructureNBTFeatureV2.getStructureInfosInStructurePalletteFromBlockListV2(config.leavesTarget(), trunkBasePalette), leavePositions, centerOffset, config.leavesPlacementFilter(), treeGrowthDirection);
        Map<Block, BlockStateProvider> replaceFromNBT = config.replaceFromNBT();
        replaceFromNBT.forEach((old, newBlock) -> {
            List<StructureTemplate.StructureBlockInfo> additionalBlocksInfo = TreeFromStructureNBTFeatureV2.getStructureInfosInStructurePalletteFromBlockList(List.of(old), trunkBasePalette);
            for (StructureTemplate.StructureBlockInfo additionalBlock : additionalBlocksInfo) {
                BlockPos pos = TreeFromStructureNBTFeatureV2.getModifiedPos(placeSettings, additionalBlock, centerOffset, origin);
                pos = TreeFromStructureNBTFeatureV2.rotateInDirectionAroundOrigin(pos, origin, treeGrowthDirection);
                additionalBlocks.put(pos.immutable(), TreeFromStructureNBTFeatureV2.getTransformedState(pos, newBlock.getState(randomSource, pos), additionalBlock.state(), placeSettings.getRotation(), level, treeGrowthDirection));
                ((RandomTickScheduler)level.getChunk(pos)).scheduleRandomTick(pos.immutable());
            }
        });
    }

    public static boolean fillCanopyPositions(BlockStateProvider logProvider, List<BlockStateProvider> leavesProvider, TreeFromStructureNBTConfigV2 config, WorldGenLevel level, RandomSource randomSource, BlockPos origin, StructurePlaceSettings placeSettings, StructureTemplate.Palette randomCanopyPalette, Map<BlockPos, BlockState> leavePositions, Map<BlockPos, BlockState> trunkPositions, Map<BlockPos, BlockState> additionalBlocks, int trunkLength, Direction treeGrowthDirection) {
        ArrayList<StructureTemplate.StructureBlockInfo> trunkFillers;
        List<List<StructureTemplate.StructureBlockInfo>> leaves = TreeFromStructureNBTFeatureV2.getStructureInfosInStructurePalletteFromBlockListV2(config.leavesTarget(), randomCanopyPalette);
        List<StructureTemplate.StructureBlockInfo> canopyLogs = TreeFromStructureNBTFeatureV2.getStructureInfosInStructurePalletteFromBlockList(config.logTarget(), randomCanopyPalette);
        List canopyAnchor = randomCanopyPalette.blocks(Blocks.WHITE_WOOL);
        if (canopyAnchor.isEmpty()) {
            throw new IllegalArgumentException("No canopy anchor was specified for structure NBT palette %s. Canopy anchor is specified with white wool.".formatted(config.canopyLocation()));
        }
        if (canopyAnchor.size() > 1) {
            throw new IllegalArgumentException("There cannot be more than one canopy anchor for structure NBT palette %s. Canopy anchor is specified with white wool.".formatted(config.canopyLocation()));
        }
        StructureTemplate.StructureBlockInfo structureBlockInfo = (StructureTemplate.StructureBlockInfo)canopyAnchor.getFirst();
        BlockPos canopyCenterOffset = structureBlockInfo.pos();
        if (!TreeFromStructureNBTFeatureV2.intersectTrunk(logProvider, level, randomSource, origin, placeSettings, canopyCenterOffset = new BlockPos(-canopyCenterOffset.getX(), trunkLength, -canopyCenterOffset.getZ()), trunkFillers = new ArrayList<StructureTemplate.StructureBlockInfo>(randomCanopyPalette.blocks(Blocks.RED_WOOL)), trunkLength + 1, trunkPositions, treeGrowthDirection)) {
            return false;
        }
        TreeFromStructureNBTFeatureV2.placeLogsWithRotation(logProvider, level, randomSource, origin, placeSettings, canopyCenterOffset, canopyLogs, trunkPositions, treeGrowthDirection);
        TreeFromStructureNBTFeatureV2.placeLeavesWithCalculatedDistanceAndRotation(leavesProvider, level, origin, randomSource, placeSettings, leaves, leavePositions, canopyCenterOffset, config.leavesPlacementFilter(), treeGrowthDirection);
        Map<Block, BlockStateProvider> replaceFromNBT = config.replaceFromNBT();
        BlockPos finalCanopyCenterOffset = canopyCenterOffset;
        replaceFromNBT.forEach((old, newBlock) -> {
            List<StructureTemplate.StructureBlockInfo> additionalBlocksInfo = TreeFromStructureNBTFeatureV2.getStructureInfosInStructurePalletteFromBlockList(List.of(old), randomCanopyPalette);
            for (StructureTemplate.StructureBlockInfo additionalBlock : additionalBlocksInfo) {
                BlockPos pos = TreeFromStructureNBTFeatureV2.getModifiedPos(placeSettings, additionalBlock, finalCanopyCenterOffset, origin);
                pos = TreeFromStructureNBTFeatureV2.rotateInDirectionAroundOrigin(pos, origin, treeGrowthDirection);
                additionalBlocks.put(pos.immutable(), TreeFromStructureNBTFeatureV2.getTransformedState(pos, newBlock.getState(randomSource, pos), additionalBlock.state(), placeSettings.getRotation(), level, treeGrowthDirection));
                ((RandomTickScheduler)level.getChunk(pos)).scheduleRandomTick(pos.immutable());
            }
        });
        return true;
    }

    public static void placeLogsWithRotation(BlockStateProvider logProvider, WorldGenLevel level, RandomSource random, BlockPos origin, StructurePlaceSettings placeSettings, BlockPos centerOffset, List<StructureTemplate.StructureBlockInfo> logs, Map<BlockPos, BlockState> trunkPositions, Direction treeGrowthDirection) {
        for (StructureTemplate.StructureBlockInfo trunk : logs) {
            BlockPos pos = TreeFromStructureNBTFeatureV2.getModifiedPos(placeSettings, trunk, centerOffset, origin);
            pos = TreeFromStructureNBTFeatureV2.rotateInDirectionAroundOrigin(pos, origin, treeGrowthDirection);
            trunkPositions.put(pos.immutable(), TreeFromStructureNBTFeatureV2.getTransformedState(pos, logProvider.getState(random, pos), trunk.state(), placeSettings.getRotation(), level, treeGrowthDirection));
        }
    }

    public static void placeTreeDecorations(Iterable<TreeDecorator> treeDecorators, WorldGenLevel level, RandomSource random, Set<BlockPos> leavePositions, Set<BlockPos> trunkPositions, Set<BlockPos> decorationPositions) {
        for (TreeDecorator treeDecorator : treeDecorators) {
            treeDecorator.place(new TreeDecorator.Context((LevelSimulatedReader)level, (pos, state) -> {
                level.setBlock(pos, state, 2);
                decorationPositions.add(pos.immutable());
            }, random, trunkPositions, leavePositions, trunkPositions));
        }
    }

    public static void placeLeavesWithCalculatedDistanceAndRotation(List<BlockStateProvider> leavesProvider, WorldGenLevel level, BlockPos origin, RandomSource random, StructurePlaceSettings placeSettings, List<List<StructureTemplate.StructureBlockInfo>> leaves, Map<BlockPos, BlockState> leavePositions, BlockPos canopyCenterOffset, BlockPredicate leavesPlacementFilter, Direction treeGrowthDirection) {
        for (int i = 0; i < leaves.size(); ++i) {
            List<StructureTemplate.StructureBlockInfo> meow = leaves.get(i);
            for (StructureTemplate.StructureBlockInfo leaf : meow) {
                BlockPos modifiedPos = TreeFromStructureNBTFeatureV2.getModifiedPos(placeSettings, leaf, canopyCenterOffset, origin);
                if (!leavesPlacementFilter.test((Object)level, (Object)(modifiedPos = TreeFromStructureNBTFeatureV2.rotateInDirectionAroundOrigin(modifiedPos, origin, treeGrowthDirection)))) continue;
                leavePositions.put(modifiedPos.immutable(), TreeFromStructureNBTFeatureV2.getTransformedState(modifiedPos, leavesProvider.get(i).getState(random, modifiedPos), leaf.state(), placeSettings.getRotation(), level, treeGrowthDirection));
            }
        }
    }

    public static void fillLogsUnder(BlockStateProvider logProvider, WorldGenLevel level, RandomSource random, BlockPos origin, StructurePlaceSettings placeSettings, BlockPos centerOffset, List<StructureTemplate.StructureBlockInfo> logBuilders, int maxTrunkBuildingDepth, BlockPredicate groundFilter, Map<BlockPos, BlockState> trunkPositions, Direction treeGrowthDirection) {
        block0: for (StructureTemplate.StructureBlockInfo logBuilder : logBuilders) {
            BlockPos pos = TreeFromStructureNBTFeatureV2.getModifiedPos(placeSettings, logBuilder, centerOffset, origin);
            pos = TreeFromStructureNBTFeatureV2.rotateInDirectionAroundOrigin(pos, origin, treeGrowthDirection);
            BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos().set((Vec3i)pos);
            for (int i = 0; i < maxTrunkBuildingDepth; ++i) {
                if (groundFilter.test((Object)level, (Object)mutableBlockPos) || level.getBlockState((BlockPos)mutableBlockPos).is(Blocks.BEDROCK)) {
                    ((RandomTickScheduler)level.getChunk((BlockPos)mutableBlockPos)).scheduleRandomTick(mutableBlockPos.immutable());
                    continue block0;
                }
                trunkPositions.put(mutableBlockPos.immutable(), TreeFromStructureNBTFeatureV2.getTransformedState((BlockPos)mutableBlockPos, logProvider.getState(random, (BlockPos)mutableBlockPos), logBuilder.state(), placeSettings.getRotation(), level, treeGrowthDirection));
                mutableBlockPos.move(treeGrowthDirection.getOpposite());
            }
        }
    }

    public static boolean intersectTrunk(BlockStateProvider logProvider, WorldGenLevel level, RandomSource random, BlockPos origin, StructurePlaceSettings placeSettings, BlockPos centerOffset, List<StructureTemplate.StructureBlockInfo> logBuilders, int maxTrunkBuildingDepth, Map<BlockPos, BlockState> trunkPositions, Direction treeGrowthDirection) {
        for (StructureTemplate.StructureBlockInfo logBuilder : logBuilders) {
            BlockPos pos = TreeFromStructureNBTFeatureV2.getModifiedPos(placeSettings, logBuilder, centerOffset, origin);
            pos = TreeFromStructureNBTFeatureV2.rotateInDirectionAroundOrigin(pos, origin, treeGrowthDirection);
            BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos().set((Vec3i)pos);
            for (int i = 0; i <= maxTrunkBuildingDepth && !trunkPositions.containsKey(mutableBlockPos); ++i) {
                trunkPositions.put(mutableBlockPos.immutable(), TreeFromStructureNBTFeatureV2.getTransformedState((BlockPos)mutableBlockPos, logProvider.getState(random, (BlockPos)mutableBlockPos), logBuilder.state(), placeSettings.getRotation(), level, treeGrowthDirection));
                mutableBlockPos.move(treeGrowthDirection.getOpposite());
                if (i != maxTrunkBuildingDepth) continue;
                return false;
            }
        }
        return true;
    }

    @NotNull
    public static BlockState getTransformedState(BlockPos modifiedPos, BlockState state, BlockState nbtState, Rotation rotation, WorldGenLevel level, Direction directionOfGrowth) {
        for (BlockStateModifier modifier : BLOCK_STATE_MODIFIERS) {
            state = modifier.apply(modifiedPos, state, nbtState, rotation, level, directionOfGrowth);
        }
        return state;
    }

    public static boolean isOnGround(int maxLogDepth, WorldGenLevel level, BlockPos pos, BlockPredicate growableOn, Direction treeGrowthDirection) {
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos().set((Vec3i)pos);
        for (int logDepth = 0; logDepth < maxLogDepth; ++logDepth) {
            mutableBlockPos.move(treeGrowthDirection.getOpposite());
            if (!growableOn.test((Object)level, (Object)mutableBlockPos)) continue;
            return true;
        }
        return false;
    }

    public static BlockPos getModifiedPos(StructurePlaceSettings settings, StructureTemplate.StructureBlockInfo placing, BlockPos partCenter, BlockPos featureOrigin) {
        return StructureTemplate.calculateRelativePosition((StructurePlaceSettings)settings, (BlockPos)placing.pos()).offset((Vec3i)featureOrigin).offset((Vec3i)StructureTemplate.calculateRelativePosition((StructurePlaceSettings)settings, (BlockPos)partCenter));
    }

    public static BlockPos rotateInDirectionAroundOrigin(BlockPos pos, BlockPos origin, Direction direction) {
        BlockPos offset = pos.subtract((Vec3i)origin);
        return switch (direction) {
            default -> throw new MatchException(null, null);
            case Direction.UP -> pos;
            case Direction.DOWN -> new BlockPos(origin.getX() + offset.getX(), origin.getY() - offset.getY(), origin.getZ() + offset.getZ());
            case Direction.EAST -> new BlockPos(origin.getX() + offset.getY(), origin.getY() - offset.getX(), origin.getZ() + offset.getZ());
            case Direction.WEST -> new BlockPos(origin.getX() - offset.getY(), origin.getY() + offset.getX(), origin.getZ() + offset.getZ());
            case Direction.NORTH -> new BlockPos(origin.getX() + offset.getX(), origin.getY() - offset.getZ(), origin.getZ() - offset.getY());
            case Direction.SOUTH -> new BlockPos(origin.getX() + offset.getX(), origin.getY() + offset.getZ(), origin.getZ() + offset.getY());
        };
    }

    public static IllegalArgumentException noTreePartPresent(ResourceLocation location) {
        return new IllegalArgumentException(String.format("\"%s\" is not a valid tree part.", location));
    }

    public static List<StructureTemplate.StructureBlockInfo> getStructureInfosInStructurePalletteFromBlockList(Iterable<Block> blocks, StructureTemplate.Palette palette) {
        ArrayList<StructureTemplate.StructureBlockInfo> result = new ArrayList<StructureTemplate.StructureBlockInfo>();
        for (Block block : blocks) {
            result.addAll(palette.blocks(block));
        }
        return result;
    }

    public static List<List<StructureTemplate.StructureBlockInfo>> getStructureInfosInStructurePalletteFromBlockListV2(Iterable<Block> blocks, StructureTemplate.Palette palette) {
        ArrayList<List<StructureTemplate.StructureBlockInfo>> result = new ArrayList<List<StructureTemplate.StructureBlockInfo>>();
        for (Block block : blocks) {
            result.add(palette.blocks(block));
        }
        return result;
    }

    @FunctionalInterface
    public static interface BlockStateModifier {
        public BlockState apply(BlockPos var1, BlockState var2, BlockState var3, Rotation var4, WorldGenLevel var5, Direction var6);
    }
}

