/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.jarhandling;

import cpw.mods.jarhandling.JarContents;
import cpw.mods.jarhandling.JarContentsBuilder;
import cpw.mods.jarhandling.JarMetadata;
import cpw.mods.jarhandling.impl.Jar;
import cpw.mods.jarhandling.impl.JarContentsImpl;
import cpw.mods.niofs.union.UnionPathFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.lang.module.ModuleDescriptor;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.CodeSigner;
import java.util.List;
import java.util.Optional;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.jetbrains.annotations.Nullable;

public interface SecureJar {
    public static SecureJar from(Path ... paths) {
        return SecureJar.from(new JarContentsBuilder().paths(paths).build());
    }

    public static SecureJar from(JarContents contents) {
        return SecureJar.from(contents, JarMetadata.from(contents));
    }

    public static SecureJar from(JarContents contents, JarMetadata metadata) {
        return new Jar((JarContentsImpl)contents, metadata);
    }

    public ModuleDataProvider moduleDataProvider();

    public Path getPrimaryPath();

    @Nullable
    public CodeSigner[] getManifestSigners();

    public Status verifyPath(Path var1);

    public Status getFileStatus(String var1);

    @Nullable
    public Attributes getTrustedManifestEntries(String var1);

    public boolean hasSecurityData();

    public String name();

    public Path getPath(String var1, String ... var2);

    public Path getRootPath();

    public void close() throws IOException;

    public static enum Status {
        NONE,
        INVALID,
        UNVERIFIED,
        VERIFIED;

    }

    public record Provider(String serviceName, List<String> providers) {
        public static Provider fromPath(Path path, UnionPathFilter pkgFilter) {
            String sname = path.getFileName().toString();
            try {
                List<String> entries = Files.readAllLines(path).stream().map(String::trim).filter(l -> !l.isEmpty() && !l.startsWith("#")).filter(p -> pkgFilter == null || pkgFilter.test(p.replace('.', '/'), path.getRoot())).toList();
                return new Provider(sname, entries);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    public static interface ModuleDataProvider {
        public String name();

        public ModuleDescriptor descriptor();

        @Nullable
        public URI uri();

        public Optional<URI> findFile(String var1);

        public Optional<InputStream> open(String var1);

        public Manifest getManifest();

        @Nullable
        public CodeSigner[] verifyAndGetSigners(String var1, byte[] var2);
    }
}

