/*
 * Decompiled with CFR 0.152.
 */
package dev.cammiescorner.icarus.util;

import dev.cammiescorner.icarus.api.IcarusPlayerValues;
import dev.cammiescorner.icarus.api.SlowFallingEntity;
import dev.cammiescorner.icarus.client.IcarusClient;
import dev.cammiescorner.icarus.init.IcarusDimensionTypeTags;
import dev.cammiescorner.icarus.init.IcarusItemTags;
import dev.cammiescorner.icarus.init.IcarusStatusEffects;
import dev.cammiescorner.icarus.item.WingItem;
import dev.cammiescorner.icarus.network.s2c.SyncConfigValuesPacket;
import dev.cammiescorner.icarus.util.ServerPlayerFallbackValues;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class IcarusHelper {
    @ApiStatus.Internal
    public static Predicate<LivingEntity> hasWings = entity -> false;
    @ApiStatus.Internal
    public static Function<LivingEntity, ItemStack> getEquippedWings = entity -> ItemStack.EMPTY;
    @ApiStatus.Internal
    public static BiPredicate<LivingEntity, ItemStack> equipFunc = (entity, stack) -> false;
    @ApiStatus.Internal
    public static IcarusPlayerValues fallbackValues = new ServerPlayerFallbackValues();

    public static boolean onFallFlyingTick(LivingEntity entity, @Nullable ItemStack wings, boolean tick) {
        Player player;
        WingItem wingItem;
        Item message2;
        IcarusPlayerValues cfg = IcarusHelper.getConfigValues(entity);
        Level level = entity.level();
        if (!level.isClientSide() && (level.dimensionTypeRegistration().is(IcarusDimensionTypeTags.NO_FLYING_ALLOWED) || level.registryAccess().registryOrThrow(Registries.LEVEL_STEM).getHolder(Registries.levelToLevelStem((ResourceKey)level.dimension())).map(stemHolder -> stemHolder.is(cfg.noFlyingAllowedInLevels())).orElse(false).booleanValue())) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)entity;
                IcarusHelper.stopFlying((Player)player2);
                player2.sendSystemMessage((Component)Component.translatable((String)"message.icarus.status.no_fly.dimension").withStyle(ChatFormatting.RED), true);
            }
            return false;
        }
        if (entity.hasEffect(IcarusStatusEffects.flightlessHolder())) {
            if (entity instanceof Player) {
                Player player3 = (Player)entity;
                IcarusHelper.stopFlying(player3);
                MutableComponent message2 = Component.translatable((String)"message.icarus.status.no_fly.status_effect").withStyle(ChatFormatting.BLUE);
                if (entity instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)entity;
                    serverPlayer.sendSystemMessage((Component)message2, true);
                } else {
                    IcarusClient.sendActionbarMessage(player3, (Component)message2);
                }
            }
            return false;
        }
        if (!(wings == null || (message2 = wings.getItem()) instanceof WingItem && (wingItem = (WingItem)message2).isUsable(entity, wings))) {
            if (entity instanceof Player) {
                player = (Player)entity;
                IcarusHelper.stopFlying(player);
            }
            return false;
        }
        if (tick) {
            Player player4;
            if (cfg.canSlowFall() && entity.isShiftKeyDown() || entity.isUnderWater()) {
                if (entity instanceof Player) {
                    player4 = (Player)entity;
                    IcarusHelper.stopFlying(player4);
                }
                return false;
            }
            if (!(wings != null && wings.is(IcarusItemTags.FREE_FLIGHT) || !(entity instanceof Player) || (player4 = (Player)entity).isCreative())) {
                player4.getFoodData().addExhaustion(cfg.exhaustionAmount());
                if ((float)player4.getFoodData().getFoodLevel() < cfg.requiredFoodAmount()) {
                    IcarusHelper.stopFlying(player4);
                    message2 = Component.translatable((String)"message.icarus.status.no_fly.hunger").withStyle(ChatFormatting.BLUE);
                    if (entity instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)entity;
                        serverPlayer.sendSystemMessage((Component)message2, true);
                    } else {
                        IcarusClient.sendActionbarMessage(player4, (Component)message2);
                    }
                    return false;
                }
            }
            if (wings != null && (message2 = wings.getItem()) instanceof WingItem && !(wingItem = (WingItem)message2).onFlightTick(entity, wings, entity.getFallFlyingTicks() + 1)) {
                if (entity instanceof Player) {
                    player = (Player)entity;
                    IcarusHelper.stopFlying(player);
                }
                return false;
            }
        }
        return true;
    }

    public static boolean hasWings(LivingEntity entity) {
        return hasWings.test(entity);
    }

    @Nullable
    public static ItemStack getEquippedWings(LivingEntity entity) {
        return getEquippedWings.apply(entity);
    }

    public static IcarusPlayerValues getConfigValues(LivingEntity entity) {
        return fallbackValues;
    }

    public static void onPlayerTick(Player player) {
        if (((SlowFallingEntity)player).icarus$isSlowFalling()) {
            player.fallDistance = 0.0f;
            if (player.onGround() || player.isInWater()) {
                ((SlowFallingEntity)player).icarus$setSlowFalling(false);
            } else {
                Vec3 move = player.getDeltaMovement();
                player.setDeltaMovement(move.x(), -0.4, move.z());
            }
        }
    }

    public static void stopFlying(Player player) {
        ((SlowFallingEntity)player).icarus$setSlowFalling(true);
        if (player.getXRot() < -90.0f || player.getXRot() > 90.0f) {
            float offset = (player.getXRot() < -90.0f ? player.getXRot() + 180.0f : player.getXRot() - 180.0f) * 2.0f;
            player.setXRot((player.getXRot() < -90.0f ? 180.0f + offset : -180.0f - offset) + player.getXRot());
            player.setYRot(180.0f + player.getYRot());
        }
    }

    public static void onServerPlayerJoin(ServerPlayer player) {
        SyncConfigValuesPacket.send(player);
    }
}

