/*
 * Decompiled with CFR 0.152.
 */
package dev.cammiescorner.icarus.neoforge.compat;

import dev.cammiescorner.icarus.IcarusConfig;
import io.github.avacadowizard120.cameraoverhaulneoforge.core.callbacks.CameraUpdateCallback;
import io.github.avacadowizard120.cameraoverhaulneoforge.core.callbacks.ModifyCameraTransformCallback;
import io.github.avacadowizard120.cameraoverhaulneoforge.core.structures.Transform;
import net.minecraft.client.Camera;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;

public class CameraOverhaulCompat
implements CameraUpdateCallback,
ModifyCameraTransformCallback {
    private double prevRollOffset;
    private Transform storedTransform;

    public static void load() {
        CameraUpdateCallback.EVENT.Register((Object)new CameraOverhaulCompat());
    }

    public void OnCameraUpdate(Entity focusedEntrity, Camera camera, Transform cameraTransform, float deltaTime) {
        float pitch = camera.getXRot();
        float rollAmount = pitch < -90.0f || pitch > 90.0f ? IcarusConfig.rollAmount : -IcarusConfig.rollAmount;
        Vec3 velocity = camera.getEntity().getDeltaMovement();
        Vec2 relativeXZVelocity = CameraOverhaulCompat.rotate(new Vec2((float)velocity.x, (float)velocity.z), 360.0f - (float)cameraTransform.eulerRot.y);
        this.rollOffset(cameraTransform, relativeXZVelocity, deltaTime, rollAmount);
        this.storedTransform = cameraTransform;
    }

    public static Vec2 rotate(Vec2 vec, float degrees) {
        double radians = Math.toRadians(degrees);
        float sin = (float)Math.sin(radians);
        float cos = (float)Math.cos(radians);
        return new Vec2(cos * vec.x - sin * vec.y, sin * vec.x + cos * vec.y);
    }

    private void rollOffset(Transform transform, Vec2 relativeXZVelocity, double deltaTime, float intensity) {
        double strafingRollOffset = (double)(-relativeXZVelocity.x) * 15.0;
        double lerpSpeed = 1.0;
        this.prevRollOffset = strafingRollOffset = Mth.lerp((double)Mth.clamp((double)(deltaTime * lerpSpeed), (double)0.0, (double)1.0), (double)this.prevRollOffset, (double)strafingRollOffset);
        transform.eulerRot = transform.eulerRot.add(0.0, 0.0, strafingRollOffset * (double)intensity);
    }

    public Transform ModifyCameraTransform(Camera camera, Transform transform) {
        return this.storedTransform != null ? this.storedTransform : transform;
    }
}

