/*
 * Decompiled with CFR 0.152.
 */
package dev.cammiescorner.icarus.neoforge;

import com.illusivesoulworks.caelus.api.CaelusApi;
import dev.cammiescorner.icarus.Icarus;
import dev.cammiescorner.icarus.client.IcarusClient;
import dev.cammiescorner.icarus.util.IcarusHelper;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;

@EventBusSubscriber(modid="icarus")
public class EventHandler {
    public static final ResourceLocation WINGS_FLIGHT_MODIFIER_ID = Icarus.id("wings");
    public static final AttributeModifier WINGS_FLIGHT = new AttributeModifier(WINGS_FLIGHT_MODIFIER_ID, 1.0, AttributeModifier.Operation.ADD_VALUE);

    @SubscribeEvent
    public static void onPlayerTick(PlayerTickEvent.Pre event) {
        AttributeInstance attributeInstance = event.getEntity().getAttribute(CaelusApi.getInstance().getFallFlyingAttribute());
        if (attributeInstance != null) {
            if (attributeInstance.hasModifier(WINGS_FLIGHT.id())) {
                if (event.getEntity().isFallFlying()) {
                    if (!IcarusHelper.onFallFlyingTick((LivingEntity)event.getEntity(), IcarusHelper.getEquippedWings((LivingEntity)event.getEntity()), true)) {
                        attributeInstance.removeModifier(WINGS_FLIGHT_MODIFIER_ID);
                    }
                } else if (!IcarusHelper.hasWings((LivingEntity)event.getEntity())) {
                    attributeInstance.removeModifier(WINGS_FLIGHT_MODIFIER_ID);
                }
            } else if (IcarusHelper.hasWings((LivingEntity)event.getEntity())) {
                attributeInstance.addTransientModifier(WINGS_FLIGHT);
            }
        }
        if (event.getEntity().level().isClientSide()) {
            IcarusClient.onPlayerTick(event.getEntity());
        } else {
            IcarusHelper.onPlayerTick(event.getEntity());
        }
    }

    @SubscribeEvent
    public static void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        IcarusHelper.onServerPlayerJoin((ServerPlayer)event.getEntity());
    }

    @SubscribeEvent
    public static void onServerStart(ServerStartingEvent event) {
        Icarus.onServerStart(event.getServer());
    }
}

