/*
 * Decompiled with CFR 0.152.
 */
package dev.cammiescorner.icarus.client.renderers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.cammiescorner.icarus.api.client.IcarusAPIClient;
import dev.cammiescorner.icarus.client.IcarusClient;
import dev.cammiescorner.icarus.client.IcarusModels;
import dev.cammiescorner.icarus.client.models.DiscordsWingsModel;
import dev.cammiescorner.icarus.client.models.FeatheredWingsModel;
import dev.cammiescorner.icarus.client.models.FlandresWingsModel;
import dev.cammiescorner.icarus.client.models.LeatherWingsModel;
import dev.cammiescorner.icarus.client.models.LightWingsModel;
import dev.cammiescorner.icarus.client.models.WingEntityModel;
import dev.cammiescorner.icarus.client.models.ZanzasWingsModel;
import dev.cammiescorner.icarus.init.IcarusItems;
import dev.cammiescorner.icarus.item.WingItem;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class WingsLayer<T extends LivingEntity, M extends EntityModel<T>>
extends RenderLayer<T, M> {
    private final FeatheredWingsModel<T> featheredWings;
    private final LeatherWingsModel<T> leatherWings;
    private final LightWingsModel<T> lightWings;
    private final FlandresWingsModel<T> flandresWings;
    private final DiscordsWingsModel<T> discordsWings;
    private final ZanzasWingsModel<T> zanzasWings;

    public WingsLayer(RenderLayerParent<T, M> context, EntityModelSet loader) {
        super(context);
        this.featheredWings = new FeatheredWingsModel(loader.bakeLayer(IcarusModels.FEATHERED));
        this.leatherWings = new LeatherWingsModel(loader.bakeLayer(IcarusModels.LEATHER));
        this.lightWings = new LightWingsModel(loader.bakeLayer(IcarusModels.LIGHT));
        this.flandresWings = new FlandresWingsModel(loader.bakeLayer(IcarusModels.FLANDRE));
        this.discordsWings = new DiscordsWingsModel(loader.bakeLayer(IcarusModels.DISCORD));
        this.zanzasWings = new ZanzasWingsModel(loader.bakeLayer(IcarusModels.ZANZA));
    }

    public void render(PoseStack pose, MultiBufferSource bufferSource, int light, T entity, float limbAngle, float limbDistance, float tickDelta, float animationProgress, float headYaw, float headPitch) {
        ItemStack stack = IcarusAPIClient.getWingsForRendering(entity);
        Item item = stack.getItem();
        if (item instanceof WingItem) {
            WingItem wingItem = (WingItem)item;
            if (IcarusClient.shouldRenderWings(entity)) {
                WingEntityModel wingModel;
                int primaryColor = FastColor.ARGB32.color((int)255, (int)wingItem.getPrimaryColor(stack).getTextureDiffuseColor());
                int secondaryColor = FastColor.ARGB32.color((int)255, (int)wingItem.getSecondaryColor(stack).getTextureDiffuseColor());
                switch (wingItem.getWingType()) {
                    case FEATHERED: 
                    case MECHANICAL_FEATHERED: {
                        WingEntityModel wingEntityModel = this.featheredWings;
                        break;
                    }
                    case DRAGON: 
                    case MECHANICAL_LEATHER: {
                        WingEntityModel wingEntityModel = this.leatherWings;
                        break;
                    }
                    case LIGHT: {
                        WingEntityModel wingEntityModel = this.lightWings;
                        break;
                    }
                    case UNIQUE: {
                        WingEntityModel wingEntityModel;
                        if (stack.is((Item)IcarusItems.FLANDRES_WINGS.get())) {
                            wingEntityModel = this.flandresWings;
                            break;
                        }
                        if (stack.is((Item)IcarusItems.DISCORDS_WINGS.get())) {
                            wingEntityModel = this.discordsWings;
                            break;
                        }
                        if (stack.is((Item)IcarusItems.ZANZAS_WINGS.get())) {
                            wingEntityModel = this.zanzasWings;
                            break;
                        }
                        wingEntityModel = null;
                        break;
                    }
                    default: {
                        WingEntityModel wingEntityModel = wingModel = null;
                    }
                }
                if (wingModel == null) {
                    return;
                }
                ResourceLocation layer1 = wingItem.getWingType().getTextureLayer1(stack);
                ResourceLocation layer2 = wingItem.getWingType().getTextureLayer2(stack);
                pose.pushPose();
                pose.translate(0.0, 0.0, 0.125);
                this.getParentModel().copyPropertiesTo(wingModel);
                wingModel.setupAnim(entity, limbAngle, limbDistance, animationProgress, headYaw, headPitch);
                this.renderWings(wingModel, pose, bufferSource, stack, RenderType.entityTranslucent((ResourceLocation)layer2), light, secondaryColor);
                this.renderWings(wingModel, pose, bufferSource, stack, RenderType.entityTranslucent((ResourceLocation)layer1), light, primaryColor);
                pose.popPose();
            }
        }
    }

    public void renderWings(WingEntityModel<T> model, PoseStack matrices, MultiBufferSource vertexConsumers, @Nullable ItemStack stack, RenderType renderLayer, int light, int color) {
        VertexConsumer vertexConsumer = ItemRenderer.getArmorFoilBuffer((MultiBufferSource)vertexConsumers, (RenderType)renderLayer, (stack != null && stack.hasFoil() ? 1 : 0) != 0);
        model.renderToBuffer(matrices, vertexConsumer, light, OverlayTexture.NO_OVERLAY, color);
    }
}

