/*
 * Decompiled with CFR 0.152.
 */
package dev.cammiescorner.icarus.client.models;

import com.google.common.collect.ImmutableList;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;

public class WingEntityModel<T extends LivingEntity>
extends AgeableListModel<T> {
    public final ModelPart rightWing;
    public final ModelPart leftWing;
    public State state = State.IDLE;

    public WingEntityModel(ModelPart root) {
        this.rightWing = root.getChild("rightWing");
        this.leftWing = root.getChild("leftWing");
    }

    public static MeshDefinition getModelData() {
        MeshDefinition modelData = new MeshDefinition();
        PartDefinition modelPartData = modelData.getRoot();
        modelPartData.addOrReplaceChild("rightWing", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)5.0f, (float)0.0f));
        modelPartData.addOrReplaceChild("leftWing", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)5.0f, (float)0.0f));
        return modelData;
    }

    public void setupAnim(T entity, float limbAngle, float limbDistance, float animationProgress, float headYaw, float headPitch) {
        this.state = State.IDLE;
        float a = 0.125f;
        float b = 0.1f;
        float k = 0.4f;
        float l = -0.5f;
        float m = -1.0f;
        float n = 0.0f;
        if (entity.isFallFlying()) {
            this.state = State.FLYING;
            float o = 1.0f;
            Vec3 vec3d = entity.getDeltaMovement();
            if (vec3d.y < 0.0) {
                Vec3 vec3d2 = vec3d.normalize();
                o = 1.0f - (float)Math.pow(-vec3d2.y, 1.5);
            }
            k = o * 0.35f + (1.0f - o) * k;
            l = o * -1.6f + (0.3f - o) * l;
            if (((LivingEntity)entity).zza > 0.0f) {
                a = 0.4f;
                b = 1.0f;
            }
        } else if (entity.isCrouching()) {
            this.state = State.CROUCHING;
            k = 0.7f;
            m = 0.0f;
            n = 0.09f;
        }
        k += Mth.sin((float)((float)((LivingEntity)entity).tickCount * a)) * b;
        this.leftWing.x = 7.0f;
        this.leftWing.y = m;
        if (entity instanceof AbstractClientPlayer) {
            AbstractClientPlayer player = (AbstractClientPlayer)entity;
            player.elytraRotX += (k - player.elytraRotX) * 0.1f;
            player.elytraRotY += (n - player.elytraRotY) * 0.1f;
            player.elytraRotZ += (l - player.elytraRotZ) * 0.1f;
            this.leftWing.xRot = player.elytraRotX;
            this.leftWing.yRot = player.elytraRotY;
            this.leftWing.zRot = player.elytraRotZ;
        } else {
            this.leftWing.xRot = k;
            this.leftWing.zRot = l;
            this.leftWing.yRot = n;
        }
        this.rightWing.x = -this.leftWing.x;
        this.rightWing.yRot = -this.leftWing.yRot;
        this.rightWing.y = this.leftWing.y;
        this.rightWing.xRot = this.leftWing.xRot;
        this.rightWing.zRot = -this.leftWing.zRot;
    }

    protected Iterable<ModelPart> headParts() {
        return ImmutableList.of();
    }

    protected Iterable<ModelPart> bodyParts() {
        return ImmutableList.of((Object)this.rightWing, (Object)this.leftWing);
    }

    public static enum State {
        IDLE,
        CROUCHING,
        FLYING;

    }
}

