/*
 * Decompiled with CFR 0.152.
 */
package dev.cammiescorner.icarus.client;

import com.google.common.base.MoreObjects;
import dev.cammiescorner.icarus.api.IcarusPlayerValues;
import dev.cammiescorner.icarus.init.IcarusItemTags;
import dev.cammiescorner.icarus.util.IcarusHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.ApiStatus;

public class IcarusClient {
    private static final List<Predicate<LivingEntity>> renderPredicates = new ArrayList<Predicate<LivingEntity>>();

    public static void onPlayerTick(Player player) {
        if (player.isFallFlying() && IcarusHelper.hasWings((LivingEntity)player) && player.zza > 0.0f) {
            ItemStack wings;
            IcarusPlayerValues cfg = IcarusHelper.getConfigValues((LivingEntity)player);
            Vec3 rotation = player.getLookAngle();
            Vec3 velocity = player.getDeltaMovement();
            float modifier = 1.0f;
            if (cfg.armorSlows() && (wings = IcarusHelper.getEquippedWings.apply((LivingEntity)player)) != null && !wings.isEmpty() && !wings.is(IcarusItemTags.BYPASSES_ARMOR_SLOWDOWN)) {
                modifier = Math.max(1.0f, (float)player.getArmorValue() / 30.0f * cfg.maxSlowedMultiplier());
            }
            float speed = cfg.wingsSpeed() * (player.getXRot() < -75.0f && player.getXRot() > -105.0f ? 2.75f : 1.0f) / modifier;
            player.setDeltaMovement(velocity.add(rotation.x * (double)speed + (rotation.x * 1.5 - velocity.x) * (double)speed, rotation.y * (double)speed + (rotation.y * 1.5 - velocity.y) * (double)speed, rotation.z * (double)speed + (rotation.z * 1.5 - velocity.z) * (double)speed));
        }
    }

    @ApiStatus.Internal
    public static ItemStack getWingsForRendering(LivingEntity entity) {
        return (ItemStack)MoreObjects.firstNonNull((Object)IcarusHelper.getEquippedWings.apply(entity), (Object)ItemStack.EMPTY);
    }

    @ApiStatus.Internal
    public static void addRenderPredicate(Predicate<LivingEntity> predicate) {
        renderPredicates.add(predicate);
    }

    public static boolean shouldRenderWings(LivingEntity entity) {
        if (!renderPredicates.isEmpty()) {
            for (Predicate<LivingEntity> predicate : renderPredicates) {
                if (predicate.test(entity)) continue;
                return false;
            }
        }
        return true;
    }

    public static void sendActionbarMessage(Player player, Component message) {
        if (player instanceof LocalPlayer) {
            LocalPlayer localPlayer = (LocalPlayer)player;
            localPlayer.displayClientMessage(message, true);
        }
    }
}

