/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.wildernature.core.registry;

import dev.architectury.core.item.ArchitecturySpawnEggItem;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.Registrar;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.food.Foods;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.ArmorMaterials;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemNameBlockItem;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.satisfy.wildernature.WilderNature;
import net.satisfy.wildernature.core.block.BisonTrophyBlock;
import net.satisfy.wildernature.core.block.BountyBoardBlock;
import net.satisfy.wildernature.core.block.CompletionistBannerBlock;
import net.satisfy.wildernature.core.block.CompletionistWallBannerBlock;
import net.satisfy.wildernature.core.block.DeerTrophyBlock;
import net.satisfy.wildernature.core.block.HazelnutBushBlock;
import net.satisfy.wildernature.core.block.RedWolfTrophyBlock;
import net.satisfy.wildernature.core.block.TermiteBlock;
import net.satisfy.wildernature.core.item.AmmunitionItem;
import net.satisfy.wildernature.core.item.BisonHornItem;
import net.satisfy.wildernature.core.item.BlunderBussItem;
import net.satisfy.wildernature.core.item.FlintAmmunitionItem;
import net.satisfy.wildernature.core.item.FurCloakItem;
import net.satisfy.wildernature.core.item.LootBagItem;
import net.satisfy.wildernature.core.item.StylinPurpleHatItem;
import net.satisfy.wildernature.core.registry.ArmorMaterialRegistry;
import net.satisfy.wildernature.core.registry.EntityTypeRegistry;
import net.satisfy.wildernature.core.registry.SoundRegistry;
import net.satisfy.wildernature.core.util.WilderNatureUtil;

public class ObjectRegistry {
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((String)"wildernature", (ResourceKey)Registries.ITEM);
    public static final Registrar<Item> ITEM_REGISTRAR = ITEMS.getRegistrar();
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((String)"wildernature", (ResourceKey)Registries.BLOCK);
    public static final Registrar<Block> BLOCK_REGISTRAR = BLOCKS.getRegistrar();
    public static final RegistrySupplier<Item> BISON_MEAT = ObjectRegistry.registerItem("bison_meat", () -> new Item(ObjectRegistry.getSettings().food(Foods.BEEF)));
    public static final RegistrySupplier<Item> COOKED_BISON_MEAT = ObjectRegistry.registerItem("cooked_bison_meat", () -> new Item(ObjectRegistry.getSettings().food(Foods.COOKED_BEEF)));
    public static final RegistrySupplier<Item> VENISON = ObjectRegistry.registerItem("venison", () -> new Item(ObjectRegistry.getSettings().food(Foods.MUTTON)));
    public static final RegistrySupplier<Item> COOKED_VENISON = ObjectRegistry.registerItem("cooked_venison", () -> new Item(ObjectRegistry.getSettings().food(Foods.COOKED_MUTTON)));
    public static final RegistrySupplier<Item> TURKEY_MEAT = ObjectRegistry.registerItem("turkey_meat", () -> new Item(ObjectRegistry.getSettings().food(Foods.CHICKEN)));
    public static final RegistrySupplier<Item> COOKED_TURKEY_MEAT = ObjectRegistry.registerItem("cooked_turkey_meat", () -> new Item(ObjectRegistry.getSettings().food(Foods.COOKED_CHICKEN)));
    public static final RegistrySupplier<Item> PELICAN_MEAT = ObjectRegistry.registerItem("pelican_meat", () -> new Item(ObjectRegistry.getSettings().food(Foods.SALMON)));
    public static final RegistrySupplier<Item> COOKED_PELICAN_MEAT = ObjectRegistry.registerItem("cooked_pelican_meat", () -> new Item(ObjectRegistry.getSettings().food(Foods.COOKED_SALMON)));
    public static final RegistrySupplier<Item> CASSOWARY_MEAT = ObjectRegistry.registerItem("cassowary_meat", () -> new Item(ObjectRegistry.getSettings().food(Foods.RABBIT)));
    public static final RegistrySupplier<Item> COOKED_CASSOWARY_MEAT = ObjectRegistry.registerItem("cooked_cassowary_meat", () -> new Item(ObjectRegistry.getSettings().food(Foods.COOKED_RABBIT)));
    public static final RegistrySupplier<Item> BLUNDERBUSS = ObjectRegistry.registerItem("blunderbuss", BlunderBussItem::new);
    public static final RegistrySupplier<Item> FLINT_AMMUNITION = ObjectRegistry.registerItem("flint_ammunition", () -> new FlintAmmunitionItem(ObjectRegistry.getSettings().rarity(Rarity.UNCOMMON), 2));
    public static final RegistrySupplier<Item> DIAMOND_AMMUNITION = ObjectRegistry.registerItem("diamond_ammunition", () -> new AmmunitionItem(ObjectRegistry.getSettings().rarity(Rarity.COMMON), 12));
    public static final RegistrySupplier<Item> FUR_CLOAK = ObjectRegistry.registerItem("fur_cloak", () -> new FurCloakItem((ArmorMaterial)ArmorMaterials.LEATHER.value(), ArmorItem.Type.CHESTPLATE, new Item.Properties()));
    public static final RegistrySupplier<Item> FISH_OIL = ObjectRegistry.registerItem("fish_oil", () -> new Item(ObjectRegistry.getSettings().stacksTo(16)));
    public static final RegistrySupplier<Item> LOOT_BAG = ObjectRegistry.registerItem("loot_bag", () -> new LootBagItem(ObjectRegistry.getSettings().rarity(Rarity.COMMON)));
    public static final RegistrySupplier<Item> BISON_HORN = ObjectRegistry.registerItem("bison_horn", () -> new BisonHornItem(new Item.Properties().stacksTo(1), (SoundEvent)SoundRegistry.BISON_HORN.get()));
    public static final RegistrySupplier<Item> UNCOMMON_CONTRACT = ObjectRegistry.registerItem("uncommon_contract", () -> new Item(ObjectRegistry.getSettings().rarity(Rarity.UNCOMMON)));
    public static final RegistrySupplier<Item> COMMON_CONTRACT = ObjectRegistry.registerItem("common_contract", () -> new Item(ObjectRegistry.getSettings().rarity(Rarity.RARE)));
    public static final RegistrySupplier<Item> RARE_CONTRACT = ObjectRegistry.registerItem("rare_contract", () -> new Item(ObjectRegistry.getSettings().rarity(Rarity.EPIC)));
    public static final RegistrySupplier<Item> LEVELING_CONTRACT = ObjectRegistry.registerItem("leveling_contract", () -> new Item(ObjectRegistry.getSettings().rarity(Rarity.UNCOMMON)));
    public static final RegistrySupplier<Item> DEER_SPAWN_EGG = ObjectRegistry.registerItem("deer_spawn_egg", () -> new ArchitecturySpawnEggItem(EntityTypeRegistry.DEER, -1, -1, ObjectRegistry.getSettings()));
    public static final RegistrySupplier<Item> RED_WOLF_SPAWN_EGG = ObjectRegistry.registerItem("red_wolf_spawn_egg", () -> new ArchitecturySpawnEggItem(EntityTypeRegistry.RED_WOLF, -1, -1, ObjectRegistry.getSettings()));
    public static final RegistrySupplier<Item> RACCOON_SPAWN_EGG = ObjectRegistry.registerItem("raccoon_spawn_egg", () -> new ArchitecturySpawnEggItem(EntityTypeRegistry.RACCOON, -1, -1, ObjectRegistry.getSettings()));
    public static final RegistrySupplier<Item> SQUIRREL_SPAWN_EGG = ObjectRegistry.registerItem("squirrel_spawn_egg", () -> new ArchitecturySpawnEggItem(EntityTypeRegistry.SQUIRREL, -1, -1, ObjectRegistry.getSettings()));
    public static final RegistrySupplier<Item> PELICAN_SPAWN_EGG = ObjectRegistry.registerItem("pelican_spawn_egg", () -> new ArchitecturySpawnEggItem(EntityTypeRegistry.PELICAN, -1, -1, ObjectRegistry.getSettings()));
    public static final RegistrySupplier<Item> OWL_SPAWN_EGG = ObjectRegistry.registerItem("owl_spawn_egg", () -> new ArchitecturySpawnEggItem(EntityTypeRegistry.OWL, -1, -1, ObjectRegistry.getSettings()));
    public static final RegistrySupplier<Item> BOAR_SPAWN_EGG = ObjectRegistry.registerItem("boar_spawn_egg", () -> new ArchitecturySpawnEggItem(EntityTypeRegistry.BOAR, -1, -1, ObjectRegistry.getSettings()));
    public static final RegistrySupplier<Item> BISON_SPAWN_EGG = ObjectRegistry.registerItem("bison_spawn_egg", () -> new ArchitecturySpawnEggItem(EntityTypeRegistry.BISON, -1, -1, ObjectRegistry.getSettings()));
    public static final RegistrySupplier<Item> DOG_SPAWN_EGG = ObjectRegistry.registerItem("dog_spawn_egg", () -> new ArchitecturySpawnEggItem(EntityTypeRegistry.DOG, -1, -1, ObjectRegistry.getSettings()));
    public static final RegistrySupplier<Item> MINISHEEP_SPAWN_EGG = ObjectRegistry.registerItem("minisheep_spawn_egg", () -> new ArchitecturySpawnEggItem(EntityTypeRegistry.MINISHEEP, -1, -1, ObjectRegistry.getSettings()));
    public static final RegistrySupplier<Item> TURKEY_SPAWN_EGG = ObjectRegistry.registerItem("turkey_spawn_egg", () -> new ArchitecturySpawnEggItem(EntityTypeRegistry.TURKEY, -1, -1, ObjectRegistry.getSettings()));
    public static final RegistrySupplier<Item> TERMITE_SPAWN_EGG = ObjectRegistry.registerItem("termite_spawn_egg", () -> new ArchitecturySpawnEggItem(EntityTypeRegistry.TERMITE, -1, -1, ObjectRegistry.getSettings()));
    public static final RegistrySupplier<Item> PENGUIN_SPAWN_EGG = ObjectRegistry.registerItem("penguin_spawn_egg", () -> new ArchitecturySpawnEggItem(EntityTypeRegistry.PENGUIN, -1, -1, ObjectRegistry.getSettings()));
    public static final RegistrySupplier<Item> CASSOWARY_SPAWN_EGG = ObjectRegistry.registerItem("cassowary_spawn_egg", () -> new ArchitecturySpawnEggItem(EntityTypeRegistry.CASSOWARY, -1, -1, ObjectRegistry.getSettings()));
    public static final RegistrySupplier<Item> HEDGEHOG_SPAWN_EGG = ObjectRegistry.registerItem("hedgehog_spawn_egg", () -> new ArchitecturySpawnEggItem(EntityTypeRegistry.HEDGEHOG, -1, -1, ObjectRegistry.getSettings()));
    public static final RegistrySupplier<Item> FLAMINGO_SPAWN_EGG = ObjectRegistry.registerItem("flamingo_spawn_egg", () -> new ArchitecturySpawnEggItem(EntityTypeRegistry.FLAMINGO, -1, -1, ObjectRegistry.getSettings()));
    public static final RegistrySupplier<Item> TRUFFLE = ObjectRegistry.registerItem("truffle", () -> new Item(ObjectRegistry.getSettings().rarity(Rarity.RARE)));
    public static final RegistrySupplier<Block> HAZELNUT_BUSH = ObjectRegistry.registerWithoutItem("hazelnut_bush", () -> new HazelnutBushBlock(BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).randomTicks().noCollission().sound(SoundType.SWEET_BERRY_BUSH).pushReaction(PushReaction.DESTROY)));
    public static final RegistrySupplier<Item> HAZELNUT = ObjectRegistry.registerItem("hazelnut", () -> new ItemNameBlockItem((Block)HAZELNUT_BUSH.get(), ObjectRegistry.getSettings().food(new FoodProperties.Builder().nutrition(4).saturationModifier(0.3f).fast().build())));
    public static final RegistrySupplier<Block> BOUNTY_BOARD = ObjectRegistry.registerWithItem("bounty_board", () -> new BountyBoardBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_PLANKS)));
    public static final RegistrySupplier<Block> DEER_TROPHY = ObjectRegistry.registerWithItem("deer_trophy", () -> new DeerTrophyBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_PLANKS)));
    public static final RegistrySupplier<Block> RED_WOLF_TROPHY = ObjectRegistry.registerWithItem("red_wolf_trophy", () -> new RedWolfTrophyBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_PLANKS)));
    public static final RegistrySupplier<Block> BISON_TROPHY = ObjectRegistry.registerWithItem("bison_trophy", () -> new BisonTrophyBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_PLANKS)));
    public static final RegistrySupplier<Block> WOLF_TRAPPER_BANNER = ObjectRegistry.registerWithItem("wolf_trapper_banner", () -> new CompletionistBannerBlock(BlockBehaviour.Properties.of().strength(1.0f).instrument(NoteBlockInstrument.BASS).noCollission().sound(SoundType.WOOD)));
    public static final RegistrySupplier<Block> WOLF_TRAPPER_WALL_BANNER = ObjectRegistry.registerWithoutItem("wolf_trapper_wall_banner", () -> new CompletionistWallBannerBlock(BlockBehaviour.Properties.of().strength(1.0f).instrument(NoteBlockInstrument.BASS).noCollission().sound(SoundType.WOOD)));
    public static final RegistrySupplier<Block> BUNNY_STALKER_BANNER = ObjectRegistry.registerWithItem("bunny_stalker_banner", () -> new CompletionistBannerBlock(BlockBehaviour.Properties.of().strength(1.0f).instrument(NoteBlockInstrument.BASS).noCollission().sound(SoundType.WOOD)));
    public static final RegistrySupplier<Block> BUNNY_STALKER_WALL_BANNER = ObjectRegistry.registerWithoutItem("bunny_stalker_wall_banner", () -> new CompletionistWallBannerBlock(BlockBehaviour.Properties.of().strength(1.0f).instrument(NoteBlockInstrument.BASS).noCollission().sound(SoundType.WOOD)));
    public static final RegistrySupplier<Block> COD_CATCHER_BANNER = ObjectRegistry.registerWithItem("cod_catcher_banner", () -> new CompletionistBannerBlock(BlockBehaviour.Properties.of().strength(1.0f).instrument(NoteBlockInstrument.BASS).noCollission().sound(SoundType.WOOD)));
    public static final RegistrySupplier<Block> COD_CATCHER_WALL_BANNER = ObjectRegistry.registerWithoutItem("cod_catcher_wall_banner", () -> new CompletionistWallBannerBlock(BlockBehaviour.Properties.of().strength(1.0f).instrument(NoteBlockInstrument.BASS).noCollission().sound(SoundType.WOOD)));
    public static final RegistrySupplier<Item> STYLIN_PURPLE_HAT = ObjectRegistry.registerItem("stylin_purple_hat", () -> new StylinPurpleHatItem((ArmorMaterial)ArmorMaterialRegistry.STYLIN_HAT.value(), ArmorItem.Type.HELMET, ObjectRegistry.getSettings().rarity(Rarity.RARE), WilderNature.identifier("textures/models/armor/stylin_purple_hat.png")));
    public static final RegistrySupplier<Block> TERMITE_MOUND = ObjectRegistry.registerWithItem("termite_mound", () -> new TermiteBlock(Blocks.ROOTED_DIRT, BlockBehaviour.Properties.of().mapColor(MapColor.CLAY)));

    public static void init() {
        ITEMS.register();
        BLOCKS.register();
    }

    public static BlockBehaviour.Properties properties(float strength) {
        return ObjectRegistry.properties(strength, strength);
    }

    public static BlockBehaviour.Properties properties(float breakSpeed, float explosionResist) {
        return BlockBehaviour.Properties.of().strength(breakSpeed, explosionResist);
    }

    private static Item.Properties getSettings(Consumer<Item.Properties> consumer) {
        Item.Properties settings = new Item.Properties();
        consumer.accept(settings);
        return settings;
    }

    static Item.Properties getSettings() {
        return ObjectRegistry.getSettings(settings -> {});
    }

    public static <T extends Block> RegistrySupplier<T> registerWithItem(String name, Supplier<T> block) {
        return WilderNatureUtil.registerWithItem(BLOCKS, BLOCK_REGISTRAR, ITEMS, ITEM_REGISTRAR, WilderNature.identifier(name), block);
    }

    public static <T extends Block> RegistrySupplier<T> registerWithoutItem(String path, Supplier<T> block) {
        return WilderNatureUtil.registerWithoutItem(BLOCKS, BLOCK_REGISTRAR, WilderNature.identifier(path), block);
    }

    public static <T extends Item> RegistrySupplier<T> registerItem(String path, Supplier<T> itemSupplier) {
        return WilderNatureUtil.registerItem(ITEMS, ITEM_REGISTRAR, WilderNature.identifier(path), itemSupplier);
    }
}

