/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.wildernature.core.item;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.satisfy.wildernature.core.entity.BulletEntity;
import org.jetbrains.annotations.Nullable;

public class AmmunitionItem
extends Item {
    private final int damage;

    public AmmunitionItem(Item.Properties properties, int damage) {
        super(properties);
        this.damage = damage;
    }

    public static void onLivingEntityHit(LivingEntity target, @Nullable Entity shooter, Level world) {
    }

    public int getDamage() {
        return this.damage;
    }

    public BulletEntity createProjectile(Level world, ItemStack stack, LivingEntity shooter) {
        BulletEntity entity = new BulletEntity(world, shooter);
        entity.setItem(stack);
        entity.setDamage(this.damage);
        return entity;
    }

    public void consume(ItemStack stack, Player player) {
        stack.shrink(1);
        if (stack.isEmpty()) {
            player.getInventory().removeItem(stack);
        }
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> tooltip, TooltipFlag tooltipFlag) {
        tooltip.add((Component)Component.translatable((String)"tooltip.wildernature.ammunition", (Object[])new Object[]{this.damage}).withStyle(ChatFormatting.DARK_GREEN));
    }

    public boolean hasAmmo(ItemStack stack) {
        return !stack.isEmpty();
    }

    public double modifyDamage(double damage, BulletEntity projectile, Entity target, @Nullable Entity shooter, Level world) {
        return damage;
    }
}

