/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.wildernature.core.entity.ai;

import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.satisfy.wildernature.core.entity.ai.EntityWithAttackAnimation;

public class AnimationAttackGoal
extends MeleeAttackGoal {
    private final EntityWithAttackAnimation animationEntity;
    private int counter;
    private final int attackDelay;
    private final int attackTick;
    private int timeout = 0;

    public AnimationAttackGoal(EntityWithAttackAnimation pMob, double pSpeedModifier, boolean pFollowingTargetEvenIfNotSeen, int attackDelay, int attackTick) {
        super((PathfinderMob)pMob, pSpeedModifier, pFollowingTargetEvenIfNotSeen);
        this.attackDelay = attackDelay;
        this.attackTick = attackTick;
        this.animationEntity = pMob;
    }

    public void start() {
        this.timeout = 0;
        super.start();
    }

    public boolean canContinueToUse() {
        return super.canContinueToUse() && this.timeout < 60;
    }

    public void tick() {
        super.tick();
        LivingEntity target = this.animationEntity.getTarget_();
        if (target != null) {
            this.checkAndPerformAttack(target);
        }
        this.animationEntity.setAttacking_(this.counter != 0);
        if (this.counter != 0) {
            ++this.counter;
        }
        if (this.counter >= this.attackDelay) {
            this.counter = 0;
        }
    }

    protected void checkAndPerformAttack(LivingEntity targetEntity) {
        if (this.isTimeToAttack() && this.mob.isWithinMeleeAttackRange(targetEntity) && this.mob.getSensing().hasLineOfSight((Entity)targetEntity)) {
            if (this.counter == 0) {
                ++this.counter;
            }
            if (this.counter == this.attackTick) {
                this.animationEntity.doHurtTarget_(targetEntity);
            }
            this.timeout = 0;
        } else {
            ++this.timeout;
        }
    }

    public void stop() {
        this.animationEntity.setAttacking_(false);
        super.stop();
    }
}

