/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.wildernature.core.entity;

import dev.architectury.event.EventResult;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.satisfy.wildernature.core.event.TermiteEvents;
import org.jetbrains.annotations.NotNull;

public class TermiteEntity
extends Animal {
    private static final Map<Long, Long> STRIP_COOLDOWN = new HashMap<Long, Long>();
    private BlockPos homePos;
    private int outsideTicks;
    private boolean returning;
    private BlockPos forcedTarget;
    private int forceTicks;
    private static final int MAX_OUTSIDE_TICKS = 900;
    public final AnimationState idleAnimationState = new AnimationState();
    private int idleAnimationTimeout = 0;

    public TermiteEntity(EntityType<? extends Animal> type, Level level) {
        super(type, level);
        PathNavigation pathNavigation = this.getNavigation();
        if (pathNavigation instanceof GroundPathNavigation) {
            GroundPathNavigation nav = (GroundPathNavigation)pathNavigation;
            nav.setCanFloat(true);
        }
        this.setPersistenceRequired();
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull AttributeSupplier.Builder createMobAttributes() {
        return Mob.createMobAttributes().add(Attributes.MOVEMENT_SPEED, 0.16).add(Attributes.MAX_HEALTH, 1.0).add(Attributes.ATTACK_DAMAGE, 0.0);
    }

    public BlockPos getHome() {
        return this.homePos;
    }

    public void setHome(BlockPos pos) {
        this.homePos = pos.immutable();
    }

    public void forceTarget(BlockPos pos, int ticks) {
        this.forcedTarget = pos.immutable();
        this.forceTicks = Math.max(ticks, 0);
        this.returning = false;
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new ReturnHomeGoal());
        this.goalSelector.addGoal(2, (Goal)new StripLogGoal());
        this.goalSelector.addGoal(3, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.9));
        this.goalSelector.addGoal(4, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.goalSelector.addGoal(5, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide) {
            if (this.idleAnimationTimeout <= 0) {
                this.idleAnimationTimeout = this.random.nextInt(40) + 80;
                this.idleAnimationState.start(this.tickCount);
            } else {
                --this.idleAnimationTimeout;
            }
        } else {
            if (this.forceTicks > 0) {
                --this.forceTicks;
            }
            ++this.outsideTicks;
            if (this.outsideTicks > 900) {
                this.returning = true;
            }
            if (this.homePos == null) {
                this.homePos = this.blockPosition().immutable();
            }
        }
    }

    public boolean isAggressive() {
        return false;
    }

    public AgeableMob getBreedOffspring(ServerLevel level, AgeableMob otherParent) {
        return null;
    }

    public boolean isFood(ItemStack stack) {
        return stack.is(Blocks.OAK_PLANKS.asItem()) || stack.is(Blocks.SPRUCE_PLANKS.asItem()) || stack.is(Blocks.BIRCH_PLANKS.asItem()) || stack.is(Blocks.JUNGLE_PLANKS.asItem()) || stack.is(Blocks.ACACIA_PLANKS.asItem()) || stack.is(Blocks.DARK_OAK_PLANKS.asItem()) || stack.is(Blocks.MANGROVE_PLANKS.asItem()) || stack.is(Blocks.CHERRY_PLANKS.asItem()) || stack.is(Blocks.BAMBOO_PLANKS.asItem()) || stack.is(Blocks.CRIMSON_PLANKS.asItem()) || stack.is(Blocks.WARPED_PLANKS.asItem());
    }

    private static long key(ServerLevel level, BlockPos pos) {
        return (long)level.dimension().location().hashCode() << 32 ^ pos.asLong();
    }

    private static boolean canStrip(ServerLevel level, BlockPos pos) {
        long last;
        long k = TermiteEntity.key(level, pos);
        long now = level.getGameTime();
        return now - (last = STRIP_COOLDOWN.getOrDefault(k, Long.MIN_VALUE).longValue()) >= 600L;
    }

    private static void setCooldown(ServerLevel level, BlockPos pos) {
        long k = TermiteEntity.key(level, pos);
        STRIP_COOLDOWN.put(k, level.getGameTime());
    }

    class ReturnHomeGoal
    extends Goal {
        ReturnHomeGoal() {
        }

        public boolean canUse() {
            return TermiteEntity.this.homePos != null && TermiteEntity.this.returning;
        }

        public void start() {
            TermiteEntity.this.getNavigation().moveTo((double)TermiteEntity.this.homePos.getX() + 0.5, (double)TermiteEntity.this.homePos.getY() + 0.1, (double)TermiteEntity.this.homePos.getZ() + 0.5, 1.0);
        }

        public boolean canContinueToUse() {
            return TermiteEntity.this.homePos != null && TermiteEntity.this.returning && TermiteEntity.this.distanceToSqr((double)TermiteEntity.this.homePos.getX() + 0.5, (double)TermiteEntity.this.homePos.getY() + 0.1, (double)TermiteEntity.this.homePos.getZ() + 0.5) > 0.64;
        }

        public void tick() {
            if (TermiteEntity.this.homePos != null) {
                double d = TermiteEntity.this.distanceToSqr((double)TermiteEntity.this.homePos.getX() + 0.5, (double)TermiteEntity.this.homePos.getY() + 0.1, (double)TermiteEntity.this.homePos.getZ() + 0.5);
                if (d <= 0.64) {
                    TermiteEntity.this.returning = false;
                    TermiteEntity.this.outsideTicks = 0;
                    if (!TermiteEntity.this.getNavigation().isDone()) {
                        TermiteEntity.this.getNavigation().stop();
                    }
                } else if (TermiteEntity.this.tickCount % 10 == 0 || TermiteEntity.this.getNavigation().isDone()) {
                    TermiteEntity.this.getNavigation().moveTo((double)TermiteEntity.this.homePos.getX() + 0.5, (double)TermiteEntity.this.homePos.getY() + 0.1, (double)TermiteEntity.this.homePos.getZ() + 0.5, 1.0);
                }
            }
        }

        public void stop() {
            TermiteEntity.this.returning = false;
            TermiteEntity.this.outsideTicks = 0;
        }
    }

    class StripLogGoal
    extends Goal {
        private BlockPos logPos;
        private BlockPos approachPos;

        public StripLogGoal() {
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean canUse() {
            if (TermiteEntity.this.returning) {
                return false;
            }
            if (TermiteEntity.this.forcedTarget != null && TermiteEntity.this.forceTicks > 0) {
                this.logPos = TermiteEntity.this.forcedTarget.immutable();
                this.approachPos = this.computeApproach(this.logPos);
                return this.approachPos != null && this.isStrippable(this.logPos);
            }
            if (TermiteEntity.this.tickCount % 6 != 0) {
                return false;
            }
            Optional<BlockPos> found = this.findNearestUnstrippedLog();
            if (found.isPresent()) {
                this.logPos = found.get();
                this.approachPos = this.computeApproach(this.logPos);
                return this.approachPos != null;
            }
            return false;
        }

        public void start() {
            if (this.approachPos != null) {
                TermiteEntity.this.getNavigation().moveTo((double)this.approachPos.getX() + 0.5, (double)this.approachPos.getY() + 0.1, (double)this.approachPos.getZ() + 0.5, 1.05);
            }
        }

        public boolean canContinueToUse() {
            if (TermiteEntity.this.returning) {
                return false;
            }
            if (this.logPos == null || this.approachPos == null) {
                return false;
            }
            return TermiteEntity.this.forceTicks > 0 || TermiteEntity.this.forcedTarget == null || !this.logPos.equals((Object)TermiteEntity.this.forcedTarget);
        }

        public void tick() {
            if (this.logPos == null) {
                return;
            }
            double d = TermiteEntity.this.distanceToSqr((double)this.logPos.getX() + 0.5, (double)this.logPos.getY() + 0.1, (double)this.logPos.getZ() + 0.5);
            if (d <= 2.75) {
                boolean didStrip = false;
                Level level = TermiteEntity.this.level();
                if (level instanceof ServerLevel) {
                    Block stripped;
                    ServerLevel server = (ServerLevel)level;
                    BlockState state = server.getBlockState(this.logPos);
                    EventResult res = ((TermiteEvents.StripLog)TermiteEvents.STRIP_LOG.invoker()).strip(server, this.logPos, state);
                    if (res == EventResult.interruptTrue()) {
                        didStrip = true;
                    } else if (res != EventResult.interruptFalse() && (stripped = (Block)AxeItem.STRIPPABLES.get(state.getBlock())) != null && TermiteEntity.canStrip(server, this.logPos)) {
                        Direction.Axis axis = state.hasProperty((Property)RotatedPillarBlock.AXIS) ? (Direction.Axis)state.getValue((Property)RotatedPillarBlock.AXIS) : Direction.Axis.Y;
                        BlockState newState = (BlockState)stripped.defaultBlockState().setValue((Property)RotatedPillarBlock.AXIS, (Comparable)axis);
                        server.setBlockAndUpdate(this.logPos, newState);
                        server.playSound(null, this.logPos, SoundEvents.AXE_STRIP, SoundSource.BLOCKS, 1.0f, 1.0f);
                        TermiteEntity.setCooldown(server, this.logPos);
                        didStrip = true;
                    }
                }
                if (TermiteEntity.this.forcedTarget != null && this.logPos.equals((Object)TermiteEntity.this.forcedTarget)) {
                    TermiteEntity.this.forcedTarget = null;
                }
                if (didStrip) {
                    TermiteEntity.this.outsideTicks = 0;
                    TermiteEntity.this.returning = true;
                } else {
                    TermiteEntity.this.outsideTicks = Math.min(TermiteEntity.this.outsideTicks + 40, 900);
                }
                this.logPos = null;
                this.approachPos = null;
            } else if (TermiteEntity.this.tickCount % 10 == 0 || TermiteEntity.this.getNavigation().isDone()) {
                if (this.approachPos == null || TermiteEntity.this.distanceToSqr((double)this.approachPos.getX() + 0.5, (double)this.approachPos.getY() + 0.1, (double)this.approachPos.getZ() + 0.5) <= 0.64) {
                    this.approachPos = this.computeApproach(this.logPos);
                }
                if (this.approachPos != null) {
                    TermiteEntity.this.getNavigation().moveTo((double)this.approachPos.getX() + 0.5, (double)this.approachPos.getY() + 0.1, (double)this.approachPos.getZ() + 0.5, 1.05);
                }
            }
        }

        public void stop() {
            this.logPos = null;
            this.approachPos = null;
        }

        private Optional<BlockPos> findNearestUnstrippedLog() {
            ServerLevel s;
            ServerLevel server;
            int r = 16;
            BlockPos origin = TermiteEntity.this.blockPosition();
            Level level = TermiteEntity.this.level();
            ServerLevel serverLevel = server = level instanceof ServerLevel ? (s = (ServerLevel)level) : null;
            if (server == null) {
                return Optional.empty();
            }
            return BlockPos.betweenClosedStream((BlockPos)origin.offset(-r, -3, -r), (BlockPos)origin.offset(r, 3, r)).map(BlockPos::immutable).filter(p -> this.isStrippable((BlockPos)p) && this.computeApproach((BlockPos)p) != null).min(Comparator.comparingDouble(p -> p.distSqr((Vec3i)origin)));
        }

        private boolean isStrippable(BlockPos pos) {
            Level level = TermiteEntity.this.level();
            if (!(level instanceof ServerLevel)) {
                return false;
            }
            ServerLevel server = (ServerLevel)level;
            BlockState st = server.getBlockState(pos);
            return AxeItem.STRIPPABLES.get(st.getBlock()) != null;
        }

        private BlockPos computeApproach(BlockPos target) {
            BlockPos[] around;
            Level level = TermiteEntity.this.level();
            if (!(level instanceof ServerLevel)) {
                return null;
            }
            ServerLevel server = (ServerLevel)level;
            for (BlockPos a : around = new BlockPos[]{target.west(), target.east(), target.north(), target.south(), target.west().below(), target.east().below(), target.north().below(), target.south().below()}) {
                BlockPos below = a.below();
                if (server.getBlockState(below).isAir() || !server.getBlockState(a).isAir() || TermiteEntity.this.getNavigation().createPath(a, 0) == null) continue;
                return a.immutable();
            }
            return null;
        }
    }
}

