/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.wildernature.core.entity;

import java.util.EnumSet;
import java.util.Objects;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Pillager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.satisfy.wildernature.core.registry.EntityTypeRegistry;
import net.satisfy.wildernature.core.registry.SoundRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeerEntity
extends Animal {
    private static final int FLAG_RUNNING = 256;
    private static final int FLAG_EATING = 65536;
    private static final int FLAG_LOOKING_AROUND = 16;
    private static final EntityDataAccessor<Integer> DATA_TYPE_ID = SynchedEntityData.defineId(DeerEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> DATA_FLAGS_ID = SynchedEntityData.defineId(DeerEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final int CALL_COOLDOWN_TICKS = 200;
    private static final double CALL_RADIUS = 24.0;
    private static final EntityDataAccessor<Boolean> DATA_WHITE = SynchedEntityData.defineId(DeerEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private int callCooldown = 0;
    private int alarmTicks = 0;
    @Nullable
    private Vec3 fleeFrom = null;
    public final AnimationState idleState = new AnimationState();
    public final AnimationState lookAroundState = new AnimationState();
    public final AnimationState eatingState = new AnimationState();
    private int idleAnimationTimeout = 0;
    public int globalCooldown = 0;

    public DeerEntity(EntityType<? extends Animal> entityType, Level world) {
        super(entityType, world);
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull AttributeSupplier.Builder createMobAttributes() {
        return Mob.createMobAttributes().add(Attributes.MOVEMENT_SPEED, 0.270000011920929).add(Attributes.MAX_HEALTH, 10.0).add(Attributes.ATTACK_DAMAGE, 1.5);
    }

    protected SoundEvent getCallSound() {
        return (SoundEvent)SoundRegistry.DEER_HURT.get();
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_TYPE_ID, (Object)0);
        builder.define(DATA_FLAGS_ID, (Object)0);
        builder.define(DATA_WHITE, (Object)false);
    }

    protected void updateWalkAnimation(float pPartialTick) {
        float f = this.getPose() == Pose.STANDING ? Math.min(pPartialTick * 6.0f, 1.0f) : 0.0f;
        this.walkAnimation.update(f, 0.2f);
    }

    protected void registerGoals() {
        int i = 0;
        this.goalSelector.addGoal(++i, new DeerAvoidEntityGoal<Villager>(this, Villager.class));
        this.goalSelector.addGoal(++i, new DeerAvoidEntityGoal<Pillager>(this, Pillager.class));
        this.goalSelector.addGoal(++i, new DeerAvoidEntityGoal<Player>(this, Player.class));
        this.goalSelector.addGoal(++i, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new BreedGoal((Animal)this, 1.15));
        this.goalSelector.addGoal(2, (Goal)new TemptGoal((PathfinderMob)this, 1.2, (Predicate)Ingredient.of((ItemLike[])new ItemLike[]{Items.SHORT_GRASS}), false));
        this.goalSelector.addGoal(3, (Goal)new FollowParentGoal((Animal)this, 1.1));
        this.goalSelector.addGoal(4, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(5, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f));
        this.goalSelector.addGoal(6, (Goal)new DeerEatingGoal(this));
        this.goalSelector.addGoal(7, (Goal)new DeerLookAroundGoal(this));
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData spawnData) {
        SpawnGroupData out = super.finalizeSpawn(level, difficulty, reason, spawnData);
        if (this.random.nextFloat() < 0.01f) {
            this.entityData.set(DATA_WHITE, (Object)true);
        }
        return out;
    }

    public boolean isWhite() {
        return (Boolean)this.entityData.get(DATA_WHITE);
    }

    public void die(DamageSource source) {
        super.die(source);
        if (!this.isWhite()) {
            return;
        }
        Entity killer = source.getEntity();
        if (killer instanceof Projectile) {
            Projectile proj = (Projectile)killer;
            killer = proj.getOwner();
        }
        if (killer instanceof Player) {
            Player p = (Player)killer;
            p.addEffect(new MobEffectInstance(MobEffects.BAD_OMEN, 72000, 0));
            p.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 6000, 1));
        }
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)SoundRegistry.DEER_AMBIENT.get();
    }

    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return (SoundEvent)SoundRegistry.DEER_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)SoundRegistry.DEER_DEATH.get();
    }

    @Nullable
    public DeerEntity getBreedOffspring(ServerLevel serverLevel, AgeableMob ageableMob) {
        return (DeerEntity)((EntityType)EntityTypeRegistry.DEER.get()).create((Level)serverLevel);
    }

    public boolean isFood(ItemStack itemStack) {
        return itemStack.is(Items.SHORT_GRASS);
    }

    public void setupAnimationStates() {
        if (this.idleAnimationTimeout <= 0) {
            this.idleAnimationTimeout = this.random.nextInt(40) + 80;
            this.idleState.start(this.tickCount);
        } else {
            --this.idleAnimationTimeout;
        }
    }

    private void setFlag(int i, boolean bl) {
        if (bl) {
            this.entityData.set(DATA_FLAGS_ID, (Object)((Integer)this.entityData.get(DATA_FLAGS_ID) | i));
        } else {
            this.entityData.set(DATA_FLAGS_ID, (Object)((Integer)this.entityData.get(DATA_FLAGS_ID) & ~i));
        }
    }

    private boolean getFlag(int i) {
        return ((Integer)this.entityData.get(DATA_FLAGS_ID) & i) != 0;
    }

    public void startEating() {
        this.setFlag(65536, true);
    }

    public void stopEating() {
        this.setFlag(65536, false);
    }

    public boolean isEating() {
        return this.getFlag(65536);
    }

    public void startLookingAround() {
        this.setFlag(16, true);
    }

    public void stopLookingAround() {
        this.setFlag(16, false);
    }

    public boolean isLookingAround() {
        return this.getFlag(16);
    }

    public boolean isDeerRunning() {
        return this.getFlag(256);
    }

    public void startRunningAnim() {
        this.setFlag(256, true);
    }

    public void stopRunningAnim() {
        this.setFlag(256, false);
    }

    public void tick() {
        super.tick();
        if (this.globalCooldown > 0) {
            --this.globalCooldown;
        }
        this.eatingState.animateWhen(this.isEating(), this.tickCount);
        this.lookAroundState.animateWhen(this.isLookingAround(), this.tickCount);
        if (this.level().isClientSide) {
            this.setupAnimationStates();
        }
        if (this.callCooldown > 0) {
            --this.callCooldown;
        }
        if (this.alarmTicks > 0) {
            Vec3 dir;
            --this.alarmTicks;
            if (this.fleeFrom != null && !this.level().isClientSide && (dir = this.position().subtract(this.fleeFrom).normalize()).lengthSqr() > 0.001) {
                Vec3 target = this.position().add(dir.scale(8.0));
                this.getNavigation().moveTo(target.x, target.y, target.z, 1.6);
            }
            if (this.alarmTicks == 0) {
                this.stopRunningAnim();
                this.fleeFrom = null;
            }
        }
    }

    private void broadcastCall(boolean warning, @Nullable Entity threat) {
        if (this.callCooldown > 0) {
            return;
        }
        if (this.level().isClientSide) {
            return;
        }
        this.callCooldown = 200;
        SoundEvent snd = warning ? this.getHurtSound(this.damageSources().generic()) : this.getCallSound();
        this.level().playSound(null, this.getX(), this.getY(), this.getZ(), snd, this.getSoundSource(), 1.0f, 1.0f);
        for (DeerEntity d : this.level().getEntitiesOfClass(DeerEntity.class, this.getBoundingBox().inflate(24.0))) {
            if (d == this) continue;
            d.onHeardCall(this, warning, threat);
        }
    }

    private void onHeardCall(DeerEntity source, boolean warning, @Nullable Entity threat) {
        if (warning) {
            this.triggerPanic(threat != null ? threat.position() : source.position());
        } else if (!this.isDeerRunning() && this.random.nextFloat() < 0.35f && this.globalCooldown == 0) {
            this.startLookingAround();
        }
    }

    private void triggerPanic(Vec3 threatPos) {
        this.startRunningAnim();
        this.alarmTicks = 100;
        this.fleeFrom = threatPos;
    }

    public boolean hurt(DamageSource damageSource, float amount) {
        Entity e = damageSource.getEntity();
        this.broadcastCall(true, e);
        return super.hurt(damageSource, amount);
    }

    public static class DeerAvoidEntityGoal<T extends LivingEntity>
    extends AvoidEntityGoal<T> {
        private final DeerEntity deer;

        public DeerAvoidEntityGoal(DeerEntity deer, Class<T> tClass) {
            super((PathfinderMob)deer, tClass, 16.0f, 2.0, 2.0);
            this.deer = deer;
        }

        public boolean canUse() {
            if (this.toAvoid instanceof Player && this.toAvoid.isCrouching()) {
                return false;
            }
            return super.canUse();
        }

        public void start() {
            this.deer.startRunningAnim();
            this.deer.broadcastCall(true, (Entity)this.toAvoid);
            super.start();
        }

        public void stop() {
            this.deer.stopRunningAnim();
            super.stop();
        }
    }

    public static class DeerEatingGoal
    extends Goal {
        private final DeerEntity target;
        private int counter;
        private static final int EATING_DURATION_TICKS = 37;
        private static final int COOLDOWN_TICKS = 400;
        public static final AttributeModifier modifier = new AttributeModifier(ResourceLocation.parse((String)"deer_eat_do_not_move"), -1000.0, AttributeModifier.Operation.ADD_VALUE);

        public DeerEatingGoal(DeerEntity mob) {
            this.target = mob;
            this.setFlags(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE, Goal.Flag.JUMP));
        }

        public boolean requiresUpdateEveryTick() {
            return true;
        }

        public boolean isInterruptable() {
            return true;
        }

        public boolean canUse() {
            float r = new Random().nextFloat();
            return r < 0.01f && !this.target.isDeerRunning() && this.target.globalCooldown == 0;
        }

        public boolean canContinueToUse() {
            return this.counter < 37 && !this.target.isDeerRunning();
        }

        public void tick() {
            ++this.counter;
        }

        public void start() {
            this.counter = 0;
            Objects.requireNonNull(this.target.getAttribute(Attributes.MOVEMENT_SPEED)).addTransientModifier(modifier);
            this.target.startEating();
            super.start();
        }

        public void stop() {
            Objects.requireNonNull(this.target.getAttribute(Attributes.MOVEMENT_SPEED)).removeModifier(modifier);
            this.target.stopEating();
            this.target.globalCooldown = 400;
            super.stop();
        }
    }

    public static class DeerLookAroundGoal
    extends Goal {
        private final DeerEntity target;
        private int counter;
        private static final int LOOK_AROUND_DURATION_TICKS = 70;
        private static final int COOLDOWN_TICKS = 400;
        public static final AttributeModifier modifier = new AttributeModifier(ResourceLocation.parse((String)"deer_look_around_do_not_move"), -1000.0, AttributeModifier.Operation.ADD_VALUE);

        public DeerLookAroundGoal(DeerEntity mob) {
            this.target = mob;
            this.setFlags(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE, Goal.Flag.JUMP));
        }

        public boolean requiresUpdateEveryTick() {
            return true;
        }

        public boolean isInterruptable() {
            return true;
        }

        public boolean canUse() {
            float r = new Random().nextFloat();
            return r < 0.01f && !this.target.isDeerRunning() && this.target.globalCooldown == 0;
        }

        public boolean canContinueToUse() {
            return this.counter < 70 && !this.target.isDeerRunning();
        }

        public void tick() {
            ++this.counter;
        }

        public void start() {
            this.counter = 0;
            Objects.requireNonNull(this.target.getAttribute(Attributes.MOVEMENT_SPEED)).addTransientModifier(modifier);
            this.target.startLookingAround();
            if (this.target.random.nextFloat() < 0.15f) {
                this.target.broadcastCall(false, null);
            }
            super.start();
        }

        public void stop() {
            Objects.requireNonNull(this.target.getAttribute(Attributes.MOVEMENT_SPEED)).removeModifier(modifier);
            this.target.stopLookingAround();
            this.target.globalCooldown = 400;
            super.stop();
        }
    }
}

