/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.wildernature.client.render.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.satisfy.wildernature.WilderNature;
import net.satisfy.wildernature.client.model.entity.OwlModel;
import net.satisfy.wildernature.core.entity.OwlEntity;
import org.jetbrains.annotations.NotNull;

public class OwlRenderer
extends MobRenderer<OwlEntity, OwlModel> {
    private static final ResourceLocation TEXTURE = WilderNature.identifier("textures/entity/owl.png");

    public OwlRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new OwlModel(context.bakeLayer(OwlModel.LAYER_LOCATION)), 0.5f);
    }

    @NotNull
    public ResourceLocation getTextureLocation(OwlEntity entity) {
        return TEXTURE;
    }

    protected void renderNameTag(OwlEntity entity, Component component, PoseStack poseStack, MultiBufferSource multiBufferSource, int i, float f) {
        poseStack.pushPose();
        if (entity.isBaby()) {
            poseStack.translate(0.0f, 0.5f, 0.0f);
        }
        super.renderNameTag((Entity)entity, component, poseStack, multiBufferSource, i, f);
        poseStack.popPose();
    }

    protected void setupRotations(OwlEntity owl, PoseStack poseStack, float f, float g, float h, float j) {
        super.setupRotations((LivingEntity)owl, poseStack, f, g, h, j);
        if (owl.isInSittingPose()) {
            poseStack.translate(0.0f, 0.0f, 0.0f);
        }
        float i = owl.getSwimAmount(h);
        poseStack.translate(0.0f, i / 7.0f / 2.0f, i / 7.0f / 2.0f);
        if (i > 0.0f) {
            poseStack.mulPose(Axis.XP.rotationDegrees(Mth.lerp((float)i, (float)0.0f, (float)-7.0f)));
        }
        poseStack.scale(0.75f, 0.75f, 0.75f);
    }
}

