/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.wildernature.client.model.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.satisfy.wildernature.WilderNature;
import net.satisfy.wildernature.core.entity.PenguinEntity;
import net.satisfy.wildernature.core.entity.animation.PenguinAnimation;
import org.jetbrains.annotations.NotNull;

public class PenguinModel<T extends PenguinEntity>
extends HierarchicalModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(WilderNature.identifier("penguin"), "main");
    private final ModelPart root;

    public PenguinModel(ModelPart root) {
        this.root = root;
    }

    public static LayerDefinition getTexturedModelData() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition root = partdefinition.addOrReplaceChild("root", CubeListBuilder.create().texOffs(0, 0).addBox(-4.5f, -11.8566f, -10.4853f, 9.0f, 12.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)22.8566f, (float)6.4853f));
        PartDefinition cube_r1 = root.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(8, 20).addBox(-3.0f, -2.625f, -1.1f, 6.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.1434f, (float)-2.4853f, (float)-0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition left_wing = root.addOrReplaceChild("left_wing", CubeListBuilder.create().texOffs(0, 20).addBox(0.0f, 0.0f, -3.0f, 1.0f, 8.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)4.5f, (float)-10.8566f, (float)-6.4853f));
        PartDefinition head = root.addOrReplaceChild("head", CubeListBuilder.create().texOffs(33, 19).mirror().addBox(-3.5f, -4.8333f, -3.6667f, 7.0f, 5.0f, 7.0f, new CubeDeformation(0.25f)).mirror(false).texOffs(0, 0).addBox(-1.0f, -1.8333f, -5.6667f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(34, 0).addBox(-3.5f, -4.8333f, -3.6667f, 7.0f, 5.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-12.0232f, (float)-6.3186f));
        PartDefinition right_wing = root.addOrReplaceChild("right_wing", CubeListBuilder.create().texOffs(0, 20).addBox(-1.0f, 0.0f, -3.0f, 1.0f, 8.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-4.5f, (float)-10.8566f, (float)-6.4853f));
        PartDefinition right_foot = root.addOrReplaceChild("right_foot", CubeListBuilder.create().texOffs(34, 12).addBox(-1.5f, 0.0f, -5.0f, 3.0f, 1.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.0f, (float)0.1434f, (float)-6.4853f));
        PartDefinition left_foot = root.addOrReplaceChild("left_foot", CubeListBuilder.create().texOffs(34, 12).addBox(-1.5f, 0.0f, -5.0f, 3.0f, 1.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)2.0f, (float)0.1434f, (float)-6.4853f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.root().getAllParts().forEach(ModelPart::resetPose);
        this.animateWalk(PenguinAnimation.walk, limbSwing, limbSwingAmount, 2.0f, 2.5f);
        this.animate(((PenguinEntity)((Object)entity)).idleAnimationState, PenguinAnimation.idle, ageInTicks, 1.0f);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int alpha) {
        this.root.render(poseStack, vertexConsumer, packedLight, packedOverlay, alpha);
    }

    @NotNull
    public ModelPart root() {
        return this.root;
    }
}

