/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.wildernature.client.model.entity;

import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.world.entity.Entity;
import net.satisfy.wildernature.WilderNature;
import net.satisfy.wildernature.core.entity.OwlEntity;
import net.satisfy.wildernature.core.entity.animation.OwlAnimation;
import org.jetbrains.annotations.NotNull;

public class OwlModel
extends HierarchicalModel<OwlEntity>
implements HeadedModel {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(WilderNature.identifier("owl"), "main");
    private final ModelPart root;
    private final ModelPart head;

    public OwlModel(ModelPart root) {
        this.root = root;
        this.head = root.getChild("root").getChild("animroot").getChild("head");
    }

    public static LayerDefinition getTexturedModelData() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition root = partdefinition.addOrReplaceChild("root", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)16.8532f, (float)-0.6407f));
        PartDefinition animroot = root.addOrReplaceChild("animroot", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition torso_r1 = animroot.addOrReplaceChild("torso_r1", CubeListBuilder.create().texOffs(0, 26).mirror().addBox(-3.5f, -2.475f, -3.75f, 7.0f, 7.0f, 5.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r1 = animroot.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(5, 38).addBox(-7.059f, 4.0f, 3.3f, 7.0f, 4.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.559f, (float)3.2079f, (float)-2.2761f, (float)0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition tailWing = animroot.addOrReplaceChild("tailWing", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.6761f, (float)-1.1119f));
        PartDefinition cube_r2 = tailWing.addOrReplaceChild("cube_r2", CubeListBuilder.create().texOffs(0, 14).addBox(-3.5f, -2.5858f, 0.2071f, 7.0f, 12.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-1.4225f, (float)2.1273f, (float)0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition wing_right = animroot.addOrReplaceChild("wing_right", CubeListBuilder.create(), PartPose.offset((float)3.501f, (float)-0.9282f, (float)-2.3335f));
        PartDefinition wing_right_r1 = wing_right.addOrReplaceChild("wing_right_r1", CubeListBuilder.create().texOffs(14, 9).mirror().addBox(-0.025f, -0.3609f, -2.4857f, 0.0f, 10.0f, 5.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)0.074f, (float)0.2394f, (float)0.1449f, (float)0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition wing_left = animroot.addOrReplaceChild("wing_left", CubeListBuilder.create(), PartPose.offset((float)-3.501f, (float)-0.9282f, (float)-2.3335f));
        PartDefinition wing_left_r1 = wing_left.addOrReplaceChild("wing_left_r1", CubeListBuilder.create().texOffs(14, 9).addBox(0.025f, -0.3609f, -2.4857f, 0.0f, 10.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.074f, (float)0.2394f, (float)0.1449f, (float)0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition leg_right = animroot.addOrReplaceChild("leg_right", CubeListBuilder.create().texOffs(23, 4).addBox(-1.975f, 2.6133f, -2.7904f, 3.95f, 0.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(27, 4).addBox(-0.975f, 0.65f, -0.6f, 1.95f, 2.0f, 0.0f, new CubeDeformation(0.0f)).texOffs(20, 0).mirror().addBox(-1.0f, -0.7354f, -1.0251f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)2.0f, (float)4.4468f, (float)0.2407f));
        PartDefinition leg_left = animroot.addOrReplaceChild("leg_left", CubeListBuilder.create().texOffs(23, 4).mirror().addBox(-1.975f, 2.6133f, -2.7904f, 3.95f, 0.0f, 3.0f, new CubeDeformation(0.0f)).mirror(false).texOffs(27, 4).addBox(-0.975f, 0.65f, -0.6f, 1.95f, 2.0f, 0.0f, new CubeDeformation(0.0f)).texOffs(20, 0).addBox(-1.0f, -0.7354f, -1.0251f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.0f, (float)4.4468f, (float)0.2407f));
        PartDefinition head = animroot.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-3.525f, -4.25f, -3.0833f, 7.05f, 5.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(6, 11).addBox(-3.525f, 0.75f, -3.0833f, 7.05f, 2.0f, 0.0f, new CubeDeformation(0.0f)).texOffs(0, 11).mirror().addBox(-0.5f, -1.25f, -4.0833f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)0.0f, (float)-1.6015f, (float)-1.6284f));
        PartDefinition right_horn_r1 = head.addOrReplaceChild("right_horn_r1", CubeListBuilder.create().texOffs(0, -1).mirror().addBox(-1.25f, -2.0f, -1.0f, 0.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)4.4089f, (float)-3.3661f, (float)-2.0833f, (float)0.0f, (float)0.0f, (float)0.7854f));
        PartDefinition left_horn_r1 = head.addOrReplaceChild("left_horn_r1", CubeListBuilder.create().texOffs(0, 1).addBox(1.25f, -2.0f, -1.0f, 0.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-4.4089f, (float)-3.3661f, (float)-2.0833f, (float)0.0f, (float)0.0f, (float)-0.7854f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)48, (int)48);
    }

    public void setupAnim(OwlEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.root().getAllParts().forEach(ModelPart::resetPose);
        this.animateWalk(OwlAnimation.walk, limbSwing, limbSwingAmount, 2.0f, 2.5f);
        if (entity.attackState.isStarted()) {
            this.animate(entity.attackState, OwlAnimation.attack, ageInTicks);
            return;
        }
        this.animate(entity.flyingState, OwlAnimation.fly, ageInTicks);
        this.animate(entity.hootState, OwlAnimation.hoot, ageInTicks);
        this.animate(entity.sleepState, OwlAnimation.sleep, ageInTicks);
    }

    public void prepareMobModel(OwlEntity entity, float limbAngle, float limbDistance, float delta) {
        super.prepareMobModel((Entity)entity, limbAngle, limbDistance, delta);
    }

    @NotNull
    public ModelPart root() {
        return this.root;
    }

    @NotNull
    public ModelPart getHead() {
        return this.head;
    }
}

