/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.wildernature.client.model.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.satisfy.wildernature.WilderNature;
import net.satisfy.wildernature.core.entity.MiniSheepEntity;
import net.satisfy.wildernature.core.entity.animation.MiniSheepAnimation;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class MiniSheepModel<T extends MiniSheepEntity>
extends HierarchicalModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(WilderNature.identifier("minisheep"), "main");
    private final ModelPart mini_sheep;
    private final ModelPart head;

    public MiniSheepModel(ModelPart root) {
        this.mini_sheep = root.getChild("mini_sheep");
        this.head = this.mini_sheep.getChild("head");
    }

    public static LayerDefinition getTexturedModelData() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition mini_sheep = partdefinition.addOrReplaceChild("mini_sheep", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)14.0f, (float)0.0f));
        PartDefinition head = mini_sheep.addOrReplaceChild("head", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)-2.24f, (float)-7.04f));
        PartDefinition h_horn = head.addOrReplaceChild("h_horn", CubeListBuilder.create(), PartPose.offset((float)-0.24f, (float)-2.16f, (float)-0.48f));
        PartDefinition cube_r1 = h_horn.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(39, 9).mirror().addBox(-1.44f, -0.6f, -4.32f, 2.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)).mirror(false).texOffs(39, 9).addBox(-8.24f, -0.6f, -4.32f, 2.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)4.08f, (float)-2.4f, (float)0.0f, (float)0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition h_ear = head.addOrReplaceChild("h_ear", CubeListBuilder.create(), PartPose.offset((float)0.48f, (float)-1.68f, (float)-1.92f));
        PartDefinition right_ear = h_ear.addOrReplaceChild("right_ear", CubeListBuilder.create(), PartPose.offset((float)3.84f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r2 = right_ear.addOrReplaceChild("cube_r2", CubeListBuilder.create().texOffs(28, 27).addBox(-7.22f, -1.48f, -0.04f, 3.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.4f, (float)5.4f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.7854f));
        PartDefinition left_ear = h_ear.addOrReplaceChild("left_ear", CubeListBuilder.create(), PartPose.offset((float)-4.8f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r3 = left_ear.addOrReplaceChild("cube_r3", CubeListBuilder.create().texOffs(28, 27).mirror().addBox(4.22f, -1.48f, -0.04f, 3.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-3.4f, (float)5.4f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.7854f));
        PartDefinition h_head2 = head.addOrReplaceChild("h_head2", CubeListBuilder.create().texOffs(0, 27).mirror().addBox(-3.0f, -2.2f, -3.84f, 6.0f, 7.0f, 5.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)0.0f, (float)-1.2f, (float)0.0f));
        PartDefinition cube_r4 = h_head2.addOrReplaceChild("cube_r4", CubeListBuilder.create().texOffs(17, 27).mirror().addBox(-2.0f, -4.76f, 0.84f, 4.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)7.2f, (float)-4.8f, (float)0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition body = mini_sheep.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-5.28f, -5.8f, -7.62f, 12.0f, 12.0f, 15.0f, new CubeDeformation(0.8f)).texOffs(1, 33).addBox(-5.28f, -5.8f, -7.62f, 12.0f, 12.0f, 15.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-0.72f, (float)-1.0f, (float)1.12f));
        PartDefinition right_front_leg = mini_sheep.addOrReplaceChild("right_front_leg", CubeListBuilder.create().texOffs(0, 7).mirror().addBox(-1.08f, -0.2f, -1.16f, 3.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)3.6f, (float)5.2f, (float)-4.88f));
        PartDefinition left_front_leg = mini_sheep.addOrReplaceChild("left_front_leg", CubeListBuilder.create().texOffs(0, 7).mirror().addBox(-1.56f, -0.2f, -1.16f, 3.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)-3.6f, (float)5.2f, (float)-4.88f));
        PartDefinition right_hind_leg = mini_sheep.addOrReplaceChild("right_hind_leg", CubeListBuilder.create().texOffs(0, 7).mirror().addBox(-1.08f, -0.2f, -1.2f, 3.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)3.6f, (float)5.2f, (float)6.12f));
        PartDefinition left_hind_leg = mini_sheep.addOrReplaceChild("left_hind_leg", CubeListBuilder.create().texOffs(0, 7).addBox(-1.56f, -0.2f, -2.2f, 3.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-3.6f, (float)5.2f, (float)7.12f));
        PartDefinition tail = mini_sheep.addOrReplaceChild("tail", CubeListBuilder.create().texOffs(4, 2).addBox(-0.96f, -0.6f, -1.52f, 3.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-0.12f, (float)1.84f, (float)9.76f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(MiniSheepEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.root().getAllParts().forEach(ModelPart::resetPose);
        this.applyHeadRotation(netHeadYaw, headPitch);
        this.animateWalk(MiniSheepAnimation.walk, limbSwing, limbSwingAmount, 2.0f, 2.5f);
        this.animate(entity.idleAnimationState, MiniSheepAnimation.idle, ageInTicks, 1.0f);
        this.animate(entity.attackAnimationState, MiniSheepAnimation.attack, ageInTicks, 1.0f);
        this.animate(entity.eatAnimationState, MiniSheepAnimation.eat, ageInTicks, 1.0f);
    }

    private void applyHeadRotation(float pNetHeadYaw, float pHeadPitch) {
        pNetHeadYaw = Mth.clamp((float)pNetHeadYaw, (float)-30.0f, (float)30.0f);
        pHeadPitch = Mth.clamp((float)pHeadPitch, (float)-25.0f, (float)45.0f);
        this.head.yRot = pNetHeadYaw * ((float)Math.PI / 180);
        this.head.xRot = pHeadPitch * ((float)Math.PI / 180);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int alpha) {
        this.mini_sheep.render(poseStack, vertexConsumer, packedLight, packedOverlay, alpha);
    }

    @NotNull
    public ModelPart root() {
        return this.mini_sheep;
    }
}

