/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.wildernature.client.model.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.satisfy.wildernature.WilderNature;
import net.satisfy.wildernature.core.entity.DeerEntity;
import net.satisfy.wildernature.core.entity.animation.DeerAnimation;
import org.jetbrains.annotations.NotNull;

public class DeerModel
extends HierarchicalModel<DeerEntity> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(WilderNature.identifier("deer"), "main");
    private final ModelPart deer;
    private final ModelPart head;

    public DeerModel(ModelPart root) {
        this.deer = root.getChild("deer");
        this.head = this.deer.getChild("body").getChild("head");
    }

    public static LayerDefinition getTexturedModelData() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition deer = partdefinition.addOrReplaceChild("deer", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition body = deer.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-2.0f, -6.0f, 7.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(0, 0).addBox(-5.0f, -4.0f, -9.0f, 10.0f, 9.0f, 18.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-15.0f, (float)0.0f));
        PartDefinition head = body.addOrReplaceChild("head", CubeListBuilder.create().texOffs(18, 27).addBox(-3.0f, -12.0f, -7.0f, 6.0f, 5.0f, 7.0f, new CubeDeformation(0.0f)).texOffs(0, 9).addBox(-2.0f, -10.0f, -10.0f, 4.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(0, 27).addBox(-2.0f, -7.0f, -5.0f, 4.0f, 11.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)-7.0f));
        head.addOrReplaceChild("horn_right_r1", CubeListBuilder.create().texOffs(19, 28).addBox(-3.09f, -37.0f, -14.0f, 0.0f, 10.0f, 11.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)15.0f, (float)7.0f, (float)0.0f, (float)0.0f, (float)0.2182f));
        head.addOrReplaceChild("horn_left_r1", CubeListBuilder.create().texOffs(19, 28).addBox(2.93f, -37.0f, -14.0f, 0.0f, 10.0f, 11.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)15.0f, (float)7.0f, (float)0.0f, (float)0.0f, (float)-0.2182f));
        head.addOrReplaceChild("left_ear_r1", CubeListBuilder.create().texOffs(38, 0).mirror().addBox(-7.0f, -26.0f, -9.0f, 3.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)15.0f, (float)7.0f, (float)0.0f, (float)0.0f, (float)0.0436f));
        head.addOrReplaceChild("right_ear_r1", CubeListBuilder.create().texOffs(38, 0).addBox(4.0f, -26.0f, -9.0f, 3.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)15.0f, (float)7.0f, (float)0.0f, (float)0.0f, (float)-0.0436f));
        deer.addOrReplaceChild("leftHindLeg", CubeListBuilder.create().texOffs(38, 5).addBox(-1.5f, 0.0f, -1.5f, 3.0f, 10.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-3.5f, (float)-10.0f, (float)7.5f));
        deer.addOrReplaceChild("rightHindLeg", CubeListBuilder.create().texOffs(38, 5).mirror().addBox(-1.5f, 0.0f, -1.5f, 3.0f, 10.0f, 3.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)3.5f, (float)-10.0f, (float)7.5f));
        deer.addOrReplaceChild("rightFrontLeg", CubeListBuilder.create().texOffs(38, 5).mirror().addBox(-1.5f, 0.0f, -1.5f, 3.0f, 10.0f, 3.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)3.5f, (float)-10.0f, (float)-7.5f));
        deer.addOrReplaceChild("leftFrontLeg", CubeListBuilder.create().texOffs(38, 5).addBox(-1.5f, 0.0f, -1.5f, 3.0f, 10.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-3.5f, (float)-10.0f, (float)-7.5f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(DeerEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.root().getAllParts().forEach(ModelPart::resetPose);
        this.head.yRot = netHeadYaw * 0.008945329f;
        this.head.xRot = headPitch * 0.0047453293f;
        this.animate(entity.idleState, DeerAnimation.idle, ageInTicks, 1.0f);
        if (entity.isDeerRunning()) {
            this.animateWalk(DeerAnimation.run, limbSwing, limbSwingAmount, 1.5f, 2.5f);
        } else {
            this.animateWalk(DeerAnimation.walk, limbSwing, limbSwingAmount, 1.0f, 2.5f);
        }
        this.animate(entity.lookAroundState, DeerAnimation.look_around, ageInTicks, 1.0f);
        this.animate(entity.eatingState, DeerAnimation.eat, ageInTicks, 1.0f);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int alpha) {
        this.deer.render(poseStack, vertexConsumer, packedLight, packedOverlay, alpha);
    }

    @NotNull
    public ModelPart root() {
        return this.deer;
    }
}

