/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.wildernature.client.model.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.world.entity.Entity;
import net.satisfy.wildernature.WilderNature;
import net.satisfy.wildernature.core.entity.CassowaryEntity;
import net.satisfy.wildernature.core.entity.animation.CassowaryAnimation;
import org.jetbrains.annotations.NotNull;

public class CassowaryModel<T extends Entity>
extends HierarchicalModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(WilderNature.identifier("cassowary"), "main");
    private final ModelPart root;

    public CassowaryModel(ModelPart root) {
        this.root = root;
    }

    public static LayerDefinition getTexturedModelData() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition root = partdefinition.addOrReplaceChild("root", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -5.4063f, -6.3831f, 8.0f, 8.0f, 13.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)15.3134f, (float)0.4225f, (float)-0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition body_r1 = root.addOrReplaceChild("body_r1", CubeListBuilder.create().texOffs(29, 2).addBox(-3.0f, -3.5f, 0.95f, 6.0f, 7.425f, 3.05f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-0.642f, (float)4.2608f, (float)0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition rightLeg = root.addOrReplaceChild("rightLeg", CubeListBuilder.create().texOffs(28, 21).addBox(-1.0f, 4.1764f, 1.5091f, 2.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(-1, 9).mirror().addBox(-2.5f, 9.0508f, -1.6653f, 5.0f, 0.0f, 4.0f, new CubeDeformation(0.0f)).mirror(false).texOffs(0, 29).addBox(-0.5f, 8.1764f, -1.4909f, 1.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-3.5f, (float)-0.3642f, (float)-1.7572f, (float)0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r1 = rightLeg.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(47, 0).addBox(-1.5f, -3.6173f, -2.5761f, 3.0f, 7.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)1.6764f, (float)1.5091f, (float)0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition leftLeg = root.addOrReplaceChild("leftLeg", CubeListBuilder.create().texOffs(28, 21).addBox(-1.0f, 4.1764f, 1.5091f, 2.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(0, 29).addBox(-0.5f, 8.1764f, -1.4909f, 1.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(-1, 9).mirror().addBox(-2.5f, 9.0508f, -1.6653f, 5.0f, 0.0f, 4.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)3.5f, (float)-0.3642f, (float)-1.7572f, (float)0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r2 = leftLeg.addOrReplaceChild("cube_r2", CubeListBuilder.create().texOffs(47, 0).mirror().addBox(-1.5f, -3.6173f, -2.5761f, 3.0f, 7.0f, 5.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)1.6764f, (float)1.5091f, (float)0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition neck = root.addOrReplaceChild("neck", CubeListBuilder.create().texOffs(0, 6).addBox(-1.475f, 0.0089f, -5.218f, 2.95f, 5.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-1.4032f, (float)-6.2757f, (float)0.2182f, (float)0.0f, (float)0.0f));
        PartDefinition neck_r1 = neck.addOrReplaceChild("neck_r1", CubeListBuilder.create().texOffs(42, 12).addBox(-1.475f, -2.0f, -3.0f, 2.95f, 4.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-0.6908f, (float)-1.68f, (float)-0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition neck_r2 = neck.addOrReplaceChild("neck_r2", CubeListBuilder.create().texOffs(0, 0).addBox(-1.475f, -1.2396f, -0.8734f, 2.95f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-4.9788f, (float)-2.2057f, (float)-0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition head = neck.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 21).addBox(-1.5005f, -2.9853f, -4.9234f, 3.0f, 3.0f, 5.0f, new CubeDeformation(0.0f)).texOffs(18, 21).addBox(-1.0005f, -1.9853f, -7.9234f, 2.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)5.0E-4f, (float)-5.3249f, (float)0.1569f));
        PartDefinition horn_r1 = head.addOrReplaceChild("horn_r1", CubeListBuilder.create().texOffs(11, 24).addBox(2.5f, -0.2503f, -0.1064f, 1.0f, 5.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-3.0005f, (float)-6.5061f, (float)-3.7557f, (float)-0.3927f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.root.getAllParts().forEach(ModelPart::resetPose);
        this.animate(((CassowaryEntity)entity).idleAnimationState, CassowaryAnimation.idle, ageInTicks, 1.0f);
        this.animateWalk(CassowaryAnimation.walk, limbSwing, limbSwingAmount, 2.0f, 2.5f);
        this.animate(((CassowaryEntity)entity).attackAnimationState, CassowaryAnimation.attack, ageInTicks, 1.0f);
    }

    public void renderToBuffer(PoseStack matrices, VertexConsumer vertexConsumer, int light, int overlay, int alpha) {
        this.root.render(matrices, vertexConsumer, light, overlay, alpha);
    }

    @NotNull
    public ModelPart root() {
        return this.root;
    }
}

