/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.wildernature.client.model.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.satisfy.wildernature.WilderNature;
import net.satisfy.wildernature.core.entity.BisonEntity;
import net.satisfy.wildernature.core.entity.animation.BisonAnimation;
import org.jetbrains.annotations.NotNull;

public class BisonModel<T extends BisonEntity>
extends HierarchicalModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(WilderNature.identifier("bison"), "main");
    private final ModelPart root;
    private final ModelPart visualRoot;
    private final ModelPart animroot;
    private final ModelPart body;
    private final ModelPart head;
    private boolean baby;

    public BisonModel(ModelPart root) {
        this.root = root;
        this.visualRoot = root.getChild("root");
        this.animroot = this.visualRoot.getChild("animroot");
        this.body = this.animroot.getChild("Body");
        this.head = this.body.getChild("Head");
    }

    public static LayerDefinition getTexturedModelData() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition root = partdefinition.addOrReplaceChild("root", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition animroot = root.addOrReplaceChild("animroot", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)-22.0f, (float)0.0f));
        PartDefinition Body = animroot.addOrReplaceChild("Body", CubeListBuilder.create().texOffs(0, 46).addBox(-8.5f, -10.88f, -11.15f, 17.0f, 22.0f, 21.0f, new CubeDeformation(0.0f)).texOffs(56, 69).addBox(-8.5f, 11.12f, -11.15f, 17.0f, 7.0f, 21.0f, new CubeDeformation(0.0f)).texOffs(0, 0).addBox(-9.5f, -11.88f, -11.4f, 19.0f, 23.0f, 22.0f, new CubeDeformation(0.0f)).texOffs(64, 27).addBox(-7.5f, -8.98f, 7.85f, 15.0f, 20.0f, 19.0f, new CubeDeformation(0.0f)).texOffs(0, 90).addBox(0.0f, 9.12f, -11.15f, 0.0f, 11.0f, 21.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-2.12f, (float)-7.85f));
        Body.addOrReplaceChild("Tail", CubeListBuilder.create().texOffs(65, 120).addBox(-1.0f, -1.0f, -2.0f, 2.0f, 2.0f, 11.0f, new CubeDeformation(0.0f)).texOffs(0, 7).addBox(-1.5f, -1.5f, 9.0f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(0, 0).addBox(-1.5f, -1.5f, 12.0f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-1.88f, (float)25.85f, (float)-0.9599f, (float)0.0f, (float)0.0f));
        PartDefinition Head = Body.addOrReplaceChild("Head", CubeListBuilder.create().texOffs(83, 0).addBox(-5.5f, -0.9677f, -6.4743f, 11.0f, 13.0f, 12.0f, new CubeDeformation(0.0f)).texOffs(114, 26).addBox(-3.5f, 12.0323f, -2.4743f, 7.0f, 5.0f, 8.0f, new CubeDeformation(0.0f)).texOffs(92, 124).addBox(-0.1f, -0.9677f, 5.5257f, 0.0f, 16.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(43, 98).addBox(-6.5f, -1.9677f, -11.4743f, 13.0f, 15.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(112, 67).addBox(-6.5f, -1.9677f, -5.4743f, 13.0f, 15.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(22, 90).addBox(-9.5f, 3.346f, -13.0429f, 3.0f, 3.0f, 10.0f, new CubeDeformation(0.0f)).texOffs(0, 46).addBox(-6.5f, 3.346f, -6.0429f, 2.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(22, 90).mirror().addBox(6.5f, 3.346f, -13.0429f, 3.0f, 3.0f, 10.0f, new CubeDeformation(0.0f)).mirror(false).texOffs(0, 46).mirror().addBox(4.5f, 3.346f, -6.0429f, 2.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)2.12f, (float)-10.15f, (float)-1.2217f, (float)0.0f, (float)0.0f));
        Head.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(0, 14).mirror().addBox(-0.5f, -1.7498f, -0.4891f, 5.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)).mirror(false).texOffs(0, 14).addBox(-15.5f, -1.7498f, -0.4891f, 5.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)5.5f, (float)7.6632f, (float)-2.7214f, (float)1.6144f, (float)0.0f, (float)0.0f));
        animroot.addOrReplaceChild("leg_back_right", CubeListBuilder.create().texOffs(82, 98).addBox(-3.5f, -3.0f, -3.5f, 7.0f, 18.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-4.6f, (float)7.0f, (float)12.5f));
        animroot.addOrReplaceChild("leg_front_right", CubeListBuilder.create().texOffs(36, 120).addBox(-3.5f, -3.5f, -3.5f, 7.0f, 18.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-4.5f, (float)7.5f, (float)-12.5f));
        animroot.addOrReplaceChild("leg_front_left", CubeListBuilder.create().texOffs(0, 123).addBox(-3.5f, -3.4515f, -3.4145f, 7.0f, 18.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offset((float)4.5f, (float)7.5f, (float)-12.5f));
        animroot.addOrReplaceChild("leg_back_left", CubeListBuilder.create().texOffs(111, 98).addBox(-3.5f, -3.0f, -3.5f, 7.0f, 18.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offset((float)4.6f, (float)7.0f, (float)12.5f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)256, (int)256);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.root().getAllParts().forEach(ModelPart::resetPose);
        this.baby = entity.isBaby();
        this.animateWalk(BisonAnimation.walk, limbSwing, limbSwingAmount, 2.0f, 2.5f);
        this.animate(((BisonEntity)entity).idleAnimationState, BisonAnimation.idle, ageInTicks, 1.0f);
        this.animate(((BisonEntity)entity).attackAnimationState, BisonAnimation.attack, ageInTicks, 1.0f);
        this.animate(((BisonEntity)entity).rollingAnimationState, BisonAnimation.rolling, ageInTicks, 1.0f);
    }

    public ModelPart head() {
        return this.head;
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int alpha) {
        if (this.baby) {
            boolean vis = this.head.visible;
            this.head.visible = false;
            this.root.render(poseStack, vertexConsumer, packedLight, packedOverlay, alpha);
            this.head.visible = vis;
            poseStack.pushPose();
            this.visualRoot.translateAndRotate(poseStack);
            this.animroot.translateAndRotate(poseStack);
            this.body.translateAndRotate(poseStack);
            poseStack.translate(0.0, 0.0, 0.5);
            poseStack.scale(1.85f, 1.85f, 1.85f);
            this.head.render(poseStack, vertexConsumer, packedLight, packedOverlay, alpha);
            poseStack.popPose();
            return;
        }
        this.root.render(poseStack, vertexConsumer, packedLight, packedOverlay, alpha);
    }

    @NotNull
    public ModelPart root() {
        return this.root;
    }
}

