/*
 * Decompiled with CFR 0.152.
 */
package com.luxtracon.floralis.data.tags;

import java.util.concurrent.CompletableFuture;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.BiomeTagsProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class FloralisBiomeTags
extends BiomeTagsProvider {
    public static final TagKey<Biome> HAS_CACTUS = FloralisBiomeTags.floralisTag("has_cactus");

    public FloralisBiomeTags(PackOutput pOutput, CompletableFuture<HolderLookup.Provider> pProvider, String pId, ExistingFileHelper pHelper) {
        super(pOutput, pProvider, pId, pHelper);
    }

    public void addTags(HolderLookup.Provider pProvider) {
        this.tag(HAS_CACTUS).add(Biomes.BADLANDS).add(Biomes.ERODED_BADLANDS).add(Biomes.WOODED_BADLANDS).add(Biomes.DESERT);
    }

    public static TagKey<Biome> bind(String pName) {
        return TagKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.parse((String)pName));
    }

    public static TagKey<Biome> cTag(String pName) {
        return FloralisBiomeTags.bind("c:" + pName);
    }

    public static TagKey<Biome> floralisTag(String pName) {
        return FloralisBiomeTags.bind("floralis:" + pName);
    }

    public static TagKey<Biome> neoforgeTag(String pName) {
        return FloralisBiomeTags.bind("neoforge:" + pName);
    }

    public static TagKey<Biome> industrialforegoingTag(String pName) {
        return FloralisBiomeTags.bind("industrialforegoing:" + pName);
    }
}

