/*
 * Decompiled with CFR 0.152.
 */
package com.luxtracon.floralis.block;

import com.luxtracon.floralis.registry.FloralisBlockStateProperties;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class FlowerCropBlock
extends CropBlock {
    public static final VoxelShape[] SHAPES = new VoxelShape[]{Block.box((double)5.25, (double)-1.0, (double)5.25, (double)10.75, (double)1.0, (double)10.75), Block.box((double)5.25, (double)-1.0, (double)5.25, (double)10.75, (double)3.0, (double)10.75), Block.box((double)5.25, (double)-1.0, (double)5.25, (double)10.75, (double)5.0, (double)10.75), Block.box((double)5.25, (double)-1.0, (double)5.25, (double)10.75, (double)7.0, (double)10.75), Block.box((double)5.25, (double)-1.0, (double)5.25, (double)10.75, (double)9.0, (double)10.75), Block.box((double)5.25, (double)-1.0, (double)5.25, (double)10.75, (double)11.0, (double)10.75)};

    public FlowerCropBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)this.getAgeProperty(), (Comparable)Integer.valueOf(0)));
    }

    public boolean canSurvive(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        return (pLevel.getRawBrightness(pPos, 0) >= 8 || pLevel.canSeeSky(pPos)) && this.mayPlaceOn(pLevel.getBlockState(pPos.below()), (BlockGetter)pLevel, pPos);
    }

    public boolean mayPlaceOn(BlockState pState, BlockGetter pLevel, BlockPos pPos) {
        return pState.getBlock() instanceof FarmBlock;
    }

    public int getBonemealAgeIncrease(Level pLevel) {
        return Mth.nextInt((RandomSource)pLevel.random, (int)1, (int)3);
    }

    public int getMaxAge() {
        return 5;
    }

    public void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{FloralisBlockStateProperties.AGE});
    }

    public BlockState updateShape(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        return !pState.canSurvive((LevelReader)pLevel, pCurrentPos) ? Blocks.AIR.defaultBlockState() : super.updateShape(pState, pFacing, pFacingState, pLevel, pCurrentPos, pFacingPos);
    }

    public IntegerProperty getAgeProperty() {
        return FloralisBlockStateProperties.AGE;
    }

    public ItemLike getBaseSeedId() {
        return this;
    }

    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPES[(Integer)pState.getValue((Property)this.getAgeProperty())];
    }
}

