/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.item.scuba;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.tropicraft.core.client.data.TropicraftLangKeys;
import net.tropicraft.core.client.scuba.ScubaHUD;
import net.tropicraft.core.common.item.TropicraftDataComponents;
import net.tropicraft.core.common.item.scuba.ScubaArmorItem;
import net.tropicraft.core.common.item.scuba.ScubaType;

public class ScubaHarnessItem
extends ScubaArmorItem {
    public ScubaHarnessItem(ScubaType type, Item.Properties properties) {
        super(type, ArmorItem.Type.CHESTPLATE, properties);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flagIn) {
        super.appendHoverText(stack, context, tooltip, flagIn);
        int airRemaining = this.getRemainingAir(stack);
        tooltip.add((Component)TropicraftLangKeys.SCUBA_AIR_TIME.format(Component.literal((String)ScubaHUD.formatTime(airRemaining)).withStyle(ScubaHUD.getAirTimeColor(airRemaining))).copy().withStyle(ChatFormatting.GRAY));
    }

    @Override
    public boolean providesAir() {
        return true;
    }

    @Override
    public void tickAir(Player player, EquipmentSlot slot, ItemStack stack) {
        if (player.level().isClientSide || player.getAbilities().instabuild) {
            return;
        }
        int remainingAir = this.getRemainingAir(stack);
        if (remainingAir > 0) {
            stack.set(TropicraftDataComponents.SCUBA_AIR, (Object)(remainingAir - 1));
            player.setAirSupply(player.getMaxAirSupply());
        }
    }

    @Override
    public int addAir(int air, ItemStack stack) {
        if (air > 0) {
            int current = this.getRemainingAir(stack);
            int max = this.getMaxAir(stack);
            int newAir = Math.min(current + air, max);
            stack.set(TropicraftDataComponents.SCUBA_AIR, (Object)newAir);
            return air - (newAir - current);
        }
        return 0;
    }

    @Override
    public int getRemainingAir(ItemStack stack) {
        return (Integer)stack.getOrDefault(TropicraftDataComponents.SCUBA_AIR, (Object)0);
    }

    @Override
    public int getMaxAir(ItemStack stack) {
        return 12000;
    }
}

