/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.item.scuba;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.Collections;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import net.tropicraft.core.common.dimension.TropicraftDimension;
import net.tropicraft.core.common.item.scuba.ScubaArmorItem;
import net.tropicraft.core.common.network.message.ClientboundUpdateScubaDataPacket;

@EventBusSubscriber(modid="tropicraft", bus=EventBusSubscriber.Bus.GAME)
public class ScubaData {
    public static final Codec<ScubaData> CODEC = RecordCodecBuilder.create(i -> i.group((App)Codec.LONG.fieldOf("diveTime").forGetter(ScubaData::getDiveTime), (App)Codec.DOUBLE.fieldOf("maxDepth").forGetter(ScubaData::getMaxDepth)).apply((Applicative)i, ScubaData::new));
    public static final StreamCodec<ByteBuf, ScubaData> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_LONG, ScubaData::getDiveTime, (StreamCodec)ByteBufCodecs.DOUBLE, ScubaData::getMaxDepth, ScubaData::new);
    public static final DeferredRegister<AttachmentType<?>> ATTACHMENT_TYPES = DeferredRegister.create((Registry)NeoForgeRegistries.ATTACHMENT_TYPES, (String)"tropicraft");
    public static final Supplier<AttachmentType<ScubaData>> ATTACHMENT = ATTACHMENT_TYPES.register("scuba_data", () -> AttachmentType.builder(ScubaData::new).serialize(CODEC).build());
    private static final Set<ServerPlayer> underwaterPlayers = Collections.newSetFromMap(new WeakHashMap());
    private long diveTime;
    private double maxDepth;
    private boolean dirty;

    @SubscribeEvent
    public static void onPlayerTick(PlayerTickEvent.Post event) {
        Player player = event.getEntity();
        Level world = player.level();
        ItemStack chestStack = player.getItemBySlot(EquipmentSlot.CHEST);
        Item item = chestStack.getItem();
        if (item instanceof ScubaArmorItem) {
            ScubaArmorItem scubaItem = (ScubaArmorItem)item;
            ScubaData data = (ScubaData)player.getData(ATTACHMENT);
            if (!world.isClientSide) {
                underwaterPlayers.add((ServerPlayer)player);
            }
            if (ScubaData.isUnderWater(player)) {
                data.tick(player);
                if (!world.isClientSide) {
                    data.updateClient((ServerPlayer)player, false);
                }
                scubaItem.tickAir(player, EquipmentSlot.CHEST, chestStack);
                if (!world.isClientSide && world.getGameTime() % 60L == 0L) {
                    Vec3 eyePos = player.getEyePosition(0.0f);
                    Vec3 motion = player.getDeltaMovement();
                    Vec3 particlePos = eyePos.add(motion.reverse());
                    ((ServerLevel)world).sendParticles((ParticleOptions)ParticleTypes.BUBBLE, particlePos.x(), particlePos.y(), particlePos.z(), 4 + world.random.nextInt(3), 0.25, 0.25, 0.25, motion.length());
                }
            } else if (!world.isClientSide && underwaterPlayers.remove(player)) {
                data.updateClient((ServerPlayer)player, false);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        ScubaData.updateClient((PlayerEvent)event);
    }

    @SubscribeEvent
    public static void onPlayerLogIn(PlayerEvent.PlayerLoggedInEvent event) {
        ScubaData.updateClient((PlayerEvent)event);
    }

    @SubscribeEvent
    public static void onPlayerChangeDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        ScubaData.updateClient((PlayerEvent)event);
    }

    private static void updateClient(PlayerEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            ((ScubaData)player2.getData(ATTACHMENT)).updateClient(player2, true);
        }
    }

    public ScubaData() {
    }

    public ScubaData(long diveTime, double maxDepth) {
        this.diveTime = diveTime;
        this.maxDepth = maxDepth;
    }

    public static boolean isUnderWater(Player player) {
        BlockPos headPos = BlockPos.containing((Position)player.getEyePosition(0.0f));
        return player.level().getFluidState(headPos).is(FluidTags.WATER);
    }

    public static double getDepth(Player player) {
        if (ScubaData.isUnderWater(player)) {
            int surface = TropicraftDimension.getSeaLevel((LevelReader)player.level());
            double depth = (double)surface - player.getEyePosition(0.0f).y();
            return depth;
        }
        return 0.0;
    }

    void tick(Player player) {
        ++this.diveTime;
        if (player.level().getGameTime() % 100L == 0L) {
            this.dirty = true;
        }
        this.updateMaxDepth(ScubaData.getDepth(player));
    }

    public long getDiveTime() {
        return this.diveTime;
    }

    void updateMaxDepth(double depth) {
        if (depth > this.maxDepth) {
            this.maxDepth = depth;
        }
    }

    public double getMaxDepth() {
        return this.maxDepth;
    }

    void updateClient(ServerPlayer target, boolean force) {
        if (this.dirty || force) {
            PacketDistributor.sendToPlayer((ServerPlayer)target, (CustomPacketPayload)new ClientboundUpdateScubaDataPacket(this), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public void copyFrom(ScubaData data) {
        this.diveTime = data.getDiveTime();
        this.maxDepth = data.getMaxDepth();
    }
}

