/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.item.scuba;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.tropicraft.Tropicraft;
import net.tropicraft.core.client.scuba.ModelScubaGear;
import net.tropicraft.core.common.item.TropicraftArmorMaterials;
import net.tropicraft.core.common.item.scuba.ScubaGogglesItem;
import net.tropicraft.core.common.item.scuba.ScubaType;
import org.jetbrains.annotations.Nullable;

public class ScubaArmorItem
extends ArmorItem {
    private final ScubaType type;

    public ScubaArmorItem(ScubaType type, ArmorItem.Type slotType, Item.Properties properties) {
        super(TropicraftArmorMaterials.SCUBA, slotType, properties.durability(slotType.getDurability(10)));
        this.type = type;
    }

    public ScubaType getScubaType() {
        return this.type;
    }

    public boolean providesAir() {
        return false;
    }

    public void tickAir(Player player, EquipmentSlot slot, ItemStack stack) {
    }

    public int addAir(int air, ItemStack stack) {
        return 0;
    }

    public int getRemainingAir(ItemStack stack) {
        return 0;
    }

    public int getMaxAir(ItemStack stack) {
        return 0;
    }

    public ResourceLocation getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, ArmorMaterial.Layer layer, boolean innerModel) {
        return ScubaArmorItem.getArmorTexture(this.type);
    }

    public static ResourceLocation getArmorTexture(ScubaType type) {
        return Tropicraft.location("textures/models/armor/scuba_gear_" + type.getTextureName() + ".png");
    }

    public static class ClientExtensions
    implements IClientItemExtensions {
        private static final ResourceLocation GOGGLES_OVERLAY_TEX_PATH = Tropicraft.location("textures/gui/goggles.png");

        public HumanoidModel<?> getHumanoidArmorModel(LivingEntity entity, ItemStack stack, EquipmentSlot slot, HumanoidModel<?> original) {
            if (stack.isEmpty()) {
                return original;
            }
            HumanoidModel<?> armorModel = this.getArmorModel(slot);
            if (armorModel != null) {
                this.prepareModel(armorModel, entity);
                return armorModel;
            }
            return original;
        }

        @Nullable
        private HumanoidModel<?> getArmorModel(EquipmentSlot armorSlot) {
            return switch (armorSlot) {
                case EquipmentSlot.HEAD -> ModelScubaGear.HEAD;
                case EquipmentSlot.CHEST -> ModelScubaGear.CHEST;
                case EquipmentSlot.FEET -> ModelScubaGear.FEET;
                default -> null;
            };
        }

        private <E extends LivingEntity> void prepareModel(HumanoidModel<E> armorModel, LivingEntity entity) {
            armorModel.prepareMobModel(entity, 0.0f, 0.0f, 1.0f);
            armorModel.crouching = entity.isShiftKeyDown();
            armorModel.young = entity.isBaby();
            armorModel.rightArmPose = !entity.getMainHandItem().isEmpty() ? HumanoidModel.ArmPose.BLOCK : HumanoidModel.ArmPose.EMPTY;
        }

        public void renderHelmetOverlay(ItemStack stack, Player player, int width, int height, float partialTicks) {
            if (stack.getItem() instanceof ScubaGogglesItem) {
                Minecraft mc = Minecraft.getInstance();
                GuiGraphics graphics = new GuiGraphics(mc, mc.renderBuffers().bufferSource());
                RenderSystem.disableDepthTest();
                RenderSystem.depthMask((boolean)false);
                RenderSystem.defaultBlendFunc();
                graphics.blit(GOGGLES_OVERLAY_TEX_PATH, 0, 0, 0, 0.0f, 0.0f, width, height, width, height);
                RenderSystem.depthMask((boolean)true);
                RenderSystem.enableDepthTest();
                graphics.flush();
            }
        }
    }
}

