/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.item;

import com.google.common.base.Suppliers;
import java.util.function.Supplier;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.tropicraft.core.common.item.TropicraftItems;

public enum TropicraftToolTiers implements Tier
{
    BAMBOO((TagKey<Block>)BlockTags.INCORRECT_FOR_WOODEN_TOOL, 110, 1.2f, 1.0f, 6, () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.BAMBOO})),
    ZIRCON((TagKey<Block>)BlockTags.INCORRECT_FOR_STONE_TOOL, 200, 4.5f, 1.0f, 14, () -> Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)TropicraftItems.ZIRCON.get()})),
    EUDIALYTE((TagKey<Block>)BlockTags.INCORRECT_FOR_STONE_TOOL, 750, 6.5f, 2.0f, 14, () -> Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)TropicraftItems.EUDIALYTE.get()})),
    ZIRCONIUM((TagKey<Block>)BlockTags.INCORRECT_FOR_IRON_TOOL, 1800, 8.5f, 3.0f, 10, () -> Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)TropicraftItems.ZIRCONIUM.get()}));

    private final TagKey<Block> incorrectBlockDrops;
    private final int maxUses;
    private final float efficiency;
    private final float attackDamage;
    private final int enchantability;
    private final Supplier<Ingredient> repairMaterial;

    private TropicraftToolTiers(TagKey<Block> incorrectBlockDrops, int maxUsesIn, float efficiencyIn, float attackDamageIn, int enchantabilityIn, Supplier<Ingredient> repairMaterialIn) {
        this.incorrectBlockDrops = incorrectBlockDrops;
        this.maxUses = maxUsesIn;
        this.efficiency = efficiencyIn;
        this.attackDamage = attackDamageIn;
        this.enchantability = enchantabilityIn;
        this.repairMaterial = Suppliers.memoize(repairMaterialIn::get);
    }

    public int getUses() {
        return this.maxUses;
    }

    public float getSpeed() {
        return this.efficiency;
    }

    public float getAttackDamageBonus() {
        return this.attackDamage;
    }

    public TagKey<Block> getIncorrectBlocksForDrops() {
        return this.incorrectBlockDrops;
    }

    public int getEnchantmentValue() {
        return this.enchantability;
    }

    public Ingredient getRepairIngredient() {
        return this.repairMaterial.get();
    }
}

