/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.item;

import com.google.common.collect.Maps;
import java.awt.Color;
import java.util.Map;
import net.minecraft.network.chat.Component;
import net.minecraft.util.FastColor;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.tropicraft.Constants;
import net.tropicraft.core.common.item.ShellItem;
import net.tropicraft.core.common.item.TropicraftDataComponents;
import org.apache.commons.lang3.ArrayUtils;

public class LoveTropicsShellItem
extends ShellItem {
    public LoveTropicsShellItem(Item.Properties properties) {
        super(properties);
    }

    public static int getColor(ItemStack itemstack, int pass) {
        String name = (String)itemstack.get(TropicraftDataComponents.SHELL_NAME);
        if (name != null) {
            return pass == 0 ? -1 : LTUtil.colors.get(name);
        }
        return pass == 0 ? -1 : LTUtil.colors.get(Constants.LT17_NAMES[0]);
    }

    public Component getName(ItemStack stack) {
        String name = (String)stack.get(TropicraftDataComponents.SHELL_NAME);
        if (name == null) {
            return super.getName(stack);
        }
        String type = name.endsWith("s") ? "with_s" : "normal";
        return Component.translatable((String)("item.tropicraft.shell.owned." + type), (Object[])new Object[]{name});
    }

    public static class LTUtil {
        private static final Map<String, Integer> colors = Maps.newHashMap();
        private static final RandomSource rand = RandomSource.create();

        static {
            for (String name : (String[])ArrayUtils.addAll((Object[])Constants.LT17_NAMES, (Object[])Constants.LT18_NAMES)) {
                rand.setSeed((long)name.hashCode());
                colors.put(name, FastColor.ARGB32.opaque((int)Color.HSBtoRGB(rand.nextFloat(), rand.nextFloat() * 0.2f + 0.7f, 1.0f)));
            }
        }
    }
}

