/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.item;

import net.minecraft.client.Minecraft;
import net.minecraft.client.ParticleStatus;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import net.tropicraft.core.common.item.TropicraftArmorMaterials;
import net.tropicraft.core.common.item.TropicraftItems;

@EventBusSubscriber(modid="tropicraft")
public class FireArmorItem
extends ArmorItem {
    public FireArmorItem(ArmorItem.Type slotType, Item.Properties properties) {
        super(TropicraftArmorMaterials.FIRE_ARMOR, slotType, properties);
    }

    @SubscribeEvent
    public static void onPlayerTick(PlayerTickEvent.Post event) {
        Player player = event.getEntity();
        FireArmorItem.tickArmor(player, EquipmentSlot.HEAD);
        FireArmorItem.tickArmor(player, EquipmentSlot.CHEST);
        FireArmorItem.tickArmor(player, EquipmentSlot.LEGS);
        FireArmorItem.tickArmor(player, EquipmentSlot.FEET);
    }

    private static void tickArmor(Player player, EquipmentSlot slot) {
        ItemStack itemStack = player.getItemBySlot(slot);
        Item item = itemStack.getItem();
        if (item instanceof FireArmorItem) {
            FireArmorItem item2 = (FireArmorItem)item;
            item2.onArmorTick(itemStack, player.level(), player, slot);
        }
    }

    private void onArmorTick(ItemStack stack, Level world, Player player, EquipmentSlot slot) {
        if (world.isClientSide) {
            this.clientTick(player);
        } else {
            if (player.isOnFire()) {
                player.clearFire();
            }
            int factor = (int)(40.0 / (0.001 + (double)world.getLightLevelDependentMagicValue(player.blockPosition())));
            if (world.getGameTime() % (long)factor == 0L && world.canSeeSkyFromBelowWater(new BlockPos(Mth.floor((double)player.getX()), Mth.floor((double)(player.getY() + 1.0)), Mth.floor((double)player.getZ())))) {
                stack.hurtAndBreak(-1, (LivingEntity)player, slot);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void clientTick(Player player) {
        ParticleStatus particles;
        if (player.isInWater()) {
            return;
        }
        float range = 0.2f;
        float speed = 0.08f;
        RandomSource rand = RandomSource.create();
        int extraRand = 0;
        Vec3 motion = player.getDeltaMovement();
        double plSpeed = Math.sqrt(motion.x * motion.x + motion.z * motion.z);
        if (plSpeed < (double)0.1f) {
            extraRand = 7;
        }
        if ((particles = (ParticleStatus)Minecraft.getInstance().options.particles().get()) == ParticleStatus.MINIMAL) {
            return;
        }
        if (this == TropicraftItems.FIRE_BOOTS.get()) {
            FluidState fluid2;
            boolean onLava = false;
            boolean inLava = false;
            boolean x = false;
            boolean z = false;
            if (motion.y < 0.0) {
                FluidState fluid = player.level().getFluidState(BlockPos.containing((double)(player.getX() + (double)x), (double)(player.getY() - 2.0), (double)(player.getZ() + (double)z)));
                onLava = fluid.is(FluidTags.LAVA);
            }
            if ((fluid2 = player.level().getFluidState(BlockPos.containing((double)(player.getX() + (double)x), (double)(player.getY() - 1.0), (double)(player.getZ() + (double)z)))).is(FluidTags.LAVA)) {
                inLava = true;
            }
            if (onLava && !inLava) {
                player.setDeltaMovement(motion.multiply(1.0, 0.0, 1.0));
                player.setOnGround(true);
            }
            if (inLava && plSpeed < 0.4) {
                player.setDeltaMovement(motion.multiply(1.5, 1.5, 1.5));
            }
            float look = player.level().getGameTime() * (long)(10 + (onLava ? 10 : 0));
            double dist = 1.0;
            double gatherX = player.getX();
            double gatherY = player.getBoundingBox().minY;
            double gatherZ = player.getZ();
            double motionX = rand.nextFloat() * speed - speed / 2.0f;
            double motionZ = rand.nextFloat() * speed - speed / 2.0f;
            int numFeetParticles = particles == ParticleStatus.DECREASED ? 2 : 11;
            for (int i = 0; i < numFeetParticles + (onLava ? 5 : 0); ++i) {
                motionX = -Math.sin(look / 180.0f * (float)Math.PI) * Math.cos(0.0) * ((double)speed + 0.1 * rand.nextDouble());
                motionZ = Math.cos(look / 180.0f * (float)Math.PI) * Math.cos(0.0) * ((double)speed + 0.1 * rand.nextDouble());
                SimpleParticleType particle = ParticleTypes.FLAME;
                if (rand.nextInt(22) == 0) {
                    particle = ParticleTypes.LARGE_SMOKE;
                }
                if (!onLava && rand.nextInt(1 + extraRand) != 0) continue;
                Vec3 motion1 = player.getDeltaMovement();
                player.level().addParticle((ParticleOptions)particle, gatherX + (double)(rand.nextFloat() * range - range / 2.0f), gatherY + (double)(rand.nextFloat() * range - range / 2.0f), gatherZ + (double)(rand.nextFloat() * range - range / 2.0f), motion1.x + motionX, (double)0.01f, motion1.z + motionZ);
                player.level().addParticle((ParticleOptions)particle, gatherX + (double)(rand.nextFloat() * range - range / 2.0f), gatherY + (double)(rand.nextFloat() * range - range / 2.0f), gatherZ + (double)(rand.nextFloat() * range - range / 2.0f), motion1.x - motionX, (double)0.01f, motion1.z - motionZ);
            }
        } else if (this == TropicraftItems.FIRE_LEGGINGS.get()) {
            SimpleParticleType particle = ParticleTypes.FLAME;
            if (rand.nextInt(2) == 0) {
                particle = ParticleTypes.LARGE_SMOKE;
            }
            if (rand.nextInt(3 + extraRand) == 0) {
                player.level().addParticle((ParticleOptions)particle, player.getX() + (double)(rand.nextFloat() * range - range / 2.0f), player.getY() - (double)0.8f + (double)(rand.nextFloat() * range - range / 2.0f), player.getZ() + (double)(rand.nextFloat() * range - range / 2.0f), (double)(rand.nextFloat() * speed - speed / 2.0f), (double)-0.05f, (double)(rand.nextFloat() * speed - speed / 2.0f));
            }
        } else if (this == TropicraftItems.FIRE_CHESTPLATE.get()) {
            float look = -180.0f;
            double dist = 0.5;
            double gatherX = player.getX() + -Math.sin((player.getYRot() + look) / 180.0f * (float)Math.PI) * Math.cos(player.getXRot() / 180.0f * (float)Math.PI) * dist;
            double gatherZ = player.getZ() + Math.cos((player.getYRot() + look) / 180.0f * (float)Math.PI) * Math.cos(player.getXRot() / 180.0f * (float)Math.PI) * dist;
            SimpleParticleType particle = ParticleTypes.FLAME;
            if (rand.nextInt(2) == 0) {
                particle = ParticleTypes.LARGE_SMOKE;
            }
            if (rand.nextInt(1 + extraRand) == 0) {
                player.level().addParticle((ParticleOptions)particle, gatherX + (double)(rand.nextFloat() * range - range / 2.0f), player.getY() - (double)0.4f + (double)(rand.nextFloat() * range - range / 2.0f), gatherZ + (double)(rand.nextFloat() * range - range / 2.0f), (double)(rand.nextFloat() * speed - speed / 2.0f), (double)-0.01f, (double)(rand.nextFloat() * speed - speed / 2.0f));
            }
        } else if (this == TropicraftItems.FIRE_HELMET.get()) {
            float look = -180.0f;
            double dist = 0.5;
            range = 2.0f;
            double gatherX = player.getX() + -Math.sin((player.getYRot() + look) / 180.0f * (float)Math.PI) * Math.cos(player.getXRot() / 180.0f * (float)Math.PI) * dist;
            double gatherZ = player.getZ() + Math.cos((player.getYRot() + look) / 180.0f * (float)Math.PI) * Math.cos(player.getXRot() / 180.0f * (float)Math.PI) * dist;
            SimpleParticleType particle = ParticleTypes.FLAME;
            if (rand.nextInt(2) == 0) {
                particle = ParticleTypes.LARGE_SMOKE;
            }
            if (rand.nextInt(2) == 0) {
                player.level().addParticle((ParticleOptions)particle, gatherX + (double)(rand.nextFloat() * range - range / 2.0f), player.getY() + (double)0.7f, gatherZ + (double)(rand.nextFloat() * range - range / 2.0f), (double)(rand.nextFloat() * speed - speed / 2.0f), (double)-0.01f, (double)(rand.nextFloat() * speed - speed / 2.0f));
            }
        }
    }
}

