/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.entity.underdasea;

import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.HitResult;
import net.neoforged.neoforge.entity.IEntityWithComplexSpawn;
import net.tropicraft.core.common.entity.TropicraftEntities;
import net.tropicraft.core.common.entity.egg.EggEntity;
import net.tropicraft.core.common.entity.egg.StarfishEggEntity;
import net.tropicraft.core.common.entity.underdasea.EchinodermEntity;
import net.tropicraft.core.common.entity.underdasea.StarfishType;
import net.tropicraft.core.common.item.TropicraftItems;

public class StarfishEntity
extends EchinodermEntity
implements IEntityWithComplexSpawn {
    public static final float BABY_WIDTH = 0.25f;
    public static final float ADULT_WIDTH = 1.0f;
    public static final float BABY_HEIGHT = 0.1f;
    public static final float ADULT_HEIGHT = 0.2f;
    public static final float BABY_YOFFSET = 0.03125f;
    public static final float ADULT_YOFFSET = 0.03125f;
    private static final EntityDataAccessor<Byte> DATA_STARFISH_TYPE = SynchedEntityData.defineId(StarfishEntity.class, (EntityDataSerializer)EntityDataSerializers.BYTE);

    public StarfishEntity(EntityType<? extends StarfishEntity> type, Level world) {
        super(type, world);
        this.xpReward = 5;
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor world, DifficultyInstance difficultyInstance, MobSpawnType spawnReason, @Nullable SpawnGroupData entityData) {
        this.setStarfishType(StarfishType.values()[this.random.nextInt(StarfishType.values().length)]);
        return super.finalizeSpawn(world, difficultyInstance, spawnReason, entityData);
    }

    @Override
    public void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_STARFISH_TYPE, (Object)0);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return WaterAnimal.createMobAttributes().add(Attributes.MAX_HEALTH, 10.0);
    }

    public StarfishType getStarfishType() {
        return StarfishType.values()[(Byte)this.entityData.get(DATA_STARFISH_TYPE)];
    }

    public void setStarfishType(StarfishType starfishType) {
        this.entityData.set(DATA_STARFISH_TYPE, (Object)((byte)starfishType.ordinal()));
    }

    @Override
    public void addAdditionalSaveData(CompoundTag nbt) {
        super.addAdditionalSaveData(nbt);
        nbt.putByte("StarfishType", (byte)this.getStarfishType().ordinal());
    }

    @Override
    public void readAdditionalSaveData(CompoundTag nbt) {
        super.readAdditionalSaveData(nbt);
        if (nbt.contains("StarfishType")) {
            this.setStarfishType(StarfishType.values()[nbt.getByte("StarfishType")]);
        } else {
            this.setStarfishType(StarfishType.RED);
        }
    }

    public void writeSpawnData(RegistryFriendlyByteBuf buffer) {
        buffer.writeByte(this.getStarfishType().ordinal());
    }

    public void readSpawnData(RegistryFriendlyByteBuf additionalData) {
        this.setStarfishType(StarfishType.values()[additionalData.readByte()]);
    }

    @Override
    public EggEntity createEgg() {
        StarfishEggEntity entity = new StarfishEggEntity((EntityType<? extends StarfishEggEntity>)((EntityType)TropicraftEntities.STARFISH_EGG.get()), this.level());
        entity.setStarfishType(this.getStarfishType());
        return entity;
    }

    @Override
    public float getBabyWidth() {
        return 0.25f;
    }

    @Override
    public float getAdultWidth() {
        return 1.0f;
    }

    @Override
    public float getBabyHeight() {
        return 0.1f;
    }

    @Override
    public float getAdultHeight() {
        return 0.2f;
    }

    @Override
    public float getBabyYOffset() {
        return 0.03125f;
    }

    @Override
    public float getAdultYOffset() {
        return 0.03125f;
    }

    @Override
    public boolean isPotentialMate(EchinodermEntity other) {
        return super.isPotentialMate(other) && ((StarfishEntity)other).getStarfishType() == this.getStarfishType();
    }

    public ItemStack getPickedResult(HitResult target) {
        return new ItemStack((ItemLike)TropicraftItems.STARFISH.get());
    }
}

