/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.entity.underdasea;

import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.AbstractFish;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class EagleRayEntity
extends AbstractFish {
    public static final int WING_JOINTS = 10;
    public static final int WING_CYCLE_TICKS = 60;
    public static final float PHASES = 0.33f;
    private float[] wingAmplitudes = new float[10];
    private float[] prevWingAmplitudes = new float[10];
    private int animationTicks;

    public EagleRayEntity(EntityType<? extends EagleRayEntity> type, Level world) {
        super(type, world);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return AbstractFish.createAttributes().add(Attributes.MAX_HEALTH, 10.0);
    }

    protected InteractionResult mobInteract(Player player, InteractionHand hand) {
        return InteractionResult.PASS;
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide) {
            this.animationTicks = this.animationTicks < 60 ? ++this.animationTicks : 0;
            this.updateWingAmplitudes();
        }
    }

    private void updateWingAmplitudes() {
        float[] temp = this.prevWingAmplitudes;
        this.prevWingAmplitudes = this.wingAmplitudes;
        this.wingAmplitudes = temp;
        for (int i = 1; i < 10; ++i) {
            this.wingAmplitudes[i] = this.amplitudeFunc(i);
        }
    }

    private float decayFunc(float n) {
        return n / 9.0f;
    }

    private float amplitudeFunc(float n) {
        double angle = Math.PI * 2 * (double)(-n) / 9.0;
        return this.decayFunc(n) * Mth.sin((float)((float)((double)(this.getAnimationProgress() * 2.0f) * Math.PI + (double)0.33f * angle)));
    }

    private float getAnimationProgress() {
        return (float)this.animationTicks / 60.0f;
    }

    public float[] getWingAmplitudes() {
        return this.wingAmplitudes;
    }

    public float[] getPrevWingAmplitudes() {
        return this.prevWingAmplitudes;
    }

    public ItemStack getBucketItemStack() {
        return ItemStack.EMPTY;
    }

    protected SoundEvent getFlopSound() {
        return SoundEvents.SALMON_FLOP;
    }
}

